/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspSupplierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SuplrEvalRspSupplierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Supplier
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalRspSupplierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalRspSupplier extends VdmEntity<SuplrEvalRspSupplier>
{

    /**
     * Selector for all available fields of SuplrEvalRspSupplier.
     *
     */
    public final static SuplrEvalRspSupplierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspPartyUUID</b>
     * </p>
     *
     * @return Evaluation Response Party UUID
     */
    @Key
    @SerializedName( "SuplrEvalRspPartyUUID" )
    @JsonProperty( "SuplrEvalRspPartyUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspPartyUUID" )
    private UUID suplrEvalRspPartyUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspPartyUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSupplierField<UUID> SUPLR_EVAL_RSP_PARTY_UUID =
        new SuplrEvalRspSupplierField<UUID>("SuplrEvalRspPartyUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @return Evaluation Response UUID
     */
    @SerializedName( "SuplrEvalRspUUID" )
    @JsonProperty( "SuplrEvalRspUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspUUID" )
    private UUID suplrEvalRspUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSupplierField<UUID> SUPLR_EVAL_RSP_UUID =
        new SuplrEvalRspSupplierField<UUID>("SuplrEvalRspUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static SuplrEvalRspSupplierField<String> BUSINESS_PARTNER =
        new SuplrEvalRspSupplierField<String>("BusinessPartner");

    @Nonnull
    @Override
    public Class<SuplrEvalRspSupplier> getType()
    {
        return SuplrEvalRspSupplier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspPartyUUID</b>
     * </p>
     *
     * @param suplrEvalRspPartyUUID
     *            Evaluation Response Party UUID
     */
    public void setSuplrEvalRspPartyUUID( @Nullable final UUID suplrEvalRspPartyUUID )
    {
        rememberChangedField("SuplrEvalRspPartyUUID", this.suplrEvalRspPartyUUID);
        this.suplrEvalRspPartyUUID = suplrEvalRspPartyUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     */
    public void setSuplrEvalRspUUID( @Nullable final UUID suplrEvalRspUUID )
    {
        rememberChangedField("SuplrEvalRspUUID", this.suplrEvalRspUUID);
        this.suplrEvalRspUUID = suplrEvalRspUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalRspSupplier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalRspPartyUUID", getSuplrEvalRspPartyUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalRspPartyUUID", getSuplrEvalRspPartyUUID());
        values.put("SuplrEvalRspUUID", getSuplrEvalRspUUID());
        values.put("BusinessPartner", getBusinessPartner());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalRspPartyUUID") ) {
                final Object value = values.remove("SuplrEvalRspPartyUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspPartyUUID())) ) {
                    setSuplrEvalRspPartyUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalRspUUID") ) {
                final Object value = values.remove("SuplrEvalRspUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspUUID())) ) {
                    setSuplrEvalRspUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalRspSupplierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalRspSupplierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalRspSupplierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalRspSupplierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH);
    }

}
