/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SupplierEvaluationResponseField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SupplierEvaluationResponseLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SupplierEvaluationResponseOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SupplierEvaluationResponseSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Evaluation Response
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplierEvaluationResponseType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplierEvaluationResponse extends VdmEntity<SupplierEvaluationResponse>
{

    /**
     * Selector for all available fields of SupplierEvaluationResponse.
     *
     */
    public final static SupplierEvaluationResponseSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @return Evaluation Response UUID
     */
    @Key
    @SerializedName( "SuplrEvalRspUUID" )
    @JsonProperty( "SuplrEvalRspUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspUUID" )
    private UUID suplrEvalRspUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspUUID</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<UUID> SUPLR_EVAL_RSP_UUID =
        new SupplierEvaluationResponseField<UUID>("SuplrEvalRspUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @SerializedName( "SuplrEvalReqUUID" )
    @JsonProperty( "SuplrEvalReqUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalReqUUID" )
    private UUID suplrEvalReqUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalReqUUID</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<UUID> SUPLR_EVAL_REQ_UUID =
        new SupplierEvaluationResponseField<UUID>("SuplrEvalReqUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @return Purchasing Category UUID
     */
    @SerializedName( "PurgCatUUID" )
    @JsonProperty( "PurgCatUUID" )
    @Nullable
    @ODataField( odataName = "PurgCatUUID" )
    private UUID purgCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatUUID</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<UUID> PURG_CAT_UUID =
        new SupplierEvaluationResponseField<UUID>("PurgCatUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalResponse</b>
     * </p>
     *
     * @return Evaluation Response
     */
    @SerializedName( "SupplierEvalResponse" )
    @JsonProperty( "SupplierEvalResponse" )
    @Nullable
    @ODataField( odataName = "SupplierEvalResponse" )
    private String supplierEvalResponse;
    /**
     * Use with available fluent helpers to apply the <b>SupplierEvalResponse</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<String> SUPPLIER_EVAL_RESPONSE =
        new SupplierEvaluationResponseField<String>("SupplierEvalResponse");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspName</b>
     * </p>
     *
     * @return Name of a Supplier Evaluation Response
     */
    @SerializedName( "SuplrEvalRspName" )
    @JsonProperty( "SuplrEvalRspName" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspName" )
    private String suplrEvalRspName;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspName</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<String> SUPLR_EVAL_RSP_NAME =
        new SupplierEvaluationResponseField<String>("SuplrEvalRspName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<String> LANGUAGE =
        new SupplierEvaluationResponseField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created-By Name
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<String> CREATED_BY_USER =
        new SupplierEvaluationResponseField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed-By Name
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<String> LAST_CHANGED_BY_USER =
        new SupplierEvaluationResponseField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalStartDate</b>
     * </p>
     *
     * @return Start Date
     */
    @SerializedName( "SuplrEvalStartDate" )
    @JsonProperty( "SuplrEvalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SuplrEvalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime suplrEvalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalStartDate</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<LocalDateTime> SUPLR_EVAL_START_DATE =
        new SupplierEvaluationResponseField<LocalDateTime>("SuplrEvalStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalEndDate</b>
     * </p>
     *
     * @return End Date
     */
    @SerializedName( "SuplrEvalEndDate" )
    @JsonProperty( "SuplrEvalEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SuplrEvalEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime suplrEvalEndDate;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalEndDate</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<LocalDateTime> SUPLR_EVAL_END_DATE =
        new SupplierEvaluationResponseField<LocalDateTime>("SuplrEvalEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalDeadlineDate</b>
     * </p>
     *
     * @return Deadline
     */
    @SerializedName( "SuplrEvalDeadlineDate" )
    @JsonProperty( "SuplrEvalDeadlineDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SuplrEvalDeadlineDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime suplrEvalDeadlineDate;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalDeadlineDate</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<LocalDateTime> SUPLR_EVAL_DEADLINE_DATE =
        new SupplierEvaluationResponseField<LocalDateTime>("SuplrEvalDeadlineDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new SupplierEvaluationResponseField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalSubmissionDateTime</b>
     * </p>
     *
     * @return Submission Date
     */
    @SerializedName( "SuplrEvalSubmissionDateTime" )
    @JsonProperty( "SuplrEvalSubmissionDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SuplrEvalSubmissionDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime suplrEvalSubmissionDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalSubmissionDateTime</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<ZonedDateTime> SUPLR_EVAL_SUBMISSION_DATE_TIME =
        new SupplierEvaluationResponseField<ZonedDateTime>("SuplrEvalSubmissionDateTime");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<ZonedDateTime> CREATION_DATE_TIME =
        new SupplierEvaluationResponseField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspLifecycleStatus</b>
     * </p>
     *
     * @return General Data Element for Status Codes
     */
    @SerializedName( "SuplrEvalRspLifecycleStatus" )
    @JsonProperty( "SuplrEvalRspLifecycleStatus" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRspLifecycleStatus" )
    private String suplrEvalRspLifecycleStatus;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRspLifecycleStatus</b> field to query operations.
     *
     */
    public final static SupplierEvaluationResponseField<String> SUPLR_EVAL_RSP_LIFECYCLE_STATUS =
        new SupplierEvaluationResponseField<String>("SuplrEvalRspLifecycleStatus");
    /**
     * Navigation property <b>to_SuplrEvalRspAppraiser</b> for <b>SupplierEvaluationResponse</b> to single
     * <b>SuplrEvalRspAppraiser</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspAppraiser" )
    @JsonProperty( "to_SuplrEvalRspAppraiser" )
    @ODataField( odataName = "to_SuplrEvalRspAppraiser" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrEvalRspAppraiser toSuplrEvalRspAppraiser;
    /**
     * Navigation property <b>to_SuplrEvalRspExternalName</b> for <b>SupplierEvaluationResponse</b> to multiple
     * <b>SuplrEvalRspExternalName</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspExternalName" )
    @JsonProperty( "to_SuplrEvalRspExternalName" )
    @ODataField( odataName = "to_SuplrEvalRspExternalName" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalRspExternalName> toSuplrEvalRspExternalName;
    /**
     * Navigation property <b>to_SuplrEvalRspIntroduction</b> for <b>SupplierEvaluationResponse</b> to multiple
     * <b>SuplrEvalRspIntroduction</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspIntroduction" )
    @JsonProperty( "to_SuplrEvalRspIntroduction" )
    @ODataField( odataName = "to_SuplrEvalRspIntroduction" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalRspIntroduction> toSuplrEvalRspIntroduction;
    /**
     * Navigation property <b>to_SuplrEvalRspLanguage</b> for <b>SupplierEvaluationResponse</b> to multiple
     * <b>SuplrEvalRspLanguage</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspLanguage" )
    @JsonProperty( "to_SuplrEvalRspLanguage" )
    @ODataField( odataName = "to_SuplrEvalRspLanguage" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalRspLanguage> toSuplrEvalRspLanguage;
    /**
     * Navigation property <b>to_SuplrEvalRspPurchaserResp</b> for <b>SupplierEvaluationResponse</b> to single
     * <b>SuplrEvalRspPurchaserResp</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspPurchaserResp" )
    @JsonProperty( "to_SuplrEvalRspPurchaserResp" )
    @ODataField( odataName = "to_SuplrEvalRspPurchaserResp" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrEvalRspPurchaserResp toSuplrEvalRspPurchaserResp;
    /**
     * Navigation property <b>to_SuplrEvalRspRootQnaire</b> for <b>SupplierEvaluationResponse</b> to single
     * <b>SuplrEvalRspRootQnaire</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspRootQnaire" )
    @JsonProperty( "to_SuplrEvalRspRootQnaire" )
    @ODataField( odataName = "to_SuplrEvalRspRootQnaire" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrEvalRspRootQnaire toSuplrEvalRspRootQnaire;
    /**
     * Navigation property <b>to_SuplrEvalRspSupplier</b> for <b>SupplierEvaluationResponse</b> to single
     * <b>SuplrEvalRspSupplier</b>.
     *
     */
    @SerializedName( "to_SuplrEvalRspSupplier" )
    @JsonProperty( "to_SuplrEvalRspSupplier" )
    @ODataField( odataName = "to_SuplrEvalRspSupplier" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrEvalRspSupplier toSuplrEvalRspSupplier;
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspAppraiser</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierEvaluationResponseOneToOneLink<SuplrEvalRspAppraiser> TO_SUPLR_EVAL_RSP_APPRAISER =
        new SupplierEvaluationResponseOneToOneLink<SuplrEvalRspAppraiser>("to_SuplrEvalRspAppraiser");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspExternalName</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierEvaluationResponseLink<SuplrEvalRspExternalName> TO_SUPLR_EVAL_RSP_EXTERNAL_NAME =
        new SupplierEvaluationResponseLink<SuplrEvalRspExternalName>("to_SuplrEvalRspExternalName");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspIntroduction</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierEvaluationResponseLink<SuplrEvalRspIntroduction> TO_SUPLR_EVAL_RSP_INTRODUCTION =
        new SupplierEvaluationResponseLink<SuplrEvalRspIntroduction>("to_SuplrEvalRspIntroduction");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspLanguage</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierEvaluationResponseLink<SuplrEvalRspLanguage> TO_SUPLR_EVAL_RSP_LANGUAGE =
        new SupplierEvaluationResponseLink<SuplrEvalRspLanguage>("to_SuplrEvalRspLanguage");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspPurchaserResp</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierEvaluationResponseOneToOneLink<SuplrEvalRspPurchaserResp> TO_SUPLR_EVAL_RSP_PURCHASER_RESP =
        new SupplierEvaluationResponseOneToOneLink<SuplrEvalRspPurchaserResp>("to_SuplrEvalRspPurchaserResp");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspRootQnaire</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierEvaluationResponseOneToOneLink<SuplrEvalRspRootQnaire> TO_SUPLR_EVAL_RSP_ROOT_QNAIRE =
        new SupplierEvaluationResponseOneToOneLink<SuplrEvalRspRootQnaire>("to_SuplrEvalRspRootQnaire");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalRspSupplier</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierEvaluationResponseOneToOneLink<SuplrEvalRspSupplier> TO_SUPLR_EVAL_RSP_SUPPLIER =
        new SupplierEvaluationResponseOneToOneLink<SuplrEvalRspSupplier>("to_SuplrEvalRspSupplier");

    @Nonnull
    @Override
    public Class<SupplierEvaluationResponse> getType()
    {
        return SupplierEvaluationResponse.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspUUID</b>
     * </p>
     *
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     */
    public void setSuplrEvalRspUUID( @Nullable final UUID suplrEvalRspUUID )
    {
        rememberChangedField("SuplrEvalRspUUID", this.suplrEvalRspUUID);
        this.suplrEvalRspUUID = suplrEvalRspUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqUUID</b>
     * </p>
     *
     * @param suplrEvalReqUUID
     *            NodeID
     */
    public void setSuplrEvalReqUUID( @Nullable final UUID suplrEvalReqUUID )
    {
        rememberChangedField("SuplrEvalReqUUID", this.suplrEvalReqUUID);
        this.suplrEvalReqUUID = suplrEvalReqUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @param purgCatUUID
     *            Purchasing Category UUID
     */
    public void setPurgCatUUID( @Nullable final UUID purgCatUUID )
    {
        rememberChangedField("PurgCatUUID", this.purgCatUUID);
        this.purgCatUUID = purgCatUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalResponse</b>
     * </p>
     *
     * @param supplierEvalResponse
     *            Evaluation Response
     */
    public void setSupplierEvalResponse( @Nullable final String supplierEvalResponse )
    {
        rememberChangedField("SupplierEvalResponse", this.supplierEvalResponse);
        this.supplierEvalResponse = supplierEvalResponse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspName</b>
     * </p>
     *
     * @param suplrEvalRspName
     *            Name of a Supplier Evaluation Response
     */
    public void setSuplrEvalRspName( @Nullable final String suplrEvalRspName )
    {
        rememberChangedField("SuplrEvalRspName", this.suplrEvalRspName);
        this.suplrEvalRspName = suplrEvalRspName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created-By Name
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed-By Name
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalStartDate</b>
     * </p>
     *
     * @param suplrEvalStartDate
     *            Start Date
     */
    public void setSuplrEvalStartDate( @Nullable final LocalDateTime suplrEvalStartDate )
    {
        rememberChangedField("SuplrEvalStartDate", this.suplrEvalStartDate);
        this.suplrEvalStartDate = suplrEvalStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalEndDate</b>
     * </p>
     *
     * @param suplrEvalEndDate
     *            End Date
     */
    public void setSuplrEvalEndDate( @Nullable final LocalDateTime suplrEvalEndDate )
    {
        rememberChangedField("SuplrEvalEndDate", this.suplrEvalEndDate);
        this.suplrEvalEndDate = suplrEvalEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalDeadlineDate</b>
     * </p>
     *
     * @param suplrEvalDeadlineDate
     *            Deadline
     */
    public void setSuplrEvalDeadlineDate( @Nullable final LocalDateTime suplrEvalDeadlineDate )
    {
        rememberChangedField("SuplrEvalDeadlineDate", this.suplrEvalDeadlineDate);
        this.suplrEvalDeadlineDate = suplrEvalDeadlineDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Changed On
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalSubmissionDateTime</b>
     * </p>
     *
     * @param suplrEvalSubmissionDateTime
     *            Submission Date
     */
    public void setSuplrEvalSubmissionDateTime( @Nullable final ZonedDateTime suplrEvalSubmissionDateTime )
    {
        rememberChangedField("SuplrEvalSubmissionDateTime", this.suplrEvalSubmissionDateTime);
        this.suplrEvalSubmissionDateTime = suplrEvalSubmissionDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Created On
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRspLifecycleStatus</b>
     * </p>
     *
     * @param suplrEvalRspLifecycleStatus
     *            General Data Element for Status Codes
     */
    public void setSuplrEvalRspLifecycleStatus( @Nullable final String suplrEvalRspLifecycleStatus )
    {
        rememberChangedField("SuplrEvalRspLifecycleStatus", this.suplrEvalRspLifecycleStatus);
        this.suplrEvalRspLifecycleStatus = suplrEvalRspLifecycleStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SupplierEvaluationResponse";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalRspUUID", getSuplrEvalRspUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalRspUUID", getSuplrEvalRspUUID());
        values.put("SuplrEvalReqUUID", getSuplrEvalReqUUID());
        values.put("PurgCatUUID", getPurgCatUUID());
        values.put("SupplierEvalResponse", getSupplierEvalResponse());
        values.put("SuplrEvalRspName", getSuplrEvalRspName());
        values.put("Language", getLanguage());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("SuplrEvalStartDate", getSuplrEvalStartDate());
        values.put("SuplrEvalEndDate", getSuplrEvalEndDate());
        values.put("SuplrEvalDeadlineDate", getSuplrEvalDeadlineDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("SuplrEvalSubmissionDateTime", getSuplrEvalSubmissionDateTime());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("SuplrEvalRspLifecycleStatus", getSuplrEvalRspLifecycleStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalRspUUID") ) {
                final Object value = values.remove("SuplrEvalRspUUID");
                if( (value == null) || (!value.equals(getSuplrEvalRspUUID())) ) {
                    setSuplrEvalRspUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalReqUUID") ) {
                final Object value = values.remove("SuplrEvalReqUUID");
                if( (value == null) || (!value.equals(getSuplrEvalReqUUID())) ) {
                    setSuplrEvalReqUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurgCatUUID") ) {
                final Object value = values.remove("PurgCatUUID");
                if( (value == null) || (!value.equals(getPurgCatUUID())) ) {
                    setPurgCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplierEvalResponse") ) {
                final Object value = values.remove("SupplierEvalResponse");
                if( (value == null) || (!value.equals(getSupplierEvalResponse())) ) {
                    setSupplierEvalResponse(((String) value));
                }
            }
            if( values.containsKey("SuplrEvalRspName") ) {
                final Object value = values.remove("SuplrEvalRspName");
                if( (value == null) || (!value.equals(getSuplrEvalRspName())) ) {
                    setSuplrEvalRspName(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("SuplrEvalStartDate") ) {
                final Object value = values.remove("SuplrEvalStartDate");
                if( (value == null) || (!value.equals(getSuplrEvalStartDate())) ) {
                    setSuplrEvalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SuplrEvalEndDate") ) {
                final Object value = values.remove("SuplrEvalEndDate");
                if( (value == null) || (!value.equals(getSuplrEvalEndDate())) ) {
                    setSuplrEvalEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SuplrEvalDeadlineDate") ) {
                final Object value = values.remove("SuplrEvalDeadlineDate");
                if( (value == null) || (!value.equals(getSuplrEvalDeadlineDate())) ) {
                    setSuplrEvalDeadlineDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SuplrEvalSubmissionDateTime") ) {
                final Object value = values.remove("SuplrEvalSubmissionDateTime");
                if( (value == null) || (!value.equals(getSuplrEvalSubmissionDateTime())) ) {
                    setSuplrEvalSubmissionDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SuplrEvalRspLifecycleStatus") ) {
                final Object value = values.remove("SuplrEvalRspLifecycleStatus");
                if( (value == null) || (!value.equals(getSuplrEvalRspLifecycleStatus())) ) {
                    setSuplrEvalRspLifecycleStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SuplrEvalRspAppraiser") ) {
                final Object value = (values).remove("to_SuplrEvalRspAppraiser");
                if( value instanceof Map ) {
                    if( toSuplrEvalRspAppraiser == null ) {
                        toSuplrEvalRspAppraiser = new SuplrEvalRspAppraiser();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrEvalRspAppraiser.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrEvalRspExternalName") ) {
                final Object value = (values).remove("to_SuplrEvalRspExternalName");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalRspExternalName == null ) {
                        toSuplrEvalRspExternalName = Lists.newArrayList();
                    } else {
                        toSuplrEvalRspExternalName = Lists.newArrayList(toSuplrEvalRspExternalName);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalRspExternalName entity;
                        if( toSuplrEvalRspExternalName.size() > i ) {
                            entity = toSuplrEvalRspExternalName.get(i);
                        } else {
                            entity = new SuplrEvalRspExternalName();
                            toSuplrEvalRspExternalName.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SuplrEvalRspIntroduction") ) {
                final Object value = (values).remove("to_SuplrEvalRspIntroduction");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalRspIntroduction == null ) {
                        toSuplrEvalRspIntroduction = Lists.newArrayList();
                    } else {
                        toSuplrEvalRspIntroduction = Lists.newArrayList(toSuplrEvalRspIntroduction);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalRspIntroduction entity;
                        if( toSuplrEvalRspIntroduction.size() > i ) {
                            entity = toSuplrEvalRspIntroduction.get(i);
                        } else {
                            entity = new SuplrEvalRspIntroduction();
                            toSuplrEvalRspIntroduction.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SuplrEvalRspLanguage") ) {
                final Object value = (values).remove("to_SuplrEvalRspLanguage");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalRspLanguage == null ) {
                        toSuplrEvalRspLanguage = Lists.newArrayList();
                    } else {
                        toSuplrEvalRspLanguage = Lists.newArrayList(toSuplrEvalRspLanguage);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalRspLanguage entity;
                        if( toSuplrEvalRspLanguage.size() > i ) {
                            entity = toSuplrEvalRspLanguage.get(i);
                        } else {
                            entity = new SuplrEvalRspLanguage();
                            toSuplrEvalRspLanguage.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SuplrEvalRspPurchaserResp") ) {
                final Object value = (values).remove("to_SuplrEvalRspPurchaserResp");
                if( value instanceof Map ) {
                    if( toSuplrEvalRspPurchaserResp == null ) {
                        toSuplrEvalRspPurchaserResp = new SuplrEvalRspPurchaserResp();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrEvalRspPurchaserResp.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrEvalRspRootQnaire") ) {
                final Object value = (values).remove("to_SuplrEvalRspRootQnaire");
                if( value instanceof Map ) {
                    if( toSuplrEvalRspRootQnaire == null ) {
                        toSuplrEvalRspRootQnaire = new SuplrEvalRspRootQnaire();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrEvalRspRootQnaire.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrEvalRspSupplier") ) {
                final Object value = (values).remove("to_SuplrEvalRspSupplier");
                if( value instanceof Map ) {
                    if( toSuplrEvalRspSupplier == null ) {
                        toSuplrEvalRspSupplier = new SuplrEvalRspSupplier();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrEvalRspSupplier.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SupplierEvaluationResponseField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SupplierEvaluationResponseField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierEvaluationResponseField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierEvaluationResponseField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSuplrEvalRspAppraiser != null ) {
            (values).put("to_SuplrEvalRspAppraiser", toSuplrEvalRspAppraiser);
        }
        if( toSuplrEvalRspExternalName != null ) {
            (values).put("to_SuplrEvalRspExternalName", toSuplrEvalRspExternalName);
        }
        if( toSuplrEvalRspIntroduction != null ) {
            (values).put("to_SuplrEvalRspIntroduction", toSuplrEvalRspIntroduction);
        }
        if( toSuplrEvalRspLanguage != null ) {
            (values).put("to_SuplrEvalRspLanguage", toSuplrEvalRspLanguage);
        }
        if( toSuplrEvalRspPurchaserResp != null ) {
            (values).put("to_SuplrEvalRspPurchaserResp", toSuplrEvalRspPurchaserResp);
        }
        if( toSuplrEvalRspRootQnaire != null ) {
            (values).put("to_SuplrEvalRspRootQnaire", toSuplrEvalRspRootQnaire);
        }
        if( toSuplrEvalRspSupplier != null ) {
            (values).put("to_SuplrEvalRspSupplier", toSuplrEvalRspSupplier);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrEvalRspAppraiser</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SuplrEvalRspAppraiser</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrEvalRspAppraiser</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalRspAppraiser fetchSuplrEvalRspAppraiser()
    {
        return fetchFieldAsSingle("to_SuplrEvalRspAppraiser", SuplrEvalRspAppraiser.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspAppraiser</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspAppraiser</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspAppraiser</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspAppraiser</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalRspAppraiser getSuplrEvalRspAppraiserOrFetch()
    {
        if( toSuplrEvalRspAppraiser == null ) {
            toSuplrEvalRspAppraiser = fetchSuplrEvalRspAppraiser();
        }
        return toSuplrEvalRspAppraiser;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspAppraiser</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspAppraiser</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierEvaluationResponse</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspAppraiser</b> is already loaded, the result
     *         will contain the <b>SuplrEvalRspAppraiser</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrEvalRspAppraiser> getSuplrEvalRspAppraiserIfPresent()
    {
        return Option.of(toSuplrEvalRspAppraiser);
    }

    /**
     * Overwrites the associated <b>SuplrEvalRspAppraiser</b> entity for the loaded navigation property
     * <b>to_SuplrEvalRspAppraiser</b>.
     *
     * @param value
     *            New <b>SuplrEvalRspAppraiser</b> entity.
     */
    public void setSuplrEvalRspAppraiser( final SuplrEvalRspAppraiser value )
    {
        toSuplrEvalRspAppraiser = value;
    }

    /**
     * Fetches the <b>SuplrEvalRspExternalName</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SuplrEvalRspExternalName</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalRspExternalName</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspExternalName> fetchSuplrEvalRspExternalName()
    {
        return fetchFieldAsList("to_SuplrEvalRspExternalName", SuplrEvalRspExternalName.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspExternalName</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspExternalName</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspExternalName</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspExternalName</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspExternalName> getSuplrEvalRspExternalNameOrFetch()
    {
        if( toSuplrEvalRspExternalName == null ) {
            toSuplrEvalRspExternalName = fetchSuplrEvalRspExternalName();
        }
        return toSuplrEvalRspExternalName;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspExternalName</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspExternalName</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierEvaluationResponse</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspExternalName</b> is already loaded, the
     *         result will contain the <b>SuplrEvalRspExternalName</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalRspExternalName>> getSuplrEvalRspExternalNameIfPresent()
    {
        return Option.of(toSuplrEvalRspExternalName);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalRspExternalName</b> entities for the loaded navigation property
     * <b>to_SuplrEvalRspExternalName</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspExternalName</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalRspExternalName</b> entities.
     */
    public void setSuplrEvalRspExternalName( @Nonnull final List<SuplrEvalRspExternalName> value )
    {
        if( toSuplrEvalRspExternalName == null ) {
            toSuplrEvalRspExternalName = Lists.newArrayList();
        }
        toSuplrEvalRspExternalName.clear();
        toSuplrEvalRspExternalName.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalRspExternalName</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspExternalName</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspExternalName</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalRspExternalName</b> entities.
     */
    public void addSuplrEvalRspExternalName( SuplrEvalRspExternalName... entity )
    {
        if( toSuplrEvalRspExternalName == null ) {
            toSuplrEvalRspExternalName = Lists.newArrayList();
        }
        toSuplrEvalRspExternalName.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrEvalRspIntroduction</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SuplrEvalRspIntroduction</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalRspIntroduction</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspIntroduction> fetchSuplrEvalRspIntroduction()
    {
        return fetchFieldAsList("to_SuplrEvalRspIntroduction", SuplrEvalRspIntroduction.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspIntroduction</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspIntroduction</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspIntroduction</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspIntroduction</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspIntroduction> getSuplrEvalRspIntroductionOrFetch()
    {
        if( toSuplrEvalRspIntroduction == null ) {
            toSuplrEvalRspIntroduction = fetchSuplrEvalRspIntroduction();
        }
        return toSuplrEvalRspIntroduction;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspIntroduction</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspIntroduction</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierEvaluationResponse</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspIntroduction</b> is already loaded, the
     *         result will contain the <b>SuplrEvalRspIntroduction</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalRspIntroduction>> getSuplrEvalRspIntroductionIfPresent()
    {
        return Option.of(toSuplrEvalRspIntroduction);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalRspIntroduction</b> entities for the loaded navigation property
     * <b>to_SuplrEvalRspIntroduction</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspIntroduction</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalRspIntroduction</b> entities.
     */
    public void setSuplrEvalRspIntroduction( @Nonnull final List<SuplrEvalRspIntroduction> value )
    {
        if( toSuplrEvalRspIntroduction == null ) {
            toSuplrEvalRspIntroduction = Lists.newArrayList();
        }
        toSuplrEvalRspIntroduction.clear();
        toSuplrEvalRspIntroduction.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalRspIntroduction</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspIntroduction</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspIntroduction</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalRspIntroduction</b> entities.
     */
    public void addSuplrEvalRspIntroduction( SuplrEvalRspIntroduction... entity )
    {
        if( toSuplrEvalRspIntroduction == null ) {
            toSuplrEvalRspIntroduction = Lists.newArrayList();
        }
        toSuplrEvalRspIntroduction.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrEvalRspLanguage</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrEvalRspLanguage</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalRspLanguage</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspLanguage> fetchSuplrEvalRspLanguage()
    {
        return fetchFieldAsList("to_SuplrEvalRspLanguage", SuplrEvalRspLanguage.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspLanguage</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspLanguage</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspLanguage</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspLanguage</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalRspLanguage> getSuplrEvalRspLanguageOrFetch()
    {
        if( toSuplrEvalRspLanguage == null ) {
            toSuplrEvalRspLanguage = fetchSuplrEvalRspLanguage();
        }
        return toSuplrEvalRspLanguage;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspLanguage</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspLanguage</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierEvaluationResponse</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspLanguage</b> is already loaded, the result
     *         will contain the <b>SuplrEvalRspLanguage</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalRspLanguage>> getSuplrEvalRspLanguageIfPresent()
    {
        return Option.of(toSuplrEvalRspLanguage);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalRspLanguage</b> entities for the loaded navigation property
     * <b>to_SuplrEvalRspLanguage</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspLanguage</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalRspLanguage</b> entities.
     */
    public void setSuplrEvalRspLanguage( @Nonnull final List<SuplrEvalRspLanguage> value )
    {
        if( toSuplrEvalRspLanguage == null ) {
            toSuplrEvalRspLanguage = Lists.newArrayList();
        }
        toSuplrEvalRspLanguage.clear();
        toSuplrEvalRspLanguage.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalRspLanguage</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspLanguage</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspLanguage</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalRspLanguage</b> entities.
     */
    public void addSuplrEvalRspLanguage( SuplrEvalRspLanguage... entity )
    {
        if( toSuplrEvalRspLanguage == null ) {
            toSuplrEvalRspLanguage = Lists.newArrayList();
        }
        toSuplrEvalRspLanguage.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrEvalRspPurchaserResp</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrEvalRspPurchaserResp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrEvalRspPurchaserResp</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalRspPurchaserResp fetchSuplrEvalRspPurchaserResp()
    {
        return fetchFieldAsSingle("to_SuplrEvalRspPurchaserResp", SuplrEvalRspPurchaserResp.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspPurchaserResp</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspPurchaserResp</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspPurchaserResp</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspPurchaserResp</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalRspPurchaserResp getSuplrEvalRspPurchaserRespOrFetch()
    {
        if( toSuplrEvalRspPurchaserResp == null ) {
            toSuplrEvalRspPurchaserResp = fetchSuplrEvalRspPurchaserResp();
        }
        return toSuplrEvalRspPurchaserResp;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspPurchaserResp</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspPurchaserResp</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierEvaluationResponse</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspPurchaserResp</b> is already loaded, the
     *         result will contain the <b>SuplrEvalRspPurchaserResp</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrEvalRspPurchaserResp> getSuplrEvalRspPurchaserRespIfPresent()
    {
        return Option.of(toSuplrEvalRspPurchaserResp);
    }

    /**
     * Overwrites the associated <b>SuplrEvalRspPurchaserResp</b> entity for the loaded navigation property
     * <b>to_SuplrEvalRspPurchaserResp</b>.
     *
     * @param value
     *            New <b>SuplrEvalRspPurchaserResp</b> entity.
     */
    public void setSuplrEvalRspPurchaserResp( final SuplrEvalRspPurchaserResp value )
    {
        toSuplrEvalRspPurchaserResp = value;
    }

    /**
     * Fetches the <b>SuplrEvalRspRootQnaire</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrEvalRspRootQnaire</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrEvalRspRootQnaire</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalRspRootQnaire fetchSuplrEvalRspRootQnaire()
    {
        return fetchFieldAsSingle("to_SuplrEvalRspRootQnaire", SuplrEvalRspRootQnaire.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspRootQnaire</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspRootQnaire</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspRootQnaire</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspRootQnaire</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalRspRootQnaire getSuplrEvalRspRootQnaireOrFetch()
    {
        if( toSuplrEvalRspRootQnaire == null ) {
            toSuplrEvalRspRootQnaire = fetchSuplrEvalRspRootQnaire();
        }
        return toSuplrEvalRspRootQnaire;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspRootQnaire</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalRspRootQnaire</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierEvaluationResponse</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspRootQnaire</b> is already loaded, the result
     *         will contain the <b>SuplrEvalRspRootQnaire</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrEvalRspRootQnaire> getSuplrEvalRspRootQnaireIfPresent()
    {
        return Option.of(toSuplrEvalRspRootQnaire);
    }

    /**
     * Overwrites the associated <b>SuplrEvalRspRootQnaire</b> entity for the loaded navigation property
     * <b>to_SuplrEvalRspRootQnaire</b>.
     *
     * @param value
     *            New <b>SuplrEvalRspRootQnaire</b> entity.
     */
    public void setSuplrEvalRspRootQnaire( final SuplrEvalRspRootQnaire value )
    {
        toSuplrEvalRspRootQnaire = value;
    }

    /**
     * Fetches the <b>SuplrEvalRspSupplier</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SuplrEvalRspSupplier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrEvalRspSupplier</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalRspSupplier fetchSuplrEvalRspSupplier()
    {
        return fetchFieldAsSingle("to_SuplrEvalRspSupplier", SuplrEvalRspSupplier.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspSupplier</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SuplrEvalRspSupplier</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalRspSupplier</b> of a queried <b>SupplierEvaluationResponse</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalRspSupplier</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalRspSupplier getSuplrEvalRspSupplierOrFetch()
    {
        if( toSuplrEvalRspSupplier == null ) {
            toSuplrEvalRspSupplier = fetchSuplrEvalRspSupplier();
        }
        return toSuplrEvalRspSupplier;
    }

    /**
     * Retrieval of associated <b>SuplrEvalRspSupplier</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SuplrEvalRspSupplier</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierEvaluationResponse</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalRspSupplier</b> is already loaded, the result
     *         will contain the <b>SuplrEvalRspSupplier</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrEvalRspSupplier> getSuplrEvalRspSupplierIfPresent()
    {
        return Option.of(toSuplrEvalRspSupplier);
    }

    /**
     * Overwrites the associated <b>SuplrEvalRspSupplier</b> entity for the loaded navigation property
     * <b>to_SuplrEvalRspSupplier</b>.
     *
     * @param value
     *            New <b>SuplrEvalRspSupplier</b> entity.
     */
    public void setSuplrEvalRspSupplier( final SuplrEvalRspSupplier value )
    {
        toSuplrEvalRspSupplier = value;
    }

    /**
     * Helper class to allow for fluent creation of SupplierEvaluationResponse instances.
     *
     */
    public final static class SupplierEvaluationResponseBuilder
    {

        private SuplrEvalRspAppraiser toSuplrEvalRspAppraiser;
        private List<SuplrEvalRspExternalName> toSuplrEvalRspExternalName = Lists.newArrayList();
        private List<SuplrEvalRspIntroduction> toSuplrEvalRspIntroduction = Lists.newArrayList();
        private List<SuplrEvalRspLanguage> toSuplrEvalRspLanguage = Lists.newArrayList();
        private SuplrEvalRspPurchaserResp toSuplrEvalRspPurchaserResp;
        private SuplrEvalRspRootQnaire toSuplrEvalRspRootQnaire;
        private SuplrEvalRspSupplier toSuplrEvalRspSupplier;

        private SupplierEvaluationResponse.SupplierEvaluationResponseBuilder toSuplrEvalRspAppraiser(
            final SuplrEvalRspAppraiser value )
        {
            toSuplrEvalRspAppraiser = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspAppraiser</b> for <b>SupplierEvaluationResponse</b> to single
         * <b>SuplrEvalRspAppraiser</b>.
         *
         * @param value
         *            The SuplrEvalRspAppraiser to build this SupplierEvaluationResponse with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierEvaluationResponse.SupplierEvaluationResponseBuilder suplrEvalRspAppraiser(
            final SuplrEvalRspAppraiser value )
        {
            return toSuplrEvalRspAppraiser(value);
        }

        private SupplierEvaluationResponse.SupplierEvaluationResponseBuilder toSuplrEvalRspExternalName(
            final List<SuplrEvalRspExternalName> value )
        {
            toSuplrEvalRspExternalName.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspExternalName</b> for <b>SupplierEvaluationResponse</b> to multiple
         * <b>SuplrEvalRspExternalName</b>.
         *
         * @param value
         *            The SuplrEvalRspExternalNames to build this SupplierEvaluationResponse with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierEvaluationResponse.SupplierEvaluationResponseBuilder suplrEvalRspExternalName(
            SuplrEvalRspExternalName... value )
        {
            return toSuplrEvalRspExternalName(Lists.newArrayList(value));
        }

        private SupplierEvaluationResponse.SupplierEvaluationResponseBuilder toSuplrEvalRspIntroduction(
            final List<SuplrEvalRspIntroduction> value )
        {
            toSuplrEvalRspIntroduction.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspIntroduction</b> for <b>SupplierEvaluationResponse</b> to multiple
         * <b>SuplrEvalRspIntroduction</b>.
         *
         * @param value
         *            The SuplrEvalRspIntroductions to build this SupplierEvaluationResponse with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierEvaluationResponse.SupplierEvaluationResponseBuilder suplrEvalRspIntroduction(
            SuplrEvalRspIntroduction... value )
        {
            return toSuplrEvalRspIntroduction(Lists.newArrayList(value));
        }

        private SupplierEvaluationResponse.SupplierEvaluationResponseBuilder toSuplrEvalRspLanguage(
            final List<SuplrEvalRspLanguage> value )
        {
            toSuplrEvalRspLanguage.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspLanguage</b> for <b>SupplierEvaluationResponse</b> to multiple
         * <b>SuplrEvalRspLanguage</b>.
         *
         * @param value
         *            The SuplrEvalRspLanguages to build this SupplierEvaluationResponse with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierEvaluationResponse.SupplierEvaluationResponseBuilder suplrEvalRspLanguage(
            SuplrEvalRspLanguage... value )
        {
            return toSuplrEvalRspLanguage(Lists.newArrayList(value));
        }

        private SupplierEvaluationResponse.SupplierEvaluationResponseBuilder toSuplrEvalRspPurchaserResp(
            final SuplrEvalRspPurchaserResp value )
        {
            toSuplrEvalRspPurchaserResp = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspPurchaserResp</b> for <b>SupplierEvaluationResponse</b> to single
         * <b>SuplrEvalRspPurchaserResp</b>.
         *
         * @param value
         *            The SuplrEvalRspPurchaserResp to build this SupplierEvaluationResponse with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierEvaluationResponse.SupplierEvaluationResponseBuilder suplrEvalRspPurchaserResp(
            final SuplrEvalRspPurchaserResp value )
        {
            return toSuplrEvalRspPurchaserResp(value);
        }

        private SupplierEvaluationResponse.SupplierEvaluationResponseBuilder toSuplrEvalRspRootQnaire(
            final SuplrEvalRspRootQnaire value )
        {
            toSuplrEvalRspRootQnaire = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspRootQnaire</b> for <b>SupplierEvaluationResponse</b> to single
         * <b>SuplrEvalRspRootQnaire</b>.
         *
         * @param value
         *            The SuplrEvalRspRootQnaire to build this SupplierEvaluationResponse with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierEvaluationResponse.SupplierEvaluationResponseBuilder suplrEvalRspRootQnaire(
            final SuplrEvalRspRootQnaire value )
        {
            return toSuplrEvalRspRootQnaire(value);
        }

        private SupplierEvaluationResponse.SupplierEvaluationResponseBuilder toSuplrEvalRspSupplier(
            final SuplrEvalRspSupplier value )
        {
            toSuplrEvalRspSupplier = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalRspSupplier</b> for <b>SupplierEvaluationResponse</b> to single
         * <b>SuplrEvalRspSupplier</b>.
         *
         * @param value
         *            The SuplrEvalRspSupplier to build this SupplierEvaluationResponse with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierEvaluationResponse.SupplierEvaluationResponseBuilder suplrEvalRspSupplier(
            final SuplrEvalRspSupplier value )
        {
            return toSuplrEvalRspSupplier(value);
        }

    }

}
