/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable.SupplierEvaluationResponseSelectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse
 * SupplierEvaluationResponse} entities. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class SupplierEvaluationResponseFluentHelper
    extends
    FluentHelperRead<SupplierEvaluationResponseFluentHelper, SupplierEvaluationResponse, SupplierEvaluationResponseSelectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public SupplierEvaluationResponseFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<SupplierEvaluationResponse> getEntityClass()
    {
        return SupplierEvaluationResponse.class;
    }

}
