/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SupplierEvaluationResponseServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService
 * SupplierEvaluationResponseService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSupplierEvaluationResponseServiceBatch
    extends
    BatchFluentHelperBasic<SupplierEvaluationResponseServiceBatch, SupplierEvaluationResponseServiceBatchChangeSet>
    implements
    SupplierEvaluationResponseServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSupplierEvaluationResponseServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierEvaluationResponseServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSupplierEvaluationResponseServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierEvaluationResponseServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSupplierEvaluationResponseServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SupplierEvaluationResponseServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSupplierEvaluationResponseServiceBatchChangeSet(this, service);
    }

}
