/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link SupplierEvaluationResponseServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService
 * SupplierEvaluationResponseService}.
 *
 */
public class DefaultSupplierEvaluationResponseServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SupplierEvaluationResponseServiceBatch, SupplierEvaluationResponseServiceBatchChangeSet>
    implements
    SupplierEvaluationResponseServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService service;

    @SuppressWarnings( "deprecation" )
    DefaultSupplierEvaluationResponseServiceBatchChangeSet(
        @Nonnull final DefaultSupplierEvaluationResponseServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationResponseService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSupplierEvaluationResponseServiceBatchChangeSet getThis()
    {
        return this;
    }

}
