/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiser;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiser
 * SuplrEvalRspAppraiser}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspAppraiserField
 * SuplrEvalRspAppraiserField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SuplrEvalRspAppraiserLink
 * SuplrEvalRspAppraiserLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiser#SUPLR_EVAL_RSP_PARTY_UUID
 * SUPLR_EVAL_RSP_PARTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiser#SUPLR_EVAL_RSP_UUID
 * SUPLR_EVAL_RSP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiser#USER_ID
 * USER_ID}</li>
 * </ul>
 *
 */
public interface SuplrEvalRspAppraiserSelectable extends EntitySelectable<SuplrEvalRspAppraiser>
{

}
