/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserResp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserResp
 * SuplrEvalRspPurchaserResp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspPurchaserRespField
 * SuplrEvalRspPurchaserRespField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SuplrEvalRspPurchaserRespLink
 * SuplrEvalRspPurchaserRespLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserResp#SUPLR_EVAL_RSP_PARTY_UUID
 * SUPLR_EVAL_RSP_PARTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserResp#SUPLR_EVAL_RSP_UUID
 * SUPLR_EVAL_RSP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserResp#USER_ID
 * USER_ID}</li>
 * </ul>
 *
 */
public interface SuplrEvalRspPurchaserRespSelectable extends EntitySelectable<SuplrEvalRspPurchaserResp>
{

}
