/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion
 * SuplrEvalRspQuestion}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspQuestionField
 * SuplrEvalRspQuestionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SuplrEvalRspQuestionLink
 * SuplrEvalRspQuestionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPLR_EVAL_RSP_QUESTION_UUID
 * SUPLR_EVAL_RSP_QUESTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPLR_EVAL_RSP_UUID
 * SUPLR_EVAL_RSP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPLR_EVAL_RSP_BRNCHG_QUESTION_UUID
 * SUPLR_EVAL_RSP_BRNCHG_QUESTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPLR_EVAL_RSP_SECTION_UUID
 * SUPLR_EVAL_RSP_SECTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPLR_EVAL_RSP_BRNCHG_QSTN_VALN_UUID
 * SUPLR_EVAL_RSP_BRNCHG_QSTN_VALN_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPLR_EVAL_REQ_QUESTION_UUID
 * SUPLR_EVAL_REQ_QUESTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPPLIER_EVAL_QUESTION
 * SUPPLIER_EVAL_QUESTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPPLIER_EVAL_REQUEST_QUESTION
 * SUPPLIER_EVAL_REQUEST_QUESTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#QUESTION_NAME
 * QUESTION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#IS_DISQUALIFYING_QUESTION
 * IS_DISQUALIFYING_QUESTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#IS_MANDATORY_QUESTION
 * IS_MANDATORY_QUESTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#IS_QUESTION_COMMENT_ENABLED
 * IS_QUESTION_COMMENT_ENABLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#NUMBER_OF_RESPONSES
 * NUMBER_OF_RESPONSES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SLC_PREFERRED_ANSWER
 * SLC_PREFERRED_ANSWER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SLC_QUESTION_ATTACHMENT_OPTION
 * SLC_QUESTION_ATTACHMENT_OPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPLR_EVAL_ORDINAL_NUMBER
 * SUPLR_EVAL_ORDINAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPLR_EVAL_RSP_BRNCHG_QUESTION
 * SUPLR_EVAL_RSP_BRNCHG_QUESTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SUPLR_EVAL_RSP_BRNCHG_QUESTION_VALN
 * SUPLR_EVAL_RSP_BRNCHG_QUESTION_VALN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#SLC_QUESTION_TYPE
 * SLC_QUESTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#WEIGHTING_FACTOR
 * WEIGHTING_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#MINIMAL_SCORE
 * MINIMAL_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#TARGET_SCORE
 * TARGET_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#TO_SUPLR_EVAL_RSP_EXPL_TEXT
 * TO_SUPLR_EVAL_RSP_EXPL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion#TO_SUPLR_EVAL_RSP_QUESTION_TEXT
 * TO_SUPLR_EVAL_RSP_QUESTION_TEXT}</li>
 * </ul>
 *
 */
public interface SuplrEvalRspQuestionSelectable extends EntitySelectable<SuplrEvalRspQuestion>
{

}
