/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire
 * SuplrEvalRspRootQnaire}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspRootQnaireField
 * SuplrEvalRspRootQnaireField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SuplrEvalRspRootQnaireLink
 * SuplrEvalRspRootQnaireLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire#SUPLR_EVAL_RSP_QUESTIONNAIRE_UUID
 * SUPLR_EVAL_RSP_QUESTIONNAIRE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire#SUPLR_EVAL_RSP_UUID
 * SUPLR_EVAL_RSP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire#CALCULATED_SCORE
 * CALCULATED_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire#IS_SCORING_RELEVANT
 * IS_SCORING_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire#MINIMAL_SCORE
 * MINIMAL_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire#NUMBER_OF_RESPONSES
 * NUMBER_OF_RESPONSES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire#SUPLR_EVAL_ORDINAL_NUMBER
 * SUPLR_EVAL_ORDINAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire#TARGET_SCORE
 * TARGET_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire#WEIGHTING_FACTOR
 * WEIGHTING_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire#TO_SUPLR_EVAL_RSP_STRUC_QNAIRE
 * TO_SUPLR_EVAL_RSP_STRUC_QNAIRE}</li>
 * </ul>
 *
 */
public interface SuplrEvalRspRootQnaireSelectable extends EntitySelectable<SuplrEvalRspRootQnaire>
{

}
