/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection
 * SuplrEvalRspSection}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SuplrEvalRspSectionField
 * SuplrEvalRspSectionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SuplrEvalRspSectionLink
 * SuplrEvalRspSectionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#SUPLR_EVAL_RSP_SECTION_UUID
 * SUPLR_EVAL_RSP_SECTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#SUPLR_EVAL_RSP_UUID
 * SUPLR_EVAL_RSP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#SUPLR_EVAL_RSP_QUESTIONNAIRE_UUID
 * SUPLR_EVAL_RSP_QUESTIONNAIRE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#SUPLR_EVAL_REQ_SECTION_UUID
 * SUPLR_EVAL_REQ_SECTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#SUPPLIER_EVAL_RESPONSE_SECTION
 * SUPPLIER_EVAL_RESPONSE_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#SUPPLIER_EVAL_RESPONSE_SCTN_ALTV
 * SUPPLIER_EVAL_RESPONSE_SCTN_ALTV}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#QUESTIONNAIRE_SECTION_NAME
 * QUESTIONNAIRE_SECTION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#WEIGHTING_FACTOR
 * WEIGHTING_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#MINIMAL_SCORE
 * MINIMAL_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#TARGET_SCORE
 * TARGET_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#CALCULATED_SCORE
 * CALCULATED_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#NUMBER_OF_RESPONSES
 * NUMBER_OF_RESPONSES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#TO_SUPLR_EVAL_RSP_QUESTION
 * TO_SUPLR_EVAL_RSP_QUESTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection#TO_SUPLR_EVAL_RSP_SECTION_TEXT
 * TO_SUPLR_EVAL_RSP_SECTION_TEXT}</li>
 * </ul>
 *
 */
public interface SuplrEvalRspSectionSelectable extends EntitySelectable<SuplrEvalRspSection>
{

}
