/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse
 * SupplierEvaluationResponse}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.field.SupplierEvaluationResponseField
 * SupplierEvaluationResponseField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.link.SupplierEvaluationResponseLink
 * SupplierEvaluationResponseLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#SUPLR_EVAL_RSP_UUID
 * SUPLR_EVAL_RSP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#SUPLR_EVAL_REQ_UUID
 * SUPLR_EVAL_REQ_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#PURG_CAT_UUID
 * PURG_CAT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#SUPPLIER_EVAL_RESPONSE
 * SUPPLIER_EVAL_RESPONSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#SUPLR_EVAL_RSP_NAME
 * SUPLR_EVAL_RSP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#SUPLR_EVAL_START_DATE
 * SUPLR_EVAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#SUPLR_EVAL_END_DATE
 * SUPLR_EVAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#SUPLR_EVAL_DEADLINE_DATE
 * SUPLR_EVAL_DEADLINE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#SUPLR_EVAL_SUBMISSION_DATE_TIME
 * SUPLR_EVAL_SUBMISSION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#SUPLR_EVAL_RSP_LIFECYCLE_STATUS
 * SUPLR_EVAL_RSP_LIFECYCLE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#TO_SUPLR_EVAL_RSP_APPRAISER
 * TO_SUPLR_EVAL_RSP_APPRAISER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#TO_SUPLR_EVAL_RSP_EXTERNAL_NAME
 * TO_SUPLR_EVAL_RSP_EXTERNAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#TO_SUPLR_EVAL_RSP_INTRODUCTION
 * TO_SUPLR_EVAL_RSP_INTRODUCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#TO_SUPLR_EVAL_RSP_LANGUAGE
 * TO_SUPLR_EVAL_RSP_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#TO_SUPLR_EVAL_RSP_PURCHASER_RESP
 * TO_SUPLR_EVAL_RSP_PURCHASER_RESP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#TO_SUPLR_EVAL_RSP_ROOT_QNAIRE
 * TO_SUPLR_EVAL_RSP_ROOT_QNAIRE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse#TO_SUPLR_EVAL_RSP_SUPPLIER
 * TO_SUPLR_EVAL_RSP_SUPPLIER}</li>
 * </ul>
 *
 */
public interface SupplierEvaluationResponseSelectable extends EntitySelectable<SupplierEvaluationResponse>
{

}
