/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.field.SAP__FormatField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable.SAP__FormatSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SAP__Format</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SAP__Format extends VdmEntity<SAP__Format>
{

    /**
     * Selector for all available fields of SAP__Format.
     *
     */
    public final static SAP__FormatSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>FitToPage</b>
     * </p>
     *
     * @return The fitToPage contained in this entity.
     */
    @SerializedName( "FitToPage" )
    @JsonProperty( "FitToPage" )
    @Nullable
    @ODataField( odataName = "FitToPage" )
    private SAP__FitToPage fitToPage;
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @return UUID
     */
    @Key
    @SerializedName( "Id" )
    @JsonProperty( "Id" )
    @Nullable
    @ODataField( odataName = "Id" )
    private UUID id;
    /**
     * Use with available fluent helpers to apply the <b>Id</b> field to query operations.
     *
     */
    public final static SAP__FormatField<UUID> ID = new SAP__FormatField<UUID>("Id");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>FontSize</b>
     * </p>
     *
     * @return The fontSize contained in this entity.
     */
    @SerializedName( "FontSize" )
    @JsonProperty( "FontSize" )
    @Nullable
    @ODataField( odataName = "FontSize" )
    private Integer fontSize;
    /**
     * Use with available fluent helpers to apply the <b>FontSize</b> field to query operations.
     *
     */
    public final static SAP__FormatField<Integer> FONT_SIZE = new SAP__FormatField<Integer>("FontSize");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Orientation</b>
     * </p>
     *
     * @return The orientation contained in this entity.
     */
    @SerializedName( "Orientation" )
    @JsonProperty( "Orientation" )
    @Nullable
    @ODataField( odataName = "Orientation" )
    private String orientation;
    /**
     * Use with available fluent helpers to apply the <b>Orientation</b> field to query operations.
     *
     */
    public final static SAP__FormatField<String> ORIENTATION = new SAP__FormatField<String>("Orientation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaperSize</b>
     * </p>
     *
     * @return The paperSize contained in this entity.
     */
    @SerializedName( "PaperSize" )
    @JsonProperty( "PaperSize" )
    @Nullable
    @ODataField( odataName = "PaperSize" )
    private String paperSize;
    /**
     * Use with available fluent helpers to apply the <b>PaperSize</b> field to query operations.
     *
     */
    public final static SAP__FormatField<String> PAPER_SIZE = new SAP__FormatField<String>("PaperSize");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BorderSize</b>
     * </p>
     *
     * @return The borderSize contained in this entity.
     */
    @SerializedName( "BorderSize" )
    @JsonProperty( "BorderSize" )
    @Nullable
    @ODataField( odataName = "BorderSize" )
    private Integer borderSize;
    /**
     * Use with available fluent helpers to apply the <b>BorderSize</b> field to query operations.
     *
     */
    public final static SAP__FormatField<Integer> BORDER_SIZE = new SAP__FormatField<Integer>("BorderSize");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MarginSize</b>
     * </p>
     *
     * @return The marginSize contained in this entity.
     */
    @SerializedName( "MarginSize" )
    @JsonProperty( "MarginSize" )
    @Nullable
    @ODataField( odataName = "MarginSize" )
    private Integer marginSize;
    /**
     * Use with available fluent helpers to apply the <b>MarginSize</b> field to query operations.
     *
     */
    public final static SAP__FormatField<Integer> MARGIN_SIZE = new SAP__FormatField<Integer>("MarginSize");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>FontName</b>
     * </p>
     *
     * @return Font Name
     */
    @SerializedName( "FontName" )
    @JsonProperty( "FontName" )
    @Nullable
    @ODataField( odataName = "FontName" )
    private String fontName;
    /**
     * Use with available fluent helpers to apply the <b>FontName</b> field to query operations.
     *
     */
    public final static SAP__FormatField<String> FONT_NAME = new SAP__FormatField<String>("FontName");

    @Nonnull
    @Override
    public Class<SAP__Format> getType()
    {
        return SAP__Format.class;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>FitToPage</b>
     * </p>
     *
     * @param fitToPage
     *            The fitToPage to set.
     */
    public void setFitToPage( @Nullable final SAP__FitToPage fitToPage )
    {
        rememberChangedField("FitToPage", this.fitToPage);
        this.fitToPage = fitToPage;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @param id
     *            UUID
     */
    public void setId( @Nullable final UUID id )
    {
        rememberChangedField("Id", this.id);
        this.id = id;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>FontSize</b>
     * </p>
     *
     * @param fontSize
     *            The fontSize to set.
     */
    public void setFontSize( @Nullable final Integer fontSize )
    {
        rememberChangedField("FontSize", this.fontSize);
        this.fontSize = fontSize;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Orientation</b>
     * </p>
     *
     * @param orientation
     *            The orientation to set.
     */
    public void setOrientation( @Nullable final String orientation )
    {
        rememberChangedField("Orientation", this.orientation);
        this.orientation = orientation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaperSize</b>
     * </p>
     *
     * @param paperSize
     *            The paperSize to set.
     */
    public void setPaperSize( @Nullable final String paperSize )
    {
        rememberChangedField("PaperSize", this.paperSize);
        this.paperSize = paperSize;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BorderSize</b>
     * </p>
     *
     * @param borderSize
     *            The borderSize to set.
     */
    public void setBorderSize( @Nullable final Integer borderSize )
    {
        rememberChangedField("BorderSize", this.borderSize);
        this.borderSize = borderSize;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MarginSize</b>
     * </p>
     *
     * @param marginSize
     *            The marginSize to set.
     */
    public void setMarginSize( @Nullable final Integer marginSize )
    {
        rememberChangedField("MarginSize", this.marginSize);
        this.marginSize = marginSize;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>FontName</b>
     * </p>
     *
     * @param fontName
     *            Font Name
     */
    public void setFontName( @Nullable final String fontName )
    {
        rememberChangedField("FontName", this.fontName);
        this.fontName = fontName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SAP__FormatSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Id", getId());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FitToPage", getFitToPage());
        values.put("Id", getId());
        values.put("FontSize", getFontSize());
        values.put("Orientation", getOrientation());
        values.put("PaperSize", getPaperSize());
        values.put("BorderSize", getBorderSize());
        values.put("MarginSize", getMarginSize());
        values.put("FontName", getFontName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Id") ) {
                final Object value = values.remove("Id");
                if( (value == null) || (!value.equals(getId())) ) {
                    setId(((UUID) value));
                }
            }
            if( values.containsKey("FontSize") ) {
                final Object value = values.remove("FontSize");
                if( (value == null) || (!value.equals(getFontSize())) ) {
                    setFontSize(((Integer) value));
                }
            }
            if( values.containsKey("Orientation") ) {
                final Object value = values.remove("Orientation");
                if( (value == null) || (!value.equals(getOrientation())) ) {
                    setOrientation(((String) value));
                }
            }
            if( values.containsKey("PaperSize") ) {
                final Object value = values.remove("PaperSize");
                if( (value == null) || (!value.equals(getPaperSize())) ) {
                    setPaperSize(((String) value));
                }
            }
            if( values.containsKey("BorderSize") ) {
                final Object value = values.remove("BorderSize");
                if( (value == null) || (!value.equals(getBorderSize())) ) {
                    setBorderSize(((Integer) value));
                }
            }
            if( values.containsKey("MarginSize") ) {
                final Object value = values.remove("MarginSize");
                if( (value == null) || (!value.equals(getMarginSize())) ) {
                    setMarginSize(((Integer) value));
                }
            }
            if( values.containsKey("FontName") ) {
                final Object value = values.remove("FontName");
                if( (value == null) || (!value.equals(getFontName())) ) {
                    setFontName(((String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("FitToPage") ) {
                final Object value = values.remove("FitToPage");
                if( value instanceof Map ) {
                    if( getFitToPage() == null ) {
                        setFitToPage(new SAP__FitToPage());
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    getFitToPage().fromMap(inputMap);
                }
                if( (value == null) && (getFitToPage() != null) ) {
                    setFitToPage(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SAP__FormatField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SAP__FormatField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SAP__FormatField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SAP__FormatField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService.DEFAULT_SERVICE_PATH);
    }

}
