/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.field.SAP__PDFStandardField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable.SAP__PDFStandardSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SAP__PDFStandard</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SAP__PDFStandard extends VdmEntity<SAP__PDFStandard>
{

    /**
     * Selector for all available fields of SAP__PDFStandard.
     *
     */
    public final static SAP__PDFStandardSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @return UUID
     */
    @Key
    @SerializedName( "Id" )
    @JsonProperty( "Id" )
    @Nullable
    @ODataField( odataName = "Id" )
    private UUID id;
    /**
     * Use with available fluent helpers to apply the <b>Id</b> field to query operations.
     *
     */
    public final static SAP__PDFStandardField<UUID> ID = new SAP__PDFStandardField<UUID>("Id");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>UsePDFAConformance</b>
     * </p>
     *
     * @return The usePDFAConformance contained in this entity.
     */
    @SerializedName( "UsePDFAConformance" )
    @JsonProperty( "UsePDFAConformance" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UsePDFAConformance" )
    private Boolean usePDFAConformance;
    /**
     * Use with available fluent helpers to apply the <b>UsePDFAConformance</b> field to query operations.
     *
     */
    public final static SAP__PDFStandardField<Boolean> USE_PDFA_CONFORMANCE =
        new SAP__PDFStandardField<Boolean>("UsePDFAConformance");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DoEnableAccessibility</b>
     * </p>
     *
     * @return Indicator
     */
    @SerializedName( "DoEnableAccessibility" )
    @JsonProperty( "DoEnableAccessibility" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DoEnableAccessibility" )
    private Boolean doEnableAccessibility;
    /**
     * Use with available fluent helpers to apply the <b>DoEnableAccessibility</b> field to query operations.
     *
     */
    public final static SAP__PDFStandardField<Boolean> DO_ENABLE_ACCESSIBILITY =
        new SAP__PDFStandardField<Boolean>("DoEnableAccessibility");

    @Nonnull
    @Override
    public Class<SAP__PDFStandard> getType()
    {
        return SAP__PDFStandard.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @param id
     *            UUID
     */
    public void setId( @Nullable final UUID id )
    {
        rememberChangedField("Id", this.id);
        this.id = id;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>UsePDFAConformance</b>
     * </p>
     *
     * @param usePDFAConformance
     *            The usePDFAConformance to set.
     */
    public void setUsePDFAConformance( @Nullable final Boolean usePDFAConformance )
    {
        rememberChangedField("UsePDFAConformance", this.usePDFAConformance);
        this.usePDFAConformance = usePDFAConformance;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DoEnableAccessibility</b>
     * </p>
     *
     * @param doEnableAccessibility
     *            Indicator
     */
    public void setDoEnableAccessibility( @Nullable final Boolean doEnableAccessibility )
    {
        rememberChangedField("DoEnableAccessibility", this.doEnableAccessibility);
        this.doEnableAccessibility = doEnableAccessibility;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SAP__PDFStandardSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Id", getId());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Id", getId());
        values.put("UsePDFAConformance", getUsePDFAConformance());
        values.put("DoEnableAccessibility", getDoEnableAccessibility());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Id") ) {
                final Object value = values.remove("Id");
                if( (value == null) || (!value.equals(getId())) ) {
                    setId(((UUID) value));
                }
            }
            if( values.containsKey("UsePDFAConformance") ) {
                final Object value = values.remove("UsePDFAConformance");
                if( (value == null) || (!value.equals(getUsePDFAConformance())) ) {
                    setUsePDFAConformance(((Boolean) value));
                }
            }
            if( values.containsKey("DoEnableAccessibility") ) {
                final Object value = values.remove("DoEnableAccessibility");
                if( (value == null) || (!value.equals(getDoEnableAccessibility())) ) {
                    setDoEnableAccessibility(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SAP__PDFStandardField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SAP__PDFStandardField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SAP__PDFStandardField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SAP__PDFStandardField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService.DEFAULT_SERVICE_PATH);
    }

}
