/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.field.SAP__UnitOfMeasureField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable.SAP__UnitOfMeasureSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SAP__UnitOfMeasure</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SAP__UnitOfMeasure extends VdmEntity<SAP__UnitOfMeasure>
{

    /**
     * Selector for all available fields of SAP__UnitOfMeasure.
     *
     */
    public final static SAP__UnitOfMeasureSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitCode</b>
     * </p>
     *
     * @return Internal UoM
     */
    @Key
    @SerializedName( "UnitCode" )
    @JsonProperty( "UnitCode" )
    @Nullable
    @ODataField( odataName = "UnitCode" )
    private String unitCode;
    /**
     * Use with available fluent helpers to apply the <b>UnitCode</b> field to query operations.
     *
     */
    public final static SAP__UnitOfMeasureField<String> UNIT_CODE = new SAP__UnitOfMeasureField<String>("UnitCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ISOCode</b>
     * </p>
     *
     * @return ISO Code
     */
    @SerializedName( "ISOCode" )
    @JsonProperty( "ISOCode" )
    @Nullable
    @ODataField( odataName = "ISOCode" )
    private String iSOCode;
    /**
     * Use with available fluent helpers to apply the <b>ISOCode</b> field to query operations.
     *
     */
    public final static SAP__UnitOfMeasureField<String> ISO_CODE = new SAP__UnitOfMeasureField<String>("ISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExternalCode</b>
     * </p>
     *
     * @return Commercial
     */
    @SerializedName( "ExternalCode" )
    @JsonProperty( "ExternalCode" )
    @Nullable
    @ODataField( odataName = "ExternalCode" )
    private String externalCode;
    /**
     * Use with available fluent helpers to apply the <b>ExternalCode</b> field to query operations.
     *
     */
    public final static SAP__UnitOfMeasureField<String> EXTERNAL_CODE =
        new SAP__UnitOfMeasureField<String>("ExternalCode");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Text</b>
     * </p>
     *
     * @return Meas. Unit Text
     */
    @SerializedName( "Text" )
    @JsonProperty( "Text" )
    @Nullable
    @ODataField( odataName = "Text" )
    private String text;
    /**
     * Use with available fluent helpers to apply the <b>Text</b> field to query operations.
     *
     */
    public final static SAP__UnitOfMeasureField<String> TEXT = new SAP__UnitOfMeasureField<String>("Text");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DecimalPlaces</b>
     * </p>
     *
     * @return Decimal Places
     */
    @SerializedName( "DecimalPlaces" )
    @JsonProperty( "DecimalPlaces" )
    @Nullable
    @ODataField( odataName = "DecimalPlaces" )
    private Short decimalPlaces;
    /**
     * Use with available fluent helpers to apply the <b>DecimalPlaces</b> field to query operations.
     *
     */
    public final static SAP__UnitOfMeasureField<Short> DECIMAL_PLACES =
        new SAP__UnitOfMeasureField<Short>("DecimalPlaces");

    @Nonnull
    @Override
    public Class<SAP__UnitOfMeasure> getType()
    {
        return SAP__UnitOfMeasure.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitCode</b>
     * </p>
     *
     * @param unitCode
     *            Internal UoM
     */
    public void setUnitCode( @Nullable final String unitCode )
    {
        rememberChangedField("UnitCode", this.unitCode);
        this.unitCode = unitCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ISOCode</b>
     * </p>
     *
     * @param iSOCode
     *            ISO Code
     */
    public void setISOCode( @Nullable final String iSOCode )
    {
        rememberChangedField("ISOCode", this.iSOCode);
        this.iSOCode = iSOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExternalCode</b>
     * </p>
     *
     * @param externalCode
     *            Commercial
     */
    public void setExternalCode( @Nullable final String externalCode )
    {
        rememberChangedField("ExternalCode", this.externalCode);
        this.externalCode = externalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Text</b>
     * </p>
     *
     * @param text
     *            Meas. Unit Text
     */
    public void setText( @Nullable final String text )
    {
        rememberChangedField("Text", this.text);
        this.text = text;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DecimalPlaces</b>
     * </p>
     *
     * @param decimalPlaces
     *            Decimal Places
     */
    public void setDecimalPlaces( @Nullable final Short decimalPlaces )
    {
        rememberChangedField("DecimalPlaces", this.decimalPlaces);
        this.decimalPlaces = decimalPlaces;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SAP__UnitsOfMeasure";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("UnitCode", getUnitCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("UnitCode", getUnitCode());
        values.put("ISOCode", getISOCode());
        values.put("ExternalCode", getExternalCode());
        values.put("Text", getText());
        values.put("DecimalPlaces", getDecimalPlaces());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("UnitCode") ) {
                final Object value = values.remove("UnitCode");
                if( (value == null) || (!value.equals(getUnitCode())) ) {
                    setUnitCode(((String) value));
                }
            }
            if( values.containsKey("ISOCode") ) {
                final Object value = values.remove("ISOCode");
                if( (value == null) || (!value.equals(getISOCode())) ) {
                    setISOCode(((String) value));
                }
            }
            if( values.containsKey("ExternalCode") ) {
                final Object value = values.remove("ExternalCode");
                if( (value == null) || (!value.equals(getExternalCode())) ) {
                    setExternalCode(((String) value));
                }
            }
            if( values.containsKey("Text") ) {
                final Object value = values.remove("Text");
                if( (value == null) || (!value.equals(getText())) ) {
                    setText(((String) value));
                }
            }
            if( values.containsKey("DecimalPlaces") ) {
                final Object value = values.remove("DecimalPlaces");
                if( (value == null) || (!value.equals(getDecimalPlaces())) ) {
                    setDecimalPlaces(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SAP__UnitOfMeasureField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SAP__UnitOfMeasureField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SAP__UnitOfMeasureField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SAP__UnitOfMeasureField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService.DEFAULT_SERVICE_PATH);
    }

}
