/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable.SAP__ValueHelpSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp SAP__ValueHelp}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class SAP__ValueHelpByKeyFluentHelper
    extends
    FluentHelperByKey<SAP__ValueHelpByKeyFluentHelper, SAP__ValueHelp, SAP__ValueHelpSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp SAP__ValueHelp}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SAP__ValueHelp}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SAP__ValueHelp}
     * @param vALUEHELP
     *
     */
    public SAP__ValueHelpByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String vALUEHELP )
    {
        super(servicePath, entityCollection);
        this.key.put("VALUEHELP", vALUEHELP);
    }

    @Override
    @Nonnull
    protected Class<SAP__ValueHelp> getEntityClass()
    {
        return SAP__ValueHelp.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
