/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp SAP__ValueHelp}
 * entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class SAP__ValueHelpDeleteFluentHelper
    extends
    FluentHelperDelete<SAP__ValueHelpDeleteFluentHelper, SAP__ValueHelp>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp SAP__ValueHelp}
     * entity object that will be deleted in the S/4HANA system.
     *
     */
    private final SAP__ValueHelp entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp SAP__ValueHelp}
     * entity on the OData endpoint. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The SAP__ValueHelp to delete from the endpoint.
     */
    public SAP__ValueHelpDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final SAP__ValueHelp entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected SAP__ValueHelp getEntity()
    {
        return entity;
    }

}
