/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.field.SupplierOplScoresAVParametersField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.link.SupplierOplScoresAVParametersLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable.SupplierOplScoresAVParametersSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplierOplScoresAVParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplierOplScoresAVParameters extends VdmEntity<SupplierOplScoresAVParameters>
{

    /**
     * Selector for all available fields of SupplierOplScoresAVParameters.
     *
     */
    public final static SupplierOplScoresAVParametersSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Default value: EUR, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>P_DisplayCurrency</b>
     * </p>
     *
     * @return Display Currency
     */
    @Key
    @SerializedName( "P_DisplayCurrency" )
    @JsonProperty( "P_DisplayCurrency" )
    @Nullable
    @ODataField( odataName = "P_DisplayCurrency" )
    private String p_DisplayCurrency;
    /**
     * Use with available fluent helpers to apply the <b>P_DisplayCurrency</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVParametersField<String> P_DISPLAY_CURRENCY =
        new SupplierOplScoresAVParametersField<String>("P_DisplayCurrency");
    /**
     * (Key Field) Constraints: Not nullable, Default value: YEARTODATE, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>P_DateFunction</b>
     * </p>
     *
     * @return Relative Date Function
     */
    @Key
    @SerializedName( "P_DateFunction" )
    @JsonProperty( "P_DateFunction" )
    @Nullable
    @ODataField( odataName = "P_DateFunction" )
    private String p_DateFunction;
    /**
     * Use with available fluent helpers to apply the <b>P_DateFunction</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVParametersField<String> P_DATE_FUNCTION =
        new SupplierOplScoresAVParametersField<String>("P_DateFunction");
    /**
     * Navigation property <b>Results</b> for <b>SupplierOplScoresAVParameters</b> to multiple
     * <b>SupplierOplScoresAVResult</b>.
     *
     */
    @SerializedName( "Results" )
    @JsonProperty( "Results" )
    @ODataField( odataName = "Results" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SupplierOplScoresAVResult> toResults;
    /**
     * Use with available fluent helpers to apply the <b>Results</b> navigation property to query operations.
     *
     */
    public final static SupplierOplScoresAVParametersLink<SupplierOplScoresAVResult> TO_RESULTS =
        new SupplierOplScoresAVParametersLink<SupplierOplScoresAVResult>("Results");

    @Nonnull
    @Override
    public Class<SupplierOplScoresAVParameters> getType()
    {
        return SupplierOplScoresAVParameters.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Default value: EUR, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>P_DisplayCurrency</b>
     * </p>
     *
     * @param p_DisplayCurrency
     *            Display Currency
     */
    public void setP_DisplayCurrency( @Nullable final String p_DisplayCurrency )
    {
        rememberChangedField("P_DisplayCurrency", this.p_DisplayCurrency);
        this.p_DisplayCurrency = p_DisplayCurrency;
    }

    /**
     * (Key Field) Constraints: Not nullable, Default value: YEARTODATE, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>P_DateFunction</b>
     * </p>
     *
     * @param p_DateFunction
     *            Relative Date Function
     */
    public void setP_DateFunction( @Nullable final String p_DateFunction )
    {
        rememberChangedField("P_DateFunction", this.p_DateFunction);
        this.p_DateFunction = p_DateFunction;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SupplierOplScoresAV";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("P_DisplayCurrency", getP_DisplayCurrency());
        result.put("P_DateFunction", getP_DateFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("P_DisplayCurrency", getP_DisplayCurrency());
        values.put("P_DateFunction", getP_DateFunction());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("P_DisplayCurrency") ) {
                final Object value = values.remove("P_DisplayCurrency");
                if( (value == null) || (!value.equals(getP_DisplayCurrency())) ) {
                    setP_DisplayCurrency(((String) value));
                }
            }
            if( values.containsKey("P_DateFunction") ) {
                final Object value = values.remove("P_DateFunction");
                if( (value == null) || (!value.equals(getP_DateFunction())) ) {
                    setP_DateFunction(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Results") ) {
                final Object value = (values).remove("Results");
                if( value instanceof Iterable ) {
                    if( toResults == null ) {
                        toResults = Lists.newArrayList();
                    } else {
                        toResults = Lists.newArrayList(toResults);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SupplierOplScoresAVResult entity;
                        if( toResults.size() > i ) {
                            entity = toResults.get(i);
                        } else {
                            entity = new SupplierOplScoresAVResult();
                            toResults.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SupplierOplScoresAVParametersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SupplierOplScoresAVParametersField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierOplScoresAVParametersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierOplScoresAVParametersField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toResults != null ) {
            (values).put("Results", toResults);
        }
        return values;
    }

    /**
     * Fetches the <b>SupplierOplScoresAVResult</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>Results</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SupplierOplScoresAVResult</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierOplScoresAVResult> fetchResults()
    {
        return fetchFieldAsList("Results", SupplierOplScoresAVResult.class);
    }

    /**
     * Retrieval of associated <b>SupplierOplScoresAVResult</b> entities (one to many). This corresponds to the OData
     * navigation property <b>Results</b>.
     * <p>
     * If the navigation property <b>Results</b> of a queried <b>SupplierOplScoresAVParameters</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SupplierOplScoresAVResult</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierOplScoresAVResult> getResultsOrFetch()
    {
        if( toResults == null ) {
            toResults = fetchResults();
        }
        return toResults;
    }

    /**
     * Retrieval of associated <b>SupplierOplScoresAVResult</b> entities (one to many). This corresponds to the OData
     * navigation property <b>Results</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierOplScoresAVParameters</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Results</b> is already loaded, the result will contain the
     *         <b>SupplierOplScoresAVResult</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SupplierOplScoresAVResult>> getResultsIfPresent()
    {
        return Option.of(toResults);
    }

    /**
     * Overwrites the list of associated <b>SupplierOplScoresAVResult</b> entities for the loaded navigation property
     * <b>Results</b>.
     * <p>
     * If the navigation property <b>Results</b> of a queried <b>SupplierOplScoresAVParameters</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SupplierOplScoresAVResult</b> entities.
     */
    public void setResults( @Nonnull final List<SupplierOplScoresAVResult> value )
    {
        if( toResults == null ) {
            toResults = Lists.newArrayList();
        }
        toResults.clear();
        toResults.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SupplierOplScoresAVResult</b> entities. This corresponds to the OData
     * navigation property <b>Results</b>.
     * <p>
     * If the navigation property <b>Results</b> of a queried <b>SupplierOplScoresAVParameters</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SupplierOplScoresAVResult</b> entities.
     */
    public void addResults( SupplierOplScoresAVResult... entity )
    {
        if( toResults == null ) {
            toResults = Lists.newArrayList();
        }
        toResults.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SupplierOplScoresAVParameters instances.
     *
     */
    public final static class SupplierOplScoresAVParametersBuilder
    {

        private List<SupplierOplScoresAVResult> toResults = Lists.newArrayList();

        private SupplierOplScoresAVParameters.SupplierOplScoresAVParametersBuilder toResults(
            final List<SupplierOplScoresAVResult> value )
        {
            toResults.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>Results</b> for <b>SupplierOplScoresAVParameters</b> to multiple
         * <b>SupplierOplScoresAVResult</b>.
         *
         * @param value
         *            The SupplierOplScoresAVResults to build this SupplierOplScoresAVParameters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierOplScoresAVParameters.SupplierOplScoresAVParametersBuilder results(
            SupplierOplScoresAVResult... value )
        {
            return toResults(Lists.newArrayList(value));
        }

    }

}
