/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable.SupplierOplScoresAVParametersSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParameters
 * SupplierOplScoresAVParameters} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SupplierOplScoresAVParametersByKeyFluentHelper
    extends
    FluentHelperByKey<SupplierOplScoresAVParametersByKeyFluentHelper, SupplierOplScoresAVParameters, SupplierOplScoresAVParametersSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParameters
     * SupplierOplScoresAVParameters} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param p_DisplayCurrency
     *            Display Currency
     *            <p>
     *            Constraints: Not nullable, Default value: EUR, Maximum length: 5
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SupplierOplScoresAVParameters}
     * @param p_DateFunction
     *            Relative Date Function
     *            <p>
     *            Constraints: Not nullable, Default value: YEARTODATE, Maximum length: 32
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SupplierOplScoresAVParameters}
     */
    public SupplierOplScoresAVParametersByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String p_DisplayCurrency,
        final String p_DateFunction )
    {
        super(servicePath, entityCollection);
        this.key.put("P_DisplayCurrency", p_DisplayCurrency);
        this.key.put("P_DateFunction", p_DateFunction);
    }

    @Override
    @Nonnull
    protected Class<SupplierOplScoresAVParameters> getEntityClass()
    {
        return SupplierOplScoresAVParameters.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
