/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.field.SupplierOplScoresAVResultField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.link.SupplierOplScoresAVResultOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable.SupplierOplScoresAVResultSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Read Supplier Scores
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplierOplScoresAVResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplierOplScoresAVResult extends VdmEntity<SupplierOplScoresAVResult>
{

    /**
     * Selector for all available fields of SupplierOplScoresAVResult.
     *
     */
    public final static SupplierOplScoresAVResultSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ID</b>
     * </p>
     *
     * @return The iD contained in this entity.
     */
    @Key
    @SerializedName( "ID" )
    @JsonProperty( "ID" )
    @Nullable
    @ODataField( odataName = "ID" )
    private String iD;
    /**
     * Use with available fluent helpers to apply the <b>ID</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> ID = new SupplierOplScoresAVResultField<String>("ID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PURCHASING_DOCUMENT =
        new SupplierOplScoresAVResultField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Purchasing Document Item
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PURCHASING_DOCUMENT_ITEM =
        new SupplierOplScoresAVResultField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocMigrtnIsCmpltdForAnlyts</b>
     * </p>
     *
     * @return Single-Character Flag
     */
    @SerializedName( "PurgDocMigrtnIsCmpltdForAnlyts" )
    @JsonProperty( "PurgDocMigrtnIsCmpltdForAnlyts" )
    @Nullable
    @ODataField( odataName = "PurgDocMigrtnIsCmpltdForAnlyts" )
    private String purgDocMigrtnIsCmpltdForAnlyts;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocMigrtnIsCmpltdForAnlyts</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PURG_DOC_MIGRTN_IS_CMPLTD_FOR_ANLYTS =
        new SupplierOplScoresAVResultField<String>("PurgDocMigrtnIsCmpltdForAnlyts");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalCritraDelivCompleted</b>
     * </p>
     *
     * @return Delivery Completed
     */
    @SerializedName( "SuplrEvalCritraDelivCompleted" )
    @JsonProperty( "SuplrEvalCritraDelivCompleted" )
    @Nullable
    @ODataField( odataName = "SuplrEvalCritraDelivCompleted" )
    private String suplrEvalCritraDelivCompleted;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalCritraDelivCompleted</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> SUPLR_EVAL_CRITRA_DELIV_COMPLETED =
        new SupplierOplScoresAVResultField<String>("SuplrEvalCritraDelivCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRelevantDocCategory</b>
     * </p>
     *
     * @return Supplier Evaluation Configuration for Document Category type
     */
    @SerializedName( "SuplrEvalRelevantDocCategory" )
    @JsonProperty( "SuplrEvalRelevantDocCategory" )
    @Nullable
    @ODataField( odataName = "SuplrEvalRelevantDocCategory" )
    private String suplrEvalRelevantDocCategory;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalRelevantDocCategory</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> SUPLR_EVAL_RELEVANT_DOC_CATEGORY =
        new SupplierOplScoresAVResultField<String>("SuplrEvalRelevantDocCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYear</b>
     * </p>
     *
     * @return Calendar Year
     */
    @SerializedName( "CalendarYear" )
    @JsonProperty( "CalendarYear" )
    @Nullable
    @ODataField( odataName = "CalendarYear" )
    private String calendarYear;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYear</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> CALENDAR_YEAR =
        new SupplierOplScoresAVResultField<String>("CalendarYear");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CalendarQuarter</b>
     * </p>
     *
     * @return Calendar Quarter
     */
    @SerializedName( "CalendarQuarter" )
    @JsonProperty( "CalendarQuarter" )
    @Nullable
    @ODataField( odataName = "CalendarQuarter" )
    private String calendarQuarter;
    /**
     * Use with available fluent helpers to apply the <b>CalendarQuarter</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> CALENDAR_QUARTER =
        new SupplierOplScoresAVResultField<String>("CalendarQuarter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth</b>
     * </p>
     *
     * @return Calendar Month
     */
    @SerializedName( "CalendarMonth" )
    @JsonProperty( "CalendarMonth" )
    @Nullable
    @ODataField( odataName = "CalendarMonth" )
    private String calendarMonth;
    /**
     * Use with available fluent helpers to apply the <b>CalendarMonth</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> CALENDAR_MONTH =
        new SupplierOplScoresAVResultField<String>("CalendarMonth");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarWeek</b>
     * </p>
     *
     * @return Calendar Week
     */
    @SerializedName( "CalendarWeek" )
    @JsonProperty( "CalendarWeek" )
    @Nullable
    @ODataField( odataName = "CalendarWeek" )
    private String calendarWeek;
    /**
     * Use with available fluent helpers to apply the <b>CalendarWeek</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> CALENDAR_WEEK =
        new SupplierOplScoresAVResultField<String>("CalendarWeek");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PURCHASING_ORGANIZATION =
        new SupplierOplScoresAVResultField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganizationName</b>
     * </p>
     *
     * @return Purchasing Organization Name
     */
    @SerializedName( "PurchasingOrganizationName" )
    @JsonProperty( "PurchasingOrganizationName" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganizationName" )
    private String purchasingOrganizationName;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganizationName</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PURCHASING_ORGANIZATION_NAME =
        new SupplierOplScoresAVResultField<String>("PurchasingOrganizationName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PURCHASING_GROUP =
        new SupplierOplScoresAVResultField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroupName</b>
     * </p>
     *
     * @return Purchasing Group Name
     */
    @SerializedName( "PurchasingGroupName" )
    @JsonProperty( "PurchasingGroupName" )
    @Nullable
    @ODataField( odataName = "PurchasingGroupName" )
    private String purchasingGroupName;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroupName</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PURCHASING_GROUP_NAME =
        new SupplierOplScoresAVResultField<String>("PurchasingGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> COMPANY_CODE =
        new SupplierOplScoresAVResultField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> SUPPLIER =
        new SupplierOplScoresAVResultField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SupplierName</b>
     * </p>
     *
     * @return Name of Supplier
     */
    @SerializedName( "SupplierName" )
    @JsonProperty( "SupplierName" )
    @Nullable
    @ODataField( odataName = "SupplierName" )
    private String supplierName;
    /**
     * Use with available fluent helpers to apply the <b>SupplierName</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> SUPPLIER_NAME =
        new SupplierOplScoresAVResultField<String>("SupplierName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierCountry</b>
     * </p>
     *
     * @return Supplier Country/Region
     */
    @SerializedName( "SupplierCountry" )
    @JsonProperty( "SupplierCountry" )
    @Nullable
    @ODataField( odataName = "SupplierCountry" )
    private String supplierCountry;
    /**
     * Use with available fluent helpers to apply the <b>SupplierCountry</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> SUPPLIER_COUNTRY =
        new SupplierOplScoresAVResultField<String>("SupplierCountry");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CountryName</b>
     * </p>
     *
     * @return Country/Region Name
     */
    @SerializedName( "CountryName" )
    @JsonProperty( "CountryName" )
    @Nullable
    @ODataField( odataName = "CountryName" )
    private String countryName;
    /**
     * Use with available fluent helpers to apply the <b>CountryName</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> COUNTRY_NAME =
        new SupplierOplScoresAVResultField<String>("CountryName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> MATERIAL =
        new SupplierOplScoresAVResultField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @return Material Description
     */
    @SerializedName( "MaterialName" )
    @JsonProperty( "MaterialName" )
    @Nullable
    @ODataField( odataName = "MaterialName" )
    private String materialName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialName</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> MATERIAL_NAME =
        new SupplierOplScoresAVResultField<String>("MaterialName");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> MATERIAL_GROUP =
        new SupplierOplScoresAVResultField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupName</b>
     * </p>
     *
     * @return Product Group Description
     */
    @SerializedName( "MaterialGroupName" )
    @JsonProperty( "MaterialGroupName" )
    @Nullable
    @ODataField( odataName = "MaterialGroupName" )
    private String materialGroupName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupName</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> MATERIAL_GROUP_NAME =
        new SupplierOplScoresAVResultField<String>("MaterialGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PLANT =
        new SupplierOplScoresAVResultField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @return Plant Name
     */
    @SerializedName( "PlantName" )
    @JsonProperty( "PlantName" )
    @Nullable
    @ODataField( odataName = "PlantName" )
    private String plantName;
    /**
     * Use with available fluent helpers to apply the <b>PlantName</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PLANT_NAME =
        new SupplierOplScoresAVResultField<String>("PlantName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingCategory</b>
     * </p>
     *
     * @return Purchasing Category ID
     */
    @SerializedName( "PurchasingCategory" )
    @JsonProperty( "PurchasingCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingCategory" )
    private String purchasingCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingCategory</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PURCHASING_CATEGORY =
        new SupplierOplScoresAVResultField<String>("PurchasingCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatName</b>
     * </p>
     *
     * @return Name of Purchasing Category
     */
    @SerializedName( "PurgCatName" )
    @JsonProperty( "PurgCatName" )
    @Nullable
    @ODataField( odataName = "PurgCatName" )
    private String purgCatName;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatName</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> PURG_CAT_NAME =
        new SupplierOplScoresAVResultField<String>("PurgCatName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisplayCurrency</b>
     * </p>
     *
     * @return Display Currency
     */
    @SerializedName( "DisplayCurrency" )
    @JsonProperty( "DisplayCurrency" )
    @Nullable
    @ODataField( odataName = "DisplayCurrency" )
    private String displayCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DisplayCurrency</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<String> DISPLAY_CURRENCY =
        new SupplierOplScoresAVResultField<String>("DisplayCurrency");
    /**
     * Constraints: Not nullable, Precision: 21, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderNetPriceAmount</b>
     * </p>
     *
     * @return Purchase Order Net Amount
     */
    @SerializedName( "PurchaseOrderNetPriceAmount" )
    @JsonProperty( "PurchaseOrderNetPriceAmount" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderNetPriceAmount" )
    private BigDecimal purchaseOrderNetPriceAmount;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderNetPriceAmount</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<BigDecimal> PURCHASE_ORDER_NET_PRICE_AMOUNT =
        new SupplierOplScoresAVResultField<BigDecimal>("PurchaseOrderNetPriceAmount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TimeVarianceScore</b>
     * </p>
     *
     * @return Time Variance Score
     */
    @SerializedName( "TimeVarianceScore" )
    @JsonProperty( "TimeVarianceScore" )
    @Nullable
    @ODataField( odataName = "TimeVarianceScore" )
    private Double timeVarianceScore;
    /**
     * Use with available fluent helpers to apply the <b>TimeVarianceScore</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<Double> TIME_VARIANCE_SCORE =
        new SupplierOplScoresAVResultField<Double>("TimeVarianceScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceVarianceScore</b>
     * </p>
     *
     * @return Price Variance Score
     */
    @SerializedName( "PriceVarianceScore" )
    @JsonProperty( "PriceVarianceScore" )
    @Nullable
    @ODataField( odataName = "PriceVarianceScore" )
    private Double priceVarianceScore;
    /**
     * Use with available fluent helpers to apply the <b>PriceVarianceScore</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<Double> PRICE_VARIANCE_SCORE =
        new SupplierOplScoresAVResultField<Double>("PriceVarianceScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityVarianceScore</b>
     * </p>
     *
     * @return Quantity Variance Score
     */
    @SerializedName( "QuantityVarianceScore" )
    @JsonProperty( "QuantityVarianceScore" )
    @Nullable
    @ODataField( odataName = "QuantityVarianceScore" )
    private Double quantityVarianceScore;
    /**
     * Use with available fluent helpers to apply the <b>QuantityVarianceScore</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<Double> QUANTITY_VARIANCE_SCORE =
        new SupplierOplScoresAVResultField<Double>("QuantityVarianceScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotQualityScore</b>
     * </p>
     *
     * @return Inspection Lot Score
     */
    @SerializedName( "InspectionLotQualityScore" )
    @JsonProperty( "InspectionLotQualityScore" )
    @Nullable
    @ODataField( odataName = "InspectionLotQualityScore" )
    private Double inspectionLotQualityScore;
    /**
     * Use with available fluent helpers to apply the <b>InspectionLotQualityScore</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<Double> INSPECTION_LOT_QUALITY_SCORE =
        new SupplierOplScoresAVResultField<Double>("InspectionLotQualityScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QualityNotificationScore</b>
     * </p>
     *
     * @return Quality Notification Score
     */
    @SerializedName( "QualityNotificationScore" )
    @JsonProperty( "QualityNotificationScore" )
    @Nullable
    @ODataField( odataName = "QualityNotificationScore" )
    private Double qualityNotificationScore;
    /**
     * Use with available fluent helpers to apply the <b>QualityNotificationScore</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<Double> QUALITY_NOTIFICATION_SCORE =
        new SupplierOplScoresAVResultField<Double>("QualityNotificationScore");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplierOperationalScore</b>
     * </p>
     *
     * @return Supplier Operational Score
     */
    @SerializedName( "SupplierOperationalScore" )
    @JsonProperty( "SupplierOperationalScore" )
    @Nullable
    @ODataField( odataName = "SupplierOperationalScore" )
    private BigDecimal supplierOperationalScore;
    /**
     * Use with available fluent helpers to apply the <b>SupplierOperationalScore</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<BigDecimal> SUPPLIER_OPERATIONAL_SCORE =
        new SupplierOplScoresAVResultField<BigDecimal>("SupplierOperationalScore");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalTimeVarcScrInDcmlVal</b>
     * </p>
     *
     * @return Time Variance Score
     */
    @SerializedName( "SuplrEvalTimeVarcScrInDcmlVal" )
    @JsonProperty( "SuplrEvalTimeVarcScrInDcmlVal" )
    @Nullable
    @ODataField( odataName = "SuplrEvalTimeVarcScrInDcmlVal" )
    private BigDecimal suplrEvalTimeVarcScrInDcmlVal;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalTimeVarcScrInDcmlVal</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<BigDecimal> SUPLR_EVAL_TIME_VARC_SCR_IN_DCML_VAL =
        new SupplierOplScoresAVResultField<BigDecimal>("SuplrEvalTimeVarcScrInDcmlVal");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalPriceVarcScrInDcmlVal</b>
     * </p>
     *
     * @return Price Variance Score
     */
    @SerializedName( "SuplrEvalPriceVarcScrInDcmlVal" )
    @JsonProperty( "SuplrEvalPriceVarcScrInDcmlVal" )
    @Nullable
    @ODataField( odataName = "SuplrEvalPriceVarcScrInDcmlVal" )
    private BigDecimal suplrEvalPriceVarcScrInDcmlVal;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalPriceVarcScrInDcmlVal</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<BigDecimal> SUPLR_EVAL_PRICE_VARC_SCR_IN_DCML_VAL =
        new SupplierOplScoresAVResultField<BigDecimal>("SuplrEvalPriceVarcScrInDcmlVal");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalQtyVarcScrInDcmlVal</b>
     * </p>
     *
     * @return Quantity Variance Score
     */
    @SerializedName( "SuplrEvalQtyVarcScrInDcmlVal" )
    @JsonProperty( "SuplrEvalQtyVarcScrInDcmlVal" )
    @Nullable
    @ODataField( odataName = "SuplrEvalQtyVarcScrInDcmlVal" )
    private BigDecimal suplrEvalQtyVarcScrInDcmlVal;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalQtyVarcScrInDcmlVal</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<BigDecimal> SUPLR_EVAL_QTY_VARC_SCR_IN_DCML_VAL =
        new SupplierOplScoresAVResultField<BigDecimal>("SuplrEvalQtyVarcScrInDcmlVal");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalInspLotScrInDcmlVal</b>
     * </p>
     *
     * @return Inspection Lot Score
     */
    @SerializedName( "SuplrEvalInspLotScrInDcmlVal" )
    @JsonProperty( "SuplrEvalInspLotScrInDcmlVal" )
    @Nullable
    @ODataField( odataName = "SuplrEvalInspLotScrInDcmlVal" )
    private BigDecimal suplrEvalInspLotScrInDcmlVal;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalInspLotScrInDcmlVal</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<BigDecimal> SUPLR_EVAL_INSP_LOT_SCR_IN_DCML_VAL =
        new SupplierOplScoresAVResultField<BigDecimal>("SuplrEvalInspLotScrInDcmlVal");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalQltyNotifScrInDcmlVal</b>
     * </p>
     *
     * @return Quality Notification Score
     */
    @SerializedName( "SuplrEvalQltyNotifScrInDcmlVal" )
    @JsonProperty( "SuplrEvalQltyNotifScrInDcmlVal" )
    @Nullable
    @ODataField( odataName = "SuplrEvalQltyNotifScrInDcmlVal" )
    private BigDecimal suplrEvalQltyNotifScrInDcmlVal;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalQltyNotifScrInDcmlVal</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<BigDecimal> SUPLR_EVAL_QLTY_NOTIF_SCR_IN_DCML_VAL =
        new SupplierOplScoresAVResultField<BigDecimal>("SuplrEvalQltyNotifScrInDcmlVal");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOplScrInDcmlVal</b>
     * </p>
     *
     * @return Supplier Operational Score
     */
    @SerializedName( "SuplrEvalOplScrInDcmlVal" )
    @JsonProperty( "SuplrEvalOplScrInDcmlVal" )
    @Nullable
    @ODataField( odataName = "SuplrEvalOplScrInDcmlVal" )
    private BigDecimal suplrEvalOplScrInDcmlVal;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalOplScrInDcmlVal</b> field to query operations.
     *
     */
    public final static SupplierOplScoresAVResultField<BigDecimal> SUPLR_EVAL_OPL_SCR_IN_DCML_VAL =
        new SupplierOplScoresAVResultField<BigDecimal>("SuplrEvalOplScrInDcmlVal");
    /**
     * Navigation property <b>Parameters</b> for <b>SupplierOplScoresAVResult</b> to single
     * <b>SupplierOplScoresAVParameters</b>.
     *
     */
    @SerializedName( "Parameters" )
    @JsonProperty( "Parameters" )
    @ODataField( odataName = "Parameters" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SupplierOplScoresAVParameters toParameters;
    /**
     * Use with available fluent helpers to apply the <b>Parameters</b> navigation property to query operations.
     *
     */
    public final static SupplierOplScoresAVResultOneToOneLink<SupplierOplScoresAVParameters> TO_PARAMETERS =
        new SupplierOplScoresAVResultOneToOneLink<SupplierOplScoresAVParameters>("Parameters");

    @Nonnull
    @Override
    public Class<SupplierOplScoresAVResult> getType()
    {
        return SupplierOplScoresAVResult.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ID</b>
     * </p>
     *
     * @param iD
     *            The iD to set.
     */
    public void setID( @Nullable final String iD )
    {
        rememberChangedField("ID", this.iD);
        this.iD = iD;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchasing Document Item
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocMigrtnIsCmpltdForAnlyts</b>
     * </p>
     *
     * @param purgDocMigrtnIsCmpltdForAnlyts
     *            Single-Character Flag
     */
    public void setPurgDocMigrtnIsCmpltdForAnlyts( @Nullable final String purgDocMigrtnIsCmpltdForAnlyts )
    {
        rememberChangedField("PurgDocMigrtnIsCmpltdForAnlyts", this.purgDocMigrtnIsCmpltdForAnlyts);
        this.purgDocMigrtnIsCmpltdForAnlyts = purgDocMigrtnIsCmpltdForAnlyts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalCritraDelivCompleted</b>
     * </p>
     *
     * @param suplrEvalCritraDelivCompleted
     *            Delivery Completed
     */
    public void setSuplrEvalCritraDelivCompleted( @Nullable final String suplrEvalCritraDelivCompleted )
    {
        rememberChangedField("SuplrEvalCritraDelivCompleted", this.suplrEvalCritraDelivCompleted);
        this.suplrEvalCritraDelivCompleted = suplrEvalCritraDelivCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalRelevantDocCategory</b>
     * </p>
     *
     * @param suplrEvalRelevantDocCategory
     *            Supplier Evaluation Configuration for Document Category type
     */
    public void setSuplrEvalRelevantDocCategory( @Nullable final String suplrEvalRelevantDocCategory )
    {
        rememberChangedField("SuplrEvalRelevantDocCategory", this.suplrEvalRelevantDocCategory);
        this.suplrEvalRelevantDocCategory = suplrEvalRelevantDocCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYear</b>
     * </p>
     *
     * @param calendarYear
     *            Calendar Year
     */
    public void setCalendarYear( @Nullable final String calendarYear )
    {
        rememberChangedField("CalendarYear", this.calendarYear);
        this.calendarYear = calendarYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CalendarQuarter</b>
     * </p>
     *
     * @param calendarQuarter
     *            Calendar Quarter
     */
    public void setCalendarQuarter( @Nullable final String calendarQuarter )
    {
        rememberChangedField("CalendarQuarter", this.calendarQuarter);
        this.calendarQuarter = calendarQuarter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth</b>
     * </p>
     *
     * @param calendarMonth
     *            Calendar Month
     */
    public void setCalendarMonth( @Nullable final String calendarMonth )
    {
        rememberChangedField("CalendarMonth", this.calendarMonth);
        this.calendarMonth = calendarMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarWeek</b>
     * </p>
     *
     * @param calendarWeek
     *            Calendar Week
     */
    public void setCalendarWeek( @Nullable final String calendarWeek )
    {
        rememberChangedField("CalendarWeek", this.calendarWeek);
        this.calendarWeek = calendarWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganizationName</b>
     * </p>
     *
     * @param purchasingOrganizationName
     *            Purchasing Organization Name
     */
    public void setPurchasingOrganizationName( @Nullable final String purchasingOrganizationName )
    {
        rememberChangedField("PurchasingOrganizationName", this.purchasingOrganizationName);
        this.purchasingOrganizationName = purchasingOrganizationName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroupName</b>
     * </p>
     *
     * @param purchasingGroupName
     *            Purchasing Group Name
     */
    public void setPurchasingGroupName( @Nullable final String purchasingGroupName )
    {
        rememberChangedField("PurchasingGroupName", this.purchasingGroupName);
        this.purchasingGroupName = purchasingGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SupplierName</b>
     * </p>
     *
     * @param supplierName
     *            Name of Supplier
     */
    public void setSupplierName( @Nullable final String supplierName )
    {
        rememberChangedField("SupplierName", this.supplierName);
        this.supplierName = supplierName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierCountry</b>
     * </p>
     *
     * @param supplierCountry
     *            Supplier Country/Region
     */
    public void setSupplierCountry( @Nullable final String supplierCountry )
    {
        rememberChangedField("SupplierCountry", this.supplierCountry);
        this.supplierCountry = supplierCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CountryName</b>
     * </p>
     *
     * @param countryName
     *            Country/Region Name
     */
    public void setCountryName( @Nullable final String countryName )
    {
        rememberChangedField("CountryName", this.countryName);
        this.countryName = countryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @param materialName
     *            Material Description
     */
    public void setMaterialName( @Nullable final String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupName</b>
     * </p>
     *
     * @param materialGroupName
     *            Product Group Description
     */
    public void setMaterialGroupName( @Nullable final String materialGroupName )
    {
        rememberChangedField("MaterialGroupName", this.materialGroupName);
        this.materialGroupName = materialGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @param plantName
     *            Plant Name
     */
    public void setPlantName( @Nullable final String plantName )
    {
        rememberChangedField("PlantName", this.plantName);
        this.plantName = plantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingCategory</b>
     * </p>
     *
     * @param purchasingCategory
     *            Purchasing Category ID
     */
    public void setPurchasingCategory( @Nullable final String purchasingCategory )
    {
        rememberChangedField("PurchasingCategory", this.purchasingCategory);
        this.purchasingCategory = purchasingCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatName</b>
     * </p>
     *
     * @param purgCatName
     *            Name of Purchasing Category
     */
    public void setPurgCatName( @Nullable final String purgCatName )
    {
        rememberChangedField("PurgCatName", this.purgCatName);
        this.purgCatName = purgCatName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisplayCurrency</b>
     * </p>
     *
     * @param displayCurrency
     *            Display Currency
     */
    public void setDisplayCurrency( @Nullable final String displayCurrency )
    {
        rememberChangedField("DisplayCurrency", this.displayCurrency);
        this.displayCurrency = displayCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 21, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderNetPriceAmount</b>
     * </p>
     *
     * @param purchaseOrderNetPriceAmount
     *            Purchase Order Net Amount
     */
    public void setPurchaseOrderNetPriceAmount( @Nullable final BigDecimal purchaseOrderNetPriceAmount )
    {
        rememberChangedField("PurchaseOrderNetPriceAmount", this.purchaseOrderNetPriceAmount);
        this.purchaseOrderNetPriceAmount = purchaseOrderNetPriceAmount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TimeVarianceScore</b>
     * </p>
     *
     * @param timeVarianceScore
     *            Time Variance Score
     */
    public void setTimeVarianceScore( @Nullable final Double timeVarianceScore )
    {
        rememberChangedField("TimeVarianceScore", this.timeVarianceScore);
        this.timeVarianceScore = timeVarianceScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceVarianceScore</b>
     * </p>
     *
     * @param priceVarianceScore
     *            Price Variance Score
     */
    public void setPriceVarianceScore( @Nullable final Double priceVarianceScore )
    {
        rememberChangedField("PriceVarianceScore", this.priceVarianceScore);
        this.priceVarianceScore = priceVarianceScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityVarianceScore</b>
     * </p>
     *
     * @param quantityVarianceScore
     *            Quantity Variance Score
     */
    public void setQuantityVarianceScore( @Nullable final Double quantityVarianceScore )
    {
        rememberChangedField("QuantityVarianceScore", this.quantityVarianceScore);
        this.quantityVarianceScore = quantityVarianceScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspectionLotQualityScore</b>
     * </p>
     *
     * @param inspectionLotQualityScore
     *            Inspection Lot Score
     */
    public void setInspectionLotQualityScore( @Nullable final Double inspectionLotQualityScore )
    {
        rememberChangedField("InspectionLotQualityScore", this.inspectionLotQualityScore);
        this.inspectionLotQualityScore = inspectionLotQualityScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QualityNotificationScore</b>
     * </p>
     *
     * @param qualityNotificationScore
     *            Quality Notification Score
     */
    public void setQualityNotificationScore( @Nullable final Double qualityNotificationScore )
    {
        rememberChangedField("QualityNotificationScore", this.qualityNotificationScore);
        this.qualityNotificationScore = qualityNotificationScore;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplierOperationalScore</b>
     * </p>
     *
     * @param supplierOperationalScore
     *            Supplier Operational Score
     */
    public void setSupplierOperationalScore( @Nullable final BigDecimal supplierOperationalScore )
    {
        rememberChangedField("SupplierOperationalScore", this.supplierOperationalScore);
        this.supplierOperationalScore = supplierOperationalScore;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalTimeVarcScrInDcmlVal</b>
     * </p>
     *
     * @param suplrEvalTimeVarcScrInDcmlVal
     *            Time Variance Score
     */
    public void setSuplrEvalTimeVarcScrInDcmlVal( @Nullable final BigDecimal suplrEvalTimeVarcScrInDcmlVal )
    {
        rememberChangedField("SuplrEvalTimeVarcScrInDcmlVal", this.suplrEvalTimeVarcScrInDcmlVal);
        this.suplrEvalTimeVarcScrInDcmlVal = suplrEvalTimeVarcScrInDcmlVal;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalPriceVarcScrInDcmlVal</b>
     * </p>
     *
     * @param suplrEvalPriceVarcScrInDcmlVal
     *            Price Variance Score
     */
    public void setSuplrEvalPriceVarcScrInDcmlVal( @Nullable final BigDecimal suplrEvalPriceVarcScrInDcmlVal )
    {
        rememberChangedField("SuplrEvalPriceVarcScrInDcmlVal", this.suplrEvalPriceVarcScrInDcmlVal);
        this.suplrEvalPriceVarcScrInDcmlVal = suplrEvalPriceVarcScrInDcmlVal;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalQtyVarcScrInDcmlVal</b>
     * </p>
     *
     * @param suplrEvalQtyVarcScrInDcmlVal
     *            Quantity Variance Score
     */
    public void setSuplrEvalQtyVarcScrInDcmlVal( @Nullable final BigDecimal suplrEvalQtyVarcScrInDcmlVal )
    {
        rememberChangedField("SuplrEvalQtyVarcScrInDcmlVal", this.suplrEvalQtyVarcScrInDcmlVal);
        this.suplrEvalQtyVarcScrInDcmlVal = suplrEvalQtyVarcScrInDcmlVal;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalInspLotScrInDcmlVal</b>
     * </p>
     *
     * @param suplrEvalInspLotScrInDcmlVal
     *            Inspection Lot Score
     */
    public void setSuplrEvalInspLotScrInDcmlVal( @Nullable final BigDecimal suplrEvalInspLotScrInDcmlVal )
    {
        rememberChangedField("SuplrEvalInspLotScrInDcmlVal", this.suplrEvalInspLotScrInDcmlVal);
        this.suplrEvalInspLotScrInDcmlVal = suplrEvalInspLotScrInDcmlVal;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalQltyNotifScrInDcmlVal</b>
     * </p>
     *
     * @param suplrEvalQltyNotifScrInDcmlVal
     *            Quality Notification Score
     */
    public void setSuplrEvalQltyNotifScrInDcmlVal( @Nullable final BigDecimal suplrEvalQltyNotifScrInDcmlVal )
    {
        rememberChangedField("SuplrEvalQltyNotifScrInDcmlVal", this.suplrEvalQltyNotifScrInDcmlVal);
        this.suplrEvalQltyNotifScrInDcmlVal = suplrEvalQltyNotifScrInDcmlVal;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOplScrInDcmlVal</b>
     * </p>
     *
     * @param suplrEvalOplScrInDcmlVal
     *            Supplier Operational Score
     */
    public void setSuplrEvalOplScrInDcmlVal( @Nullable final BigDecimal suplrEvalOplScrInDcmlVal )
    {
        rememberChangedField("SuplrEvalOplScrInDcmlVal", this.suplrEvalOplScrInDcmlVal);
        this.suplrEvalOplScrInDcmlVal = suplrEvalOplScrInDcmlVal;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SupplierOplScoresAVResults";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ID", getID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ID", getID());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("PurgDocMigrtnIsCmpltdForAnlyts", getPurgDocMigrtnIsCmpltdForAnlyts());
        values.put("SuplrEvalCritraDelivCompleted", getSuplrEvalCritraDelivCompleted());
        values.put("SuplrEvalRelevantDocCategory", getSuplrEvalRelevantDocCategory());
        values.put("CalendarYear", getCalendarYear());
        values.put("CalendarQuarter", getCalendarQuarter());
        values.put("CalendarMonth", getCalendarMonth());
        values.put("CalendarWeek", getCalendarWeek());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingOrganizationName", getPurchasingOrganizationName());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("PurchasingGroupName", getPurchasingGroupName());
        values.put("CompanyCode", getCompanyCode());
        values.put("Supplier", getSupplier());
        values.put("SupplierName", getSupplierName());
        values.put("SupplierCountry", getSupplierCountry());
        values.put("CountryName", getCountryName());
        values.put("Material", getMaterial());
        values.put("MaterialName", getMaterialName());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialGroupName", getMaterialGroupName());
        values.put("Plant", getPlant());
        values.put("PlantName", getPlantName());
        values.put("PurchasingCategory", getPurchasingCategory());
        values.put("PurgCatName", getPurgCatName());
        values.put("DisplayCurrency", getDisplayCurrency());
        values.put("PurchaseOrderNetPriceAmount", getPurchaseOrderNetPriceAmount());
        values.put("TimeVarianceScore", getTimeVarianceScore());
        values.put("PriceVarianceScore", getPriceVarianceScore());
        values.put("QuantityVarianceScore", getQuantityVarianceScore());
        values.put("InspectionLotQualityScore", getInspectionLotQualityScore());
        values.put("QualityNotificationScore", getQualityNotificationScore());
        values.put("SupplierOperationalScore", getSupplierOperationalScore());
        values.put("SuplrEvalTimeVarcScrInDcmlVal", getSuplrEvalTimeVarcScrInDcmlVal());
        values.put("SuplrEvalPriceVarcScrInDcmlVal", getSuplrEvalPriceVarcScrInDcmlVal());
        values.put("SuplrEvalQtyVarcScrInDcmlVal", getSuplrEvalQtyVarcScrInDcmlVal());
        values.put("SuplrEvalInspLotScrInDcmlVal", getSuplrEvalInspLotScrInDcmlVal());
        values.put("SuplrEvalQltyNotifScrInDcmlVal", getSuplrEvalQltyNotifScrInDcmlVal());
        values.put("SuplrEvalOplScrInDcmlVal", getSuplrEvalOplScrInDcmlVal());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ID") ) {
                final Object value = values.remove("ID");
                if( (value == null) || (!value.equals(getID())) ) {
                    setID(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PurgDocMigrtnIsCmpltdForAnlyts") ) {
                final Object value = values.remove("PurgDocMigrtnIsCmpltdForAnlyts");
                if( (value == null) || (!value.equals(getPurgDocMigrtnIsCmpltdForAnlyts())) ) {
                    setPurgDocMigrtnIsCmpltdForAnlyts(((String) value));
                }
            }
            if( values.containsKey("SuplrEvalCritraDelivCompleted") ) {
                final Object value = values.remove("SuplrEvalCritraDelivCompleted");
                if( (value == null) || (!value.equals(getSuplrEvalCritraDelivCompleted())) ) {
                    setSuplrEvalCritraDelivCompleted(((String) value));
                }
            }
            if( values.containsKey("SuplrEvalRelevantDocCategory") ) {
                final Object value = values.remove("SuplrEvalRelevantDocCategory");
                if( (value == null) || (!value.equals(getSuplrEvalRelevantDocCategory())) ) {
                    setSuplrEvalRelevantDocCategory(((String) value));
                }
            }
            if( values.containsKey("CalendarYear") ) {
                final Object value = values.remove("CalendarYear");
                if( (value == null) || (!value.equals(getCalendarYear())) ) {
                    setCalendarYear(((String) value));
                }
            }
            if( values.containsKey("CalendarQuarter") ) {
                final Object value = values.remove("CalendarQuarter");
                if( (value == null) || (!value.equals(getCalendarQuarter())) ) {
                    setCalendarQuarter(((String) value));
                }
            }
            if( values.containsKey("CalendarMonth") ) {
                final Object value = values.remove("CalendarMonth");
                if( (value == null) || (!value.equals(getCalendarMonth())) ) {
                    setCalendarMonth(((String) value));
                }
            }
            if( values.containsKey("CalendarWeek") ) {
                final Object value = values.remove("CalendarWeek");
                if( (value == null) || (!value.equals(getCalendarWeek())) ) {
                    setCalendarWeek(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganizationName") ) {
                final Object value = values.remove("PurchasingOrganizationName");
                if( (value == null) || (!value.equals(getPurchasingOrganizationName())) ) {
                    setPurchasingOrganizationName(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroupName") ) {
                final Object value = values.remove("PurchasingGroupName");
                if( (value == null) || (!value.equals(getPurchasingGroupName())) ) {
                    setPurchasingGroupName(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("SupplierName") ) {
                final Object value = values.remove("SupplierName");
                if( (value == null) || (!value.equals(getSupplierName())) ) {
                    setSupplierName(((String) value));
                }
            }
            if( values.containsKey("SupplierCountry") ) {
                final Object value = values.remove("SupplierCountry");
                if( (value == null) || (!value.equals(getSupplierCountry())) ) {
                    setSupplierCountry(((String) value));
                }
            }
            if( values.containsKey("CountryName") ) {
                final Object value = values.remove("CountryName");
                if( (value == null) || (!value.equals(getCountryName())) ) {
                    setCountryName(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroupName") ) {
                final Object value = values.remove("MaterialGroupName");
                if( (value == null) || (!value.equals(getMaterialGroupName())) ) {
                    setMaterialGroupName(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PlantName") ) {
                final Object value = values.remove("PlantName");
                if( (value == null) || (!value.equals(getPlantName())) ) {
                    setPlantName(((String) value));
                }
            }
            if( values.containsKey("PurchasingCategory") ) {
                final Object value = values.remove("PurchasingCategory");
                if( (value == null) || (!value.equals(getPurchasingCategory())) ) {
                    setPurchasingCategory(((String) value));
                }
            }
            if( values.containsKey("PurgCatName") ) {
                final Object value = values.remove("PurgCatName");
                if( (value == null) || (!value.equals(getPurgCatName())) ) {
                    setPurgCatName(((String) value));
                }
            }
            if( values.containsKey("DisplayCurrency") ) {
                final Object value = values.remove("DisplayCurrency");
                if( (value == null) || (!value.equals(getDisplayCurrency())) ) {
                    setDisplayCurrency(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderNetPriceAmount") ) {
                final Object value = values.remove("PurchaseOrderNetPriceAmount");
                if( (value == null) || (!value.equals(getPurchaseOrderNetPriceAmount())) ) {
                    setPurchaseOrderNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TimeVarianceScore") ) {
                final Object value = values.remove("TimeVarianceScore");
                if( (value == null) || (!value.equals(getTimeVarianceScore())) ) {
                    setTimeVarianceScore(((Double) value));
                }
            }
            if( values.containsKey("PriceVarianceScore") ) {
                final Object value = values.remove("PriceVarianceScore");
                if( (value == null) || (!value.equals(getPriceVarianceScore())) ) {
                    setPriceVarianceScore(((Double) value));
                }
            }
            if( values.containsKey("QuantityVarianceScore") ) {
                final Object value = values.remove("QuantityVarianceScore");
                if( (value == null) || (!value.equals(getQuantityVarianceScore())) ) {
                    setQuantityVarianceScore(((Double) value));
                }
            }
            if( values.containsKey("InspectionLotQualityScore") ) {
                final Object value = values.remove("InspectionLotQualityScore");
                if( (value == null) || (!value.equals(getInspectionLotQualityScore())) ) {
                    setInspectionLotQualityScore(((Double) value));
                }
            }
            if( values.containsKey("QualityNotificationScore") ) {
                final Object value = values.remove("QualityNotificationScore");
                if( (value == null) || (!value.equals(getQualityNotificationScore())) ) {
                    setQualityNotificationScore(((Double) value));
                }
            }
            if( values.containsKey("SupplierOperationalScore") ) {
                final Object value = values.remove("SupplierOperationalScore");
                if( (value == null) || (!value.equals(getSupplierOperationalScore())) ) {
                    setSupplierOperationalScore(((BigDecimal) value));
                }
            }
            if( values.containsKey("SuplrEvalTimeVarcScrInDcmlVal") ) {
                final Object value = values.remove("SuplrEvalTimeVarcScrInDcmlVal");
                if( (value == null) || (!value.equals(getSuplrEvalTimeVarcScrInDcmlVal())) ) {
                    setSuplrEvalTimeVarcScrInDcmlVal(((BigDecimal) value));
                }
            }
            if( values.containsKey("SuplrEvalPriceVarcScrInDcmlVal") ) {
                final Object value = values.remove("SuplrEvalPriceVarcScrInDcmlVal");
                if( (value == null) || (!value.equals(getSuplrEvalPriceVarcScrInDcmlVal())) ) {
                    setSuplrEvalPriceVarcScrInDcmlVal(((BigDecimal) value));
                }
            }
            if( values.containsKey("SuplrEvalQtyVarcScrInDcmlVal") ) {
                final Object value = values.remove("SuplrEvalQtyVarcScrInDcmlVal");
                if( (value == null) || (!value.equals(getSuplrEvalQtyVarcScrInDcmlVal())) ) {
                    setSuplrEvalQtyVarcScrInDcmlVal(((BigDecimal) value));
                }
            }
            if( values.containsKey("SuplrEvalInspLotScrInDcmlVal") ) {
                final Object value = values.remove("SuplrEvalInspLotScrInDcmlVal");
                if( (value == null) || (!value.equals(getSuplrEvalInspLotScrInDcmlVal())) ) {
                    setSuplrEvalInspLotScrInDcmlVal(((BigDecimal) value));
                }
            }
            if( values.containsKey("SuplrEvalQltyNotifScrInDcmlVal") ) {
                final Object value = values.remove("SuplrEvalQltyNotifScrInDcmlVal");
                if( (value == null) || (!value.equals(getSuplrEvalQltyNotifScrInDcmlVal())) ) {
                    setSuplrEvalQltyNotifScrInDcmlVal(((BigDecimal) value));
                }
            }
            if( values.containsKey("SuplrEvalOplScrInDcmlVal") ) {
                final Object value = values.remove("SuplrEvalOplScrInDcmlVal");
                if( (value == null) || (!value.equals(getSuplrEvalOplScrInDcmlVal())) ) {
                    setSuplrEvalOplScrInDcmlVal(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Parameters") ) {
                final Object value = (values).remove("Parameters");
                if( value instanceof Map ) {
                    if( toParameters == null ) {
                        toParameters = new SupplierOplScoresAVParameters();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toParameters.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SupplierOplScoresAVResultField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplierOplScoresAVResultField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierOplScoresAVResultField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierOplScoresAVResultField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toParameters != null ) {
            (values).put("Parameters", toParameters);
        }
        return values;
    }

    /**
     * Fetches the <b>SupplierOplScoresAVParameters</b> entity (one to one) associated with this entity. This
     * corresponds to the OData navigation property <b>Parameters</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SupplierOplScoresAVParameters</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SupplierOplScoresAVParameters fetchParameters()
    {
        return fetchFieldAsSingle("Parameters", SupplierOplScoresAVParameters.class);
    }

    /**
     * Retrieval of associated <b>SupplierOplScoresAVParameters</b> entity (one to one). This corresponds to the OData
     * navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property <b>Parameters</b> of a queried <b>SupplierOplScoresAVResult</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SupplierOplScoresAVParameters</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SupplierOplScoresAVParameters getParametersOrFetch()
    {
        if( toParameters == null ) {
            toParameters = fetchParameters();
        }
        return toParameters;
    }

    /**
     * Retrieval of associated <b>SupplierOplScoresAVParameters</b> entity (one to one). This corresponds to the OData
     * navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierOplScoresAVResult</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Parameters</b> is already loaded, the result will contain
     *         the <b>SupplierOplScoresAVParameters</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SupplierOplScoresAVParameters> getParametersIfPresent()
    {
        return Option.of(toParameters);
    }

    /**
     * Overwrites the associated <b>SupplierOplScoresAVParameters</b> entity for the loaded navigation property
     * <b>Parameters</b>.
     *
     * @param value
     *            New <b>SupplierOplScoresAVParameters</b> entity.
     */
    public void setParameters( final SupplierOplScoresAVParameters value )
    {
        toParameters = value;
    }

    /**
     * Helper class to allow for fluent creation of SupplierOplScoresAVResult instances.
     *
     */
    public final static class SupplierOplScoresAVResultBuilder
    {

        private SupplierOplScoresAVParameters toParameters;

        private SupplierOplScoresAVResult.SupplierOplScoresAVResultBuilder toParameters(
            final SupplierOplScoresAVParameters value )
        {
            toParameters = value;
            return this;
        }

        /**
         * Navigation property <b>Parameters</b> for <b>SupplierOplScoresAVResult</b> to single
         * <b>SupplierOplScoresAVParameters</b>.
         *
         * @param value
         *            The SupplierOplScoresAVParameters to build this SupplierOplScoresAVResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierOplScoresAVResult.SupplierOplScoresAVResultBuilder parameters(
            final SupplierOplScoresAVParameters value )
        {
            return toParameters(value);
        }

    }

}
