/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SupplierEvaluationScoreServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService
 * SupplierEvaluationScoreService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSupplierEvaluationScoreServiceBatch
    extends
    BatchFluentHelperBasic<SupplierEvaluationScoreServiceBatch, SupplierEvaluationScoreServiceBatchChangeSet>
    implements
    SupplierEvaluationScoreServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSupplierEvaluationScoreServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierEvaluationScoreServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSupplierEvaluationScoreServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSupplierEvaluationScoreServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSupplierEvaluationScoreServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSupplierEvaluationScoreServiceBatchChangeSet(this, service);
    }

}
