/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp;

/**
 * Implementation of the {@link SupplierEvaluationScoreServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService
 * SupplierEvaluationScoreService}.
 *
 */
public class DefaultSupplierEvaluationScoreServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SupplierEvaluationScoreServiceBatch, SupplierEvaluationScoreServiceBatchChangeSet>
    implements
    SupplierEvaluationScoreServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService service;

    @SuppressWarnings( "deprecation" )
    DefaultSupplierEvaluationScoreServiceBatchChangeSet(
        @Nonnull final DefaultSupplierEvaluationScoreServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScoreService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSupplierEvaluationScoreServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet createSAP__Currency(
        @Nonnull final SAP__Currency sAP__Currency )
    {
        return addRequestCreate(service::createSAP__Currency, sAP__Currency);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet updateSAP__Currency(
        @Nonnull final SAP__Currency sAP__Currency )
    {
        return addRequestUpdate(service::updateSAP__Currency, sAP__Currency);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet deleteSAP__Currency(
        @Nonnull final SAP__Currency sAP__Currency )
    {
        return addRequestDelete(service::deleteSAP__Currency, sAP__Currency);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet createSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return addRequestCreate(service::createSAP__UnitOfMeasure, sAP__UnitOfMeasure);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet updateSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return addRequestUpdate(service::updateSAP__UnitOfMeasure, sAP__UnitOfMeasure);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet deleteSAP__UnitOfMeasure(
        @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure )
    {
        return addRequestDelete(service::deleteSAP__UnitOfMeasure, sAP__UnitOfMeasure);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet createSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return addRequestCreate(service::createSAP__DocumentDescription, sAP__DocumentDescription);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet updateSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return addRequestUpdate(service::updateSAP__DocumentDescription, sAP__DocumentDescription);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet deleteSAP__DocumentDescription(
        @Nonnull final SAP__DocumentDescription sAP__DocumentDescription )
    {
        return addRequestDelete(service::deleteSAP__DocumentDescription, sAP__DocumentDescription);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet createSAP__ValueHelp(
        @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return addRequestCreate(service::createSAP__ValueHelp, sAP__ValueHelp);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet updateSAP__ValueHelp(
        @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return addRequestUpdate(service::updateSAP__ValueHelp, sAP__ValueHelp);
    }

    @Nonnull
    @Override
    public SupplierEvaluationScoreServiceBatchChangeSet deleteSAP__ValueHelp(
        @Nonnull final SAP__ValueHelp sAP__ValueHelp )
    {
        return addRequestDelete(service::deleteSAP__ValueHelp, sAP__ValueHelp);
    }

}
