/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable.SAP__DocumentDescriptionSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
 * SAP__DocumentDescription} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class SAP__DocumentDescriptionLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<SAP__DocumentDescriptionLink<ObjectT>, SAP__DocumentDescription, ObjectT>
    implements
    SAP__DocumentDescriptionSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public SAP__DocumentDescriptionLink( final String fieldName )
    {
        super(fieldName);
    }

    private SAP__DocumentDescriptionLink(
        final EntityLink<SAP__DocumentDescriptionLink<ObjectT>, SAP__DocumentDescription, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected SAP__DocumentDescriptionLink<ObjectT> translateLinkType(
        final EntityLink<SAP__DocumentDescriptionLink<ObjectT>, SAP__DocumentDescription, ObjectT> link )
    {
        return new SAP__DocumentDescriptionLink<ObjectT>(link);
    }

}
