/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Format;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Format SAP__Format}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.field.SAP__FormatField
 * SAP__FormatField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.link.SAP__FormatLink
 * SAP__FormatLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Format#ID ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Format#FONT_SIZE
 * FONT_SIZE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Format#ORIENTATION
 * ORIENTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Format#PAPER_SIZE
 * PAPER_SIZE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Format#BORDER_SIZE
 * BORDER_SIZE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Format#MARGIN_SIZE
 * MARGIN_SIZE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Format#FONT_NAME
 * FONT_NAME}</li>
 * </ul>
 *
 */
public interface SAP__FormatSelectable extends EntitySelectable<SAP__Format>
{

}
