/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParameters;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParameters
 * SupplierOplScoresAVParameters}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.field.SupplierOplScoresAVParametersField
 * SupplierOplScoresAVParametersField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.link.SupplierOplScoresAVParametersLink
 * SupplierOplScoresAVParametersLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParameters#P_DISPLAY_CURRENCY
 * P_DISPLAY_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParameters#P_DATE_FUNCTION
 * P_DATE_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParameters#TO_RESULTS
 * TO_RESULTS}</li>
 * </ul>
 *
 */
public interface SupplierOplScoresAVParametersSelectable extends EntitySelectable<SupplierOplScoresAVParameters>
{

}
