/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult
 * SupplierOplScoresAVResult}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.field.SupplierOplScoresAVResultField
 * SupplierOplScoresAVResultField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.link.SupplierOplScoresAVResultLink
 * SupplierOplScoresAVResultLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#ID
 * ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PURG_DOC_MIGRTN_IS_CMPLTD_FOR_ANLYTS
 * PURG_DOC_MIGRTN_IS_CMPLTD_FOR_ANLYTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPLR_EVAL_CRITRA_DELIV_COMPLETED
 * SUPLR_EVAL_CRITRA_DELIV_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPLR_EVAL_RELEVANT_DOC_CATEGORY
 * SUPLR_EVAL_RELEVANT_DOC_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#CALENDAR_YEAR
 * CALENDAR_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#CALENDAR_QUARTER
 * CALENDAR_QUARTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#CALENDAR_MONTH
 * CALENDAR_MONTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#CALENDAR_WEEK
 * CALENDAR_WEEK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PURCHASING_ORGANIZATION_NAME
 * PURCHASING_ORGANIZATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PURCHASING_GROUP_NAME
 * PURCHASING_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPPLIER_NAME
 * SUPPLIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPPLIER_COUNTRY
 * SUPPLIER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#COUNTRY_NAME
 * COUNTRY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#MATERIAL_NAME
 * MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#MATERIAL_GROUP_NAME
 * MATERIAL_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PLANT_NAME
 * PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PURCHASING_CATEGORY
 * PURCHASING_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PURG_CAT_NAME
 * PURG_CAT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#DISPLAY_CURRENCY
 * DISPLAY_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PURCHASE_ORDER_NET_PRICE_AMOUNT
 * PURCHASE_ORDER_NET_PRICE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#TIME_VARIANCE_SCORE
 * TIME_VARIANCE_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#PRICE_VARIANCE_SCORE
 * PRICE_VARIANCE_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#QUANTITY_VARIANCE_SCORE
 * QUANTITY_VARIANCE_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#INSPECTION_LOT_QUALITY_SCORE
 * INSPECTION_LOT_QUALITY_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#QUALITY_NOTIFICATION_SCORE
 * QUALITY_NOTIFICATION_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPPLIER_OPERATIONAL_SCORE
 * SUPPLIER_OPERATIONAL_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPLR_EVAL_TIME_VARC_SCR_IN_DCML_VAL
 * SUPLR_EVAL_TIME_VARC_SCR_IN_DCML_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPLR_EVAL_PRICE_VARC_SCR_IN_DCML_VAL
 * SUPLR_EVAL_PRICE_VARC_SCR_IN_DCML_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPLR_EVAL_QTY_VARC_SCR_IN_DCML_VAL
 * SUPLR_EVAL_QTY_VARC_SCR_IN_DCML_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPLR_EVAL_INSP_LOT_SCR_IN_DCML_VAL
 * SUPLR_EVAL_INSP_LOT_SCR_IN_DCML_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPLR_EVAL_QLTY_NOTIF_SCR_IN_DCML_VAL
 * SUPLR_EVAL_QLTY_NOTIF_SCR_IN_DCML_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#SUPLR_EVAL_OPL_SCR_IN_DCML_VAL
 * SUPLR_EVAL_OPL_SCR_IN_DCML_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVResult#TO_PARAMETERS
 * TO_PARAMETERS}</li>
 * </ul>
 *
 */
public interface SupplierOplScoresAVResultSelectable extends EntitySelectable<SupplierOplScoresAVResult>
{

}
