/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalSccrdPurchaserRespField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable.SuplrEvalSccrdPurchaserRespSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Purchaser Responsible
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalSccrdPurchaserRespType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalSccrdPurchaserResp extends VdmEntity<SuplrEvalSccrdPurchaserResp>
{

    /**
     * Selector for all available fields of SuplrEvalSccrdPurchaserResp.
     *
     */
    public final static SuplrEvalSccrdPurchaserRespSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardPtyUUID</b>
     * </p>
     *
     * @return Evaluation Response Party UUID
     */
    @Key
    @SerializedName( "SuplrEvalScorecardPtyUUID" )
    @JsonProperty( "SuplrEvalScorecardPtyUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalScorecardPtyUUID" )
    private UUID suplrEvalScorecardPtyUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalScorecardPtyUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdPurchaserRespField<UUID> SUPLR_EVAL_SCORECARD_PTY_UUID =
        new SuplrEvalSccrdPurchaserRespField<UUID>("SuplrEvalScorecardPtyUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardUUID</b>
     * </p>
     *
     * @return Evaluation Scorecard UUID
     */
    @SerializedName( "SuplrEvalScorecardUUID" )
    @JsonProperty( "SuplrEvalScorecardUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalScorecardUUID" )
    private UUID suplrEvalScorecardUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalScorecardUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdPurchaserRespField<UUID> SUPLR_EVAL_SCORECARD_UUID =
        new SuplrEvalSccrdPurchaserRespField<UUID>("SuplrEvalScorecardUUID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>UserID</b>
     * </p>
     *
     * @return User ID
     */
    @SerializedName( "UserID" )
    @JsonProperty( "UserID" )
    @Nullable
    @ODataField( odataName = "UserID" )
    private String userID;
    /**
     * Use with available fluent helpers to apply the <b>UserID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdPurchaserRespField<String> USER_ID =
        new SuplrEvalSccrdPurchaserRespField<String>("UserID");

    @Nonnull
    @Override
    public Class<SuplrEvalSccrdPurchaserResp> getType()
    {
        return SuplrEvalSccrdPurchaserResp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardPtyUUID</b>
     * </p>
     *
     * @param suplrEvalScorecardPtyUUID
     *            Evaluation Response Party UUID
     */
    public void setSuplrEvalScorecardPtyUUID( @Nullable final UUID suplrEvalScorecardPtyUUID )
    {
        rememberChangedField("SuplrEvalScorecardPtyUUID", this.suplrEvalScorecardPtyUUID);
        this.suplrEvalScorecardPtyUUID = suplrEvalScorecardPtyUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardUUID</b>
     * </p>
     *
     * @param suplrEvalScorecardUUID
     *            Evaluation Scorecard UUID
     */
    public void setSuplrEvalScorecardUUID( @Nullable final UUID suplrEvalScorecardUUID )
    {
        rememberChangedField("SuplrEvalScorecardUUID", this.suplrEvalScorecardUUID);
        this.suplrEvalScorecardUUID = suplrEvalScorecardUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>UserID</b>
     * </p>
     *
     * @param userID
     *            User ID
     */
    public void setUserID( @Nullable final String userID )
    {
        rememberChangedField("UserID", this.userID);
        this.userID = userID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalSccrdPurchaserResp";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalScorecardPtyUUID", getSuplrEvalScorecardPtyUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalScorecardPtyUUID", getSuplrEvalScorecardPtyUUID());
        values.put("SuplrEvalScorecardUUID", getSuplrEvalScorecardUUID());
        values.put("UserID", getUserID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalScorecardPtyUUID") ) {
                final Object value = values.remove("SuplrEvalScorecardPtyUUID");
                if( (value == null) || (!value.equals(getSuplrEvalScorecardPtyUUID())) ) {
                    setSuplrEvalScorecardPtyUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalScorecardUUID") ) {
                final Object value = values.remove("SuplrEvalScorecardUUID");
                if( (value == null) || (!value.equals(getSuplrEvalScorecardUUID())) ) {
                    setSuplrEvalScorecardUUID(((UUID) value));
                }
            }
            if( values.containsKey("UserID") ) {
                final Object value = values.remove("UserID");
                if( (value == null) || (!value.equals(getUserID())) ) {
                    setUserID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SuplrEvalSccrdPurchaserRespField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalSccrdPurchaserRespField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalSccrdPurchaserRespField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalSccrdPurchaserRespField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScorecardService.DEFAULT_SERVICE_PATH);
    }

}
