/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable.SuplrEvalSccrdPurchaserRespSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp
 * SuplrEvalSccrdPurchaserResp} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SuplrEvalSccrdPurchaserRespByKeyFluentHelper
    extends
    FluentHelperByKey<SuplrEvalSccrdPurchaserRespByKeyFluentHelper, SuplrEvalSccrdPurchaserResp, SuplrEvalSccrdPurchaserRespSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp
     * SuplrEvalSccrdPurchaserResp} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SuplrEvalSccrdPurchaserResp}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SuplrEvalSccrdPurchaserResp}
     * @param suplrEvalScorecardPtyUUID
     *            Evaluation Response Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public SuplrEvalSccrdPurchaserRespByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID suplrEvalScorecardPtyUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("SuplrEvalScorecardPtyUUID", suplrEvalScorecardPtyUUID);
    }

    @Override
    @Nonnull
    protected Class<SuplrEvalSccrdPurchaserResp> getEntityClass()
    {
        return SuplrEvalSccrdPurchaserResp.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
