/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalSccrdQuestionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable.SuplrEvalSccrdQuestionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Question
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalSccrdQuestionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalSccrdQuestion extends VdmEntity<SuplrEvalSccrdQuestion>
{

    /**
     * Selector for all available fields of SuplrEvalSccrdQuestion.
     *
     */
    public final static SuplrEvalSccrdQuestionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalSccrdQuestionUUID</b>
     * </p>
     *
     * @return Evaluation Scorecard Question UUID
     */
    @Key
    @SerializedName( "SuplrEvalSccrdQuestionUUID" )
    @JsonProperty( "SuplrEvalSccrdQuestionUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalSccrdQuestionUUID" )
    private UUID suplrEvalSccrdQuestionUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalSccrdQuestionUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<UUID> SUPLR_EVAL_SCCRD_QUESTION_UUID =
        new SuplrEvalSccrdQuestionField<UUID>("SuplrEvalSccrdQuestionUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalSccrdUUID</b>
     * </p>
     *
     * @return Evaluation Scorecard UUID
     */
    @SerializedName( "SuplrEvalSccrdUUID" )
    @JsonProperty( "SuplrEvalSccrdUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalSccrdUUID" )
    private UUID suplrEvalSccrdUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalSccrdUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<UUID> SUPLR_EVAL_SCCRD_UUID =
        new SuplrEvalSccrdQuestionField<UUID>("SuplrEvalSccrdUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalSccrdSectionUUID</b>
     * </p>
     *
     * @return Evaluation Scorecard Section UUID
     */
    @SerializedName( "SuplrEvalSccrdSectionUUID" )
    @JsonProperty( "SuplrEvalSccrdSectionUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalSccrdSectionUUID" )
    private UUID suplrEvalSccrdSectionUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalSccrdSectionUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<UUID> SUPLR_EVAL_SCCRD_SECTION_UUID =
        new SuplrEvalSccrdQuestionField<UUID>("SuplrEvalSccrdSectionUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqQuestionUUID</b>
     * </p>
     *
     * @return Evaluation Request Question UUID
     */
    @SerializedName( "SuplrEvalReqQuestionUUID" )
    @JsonProperty( "SuplrEvalReqQuestionUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalReqQuestionUUID" )
    private UUID suplrEvalReqQuestionUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalReqQuestionUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<UUID> SUPLR_EVAL_REQ_QUESTION_UUID =
        new SuplrEvalSccrdQuestionField<UUID>("SuplrEvalReqQuestionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalQuestion</b>
     * </p>
     *
     * @return Identifier for a Question
     */
    @SerializedName( "SupplierEvalQuestion" )
    @JsonProperty( "SupplierEvalQuestion" )
    @Nullable
    @ODataField( odataName = "SupplierEvalQuestion" )
    private String supplierEvalQuestion;
    /**
     * Use with available fluent helpers to apply the <b>SupplierEvalQuestion</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<String> SUPPLIER_EVAL_QUESTION =
        new SuplrEvalSccrdQuestionField<String>("SupplierEvalQuestion");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalRequestQuestion</b>
     * </p>
     *
     * @return Identifier for a Question
     */
    @SerializedName( "SupplierEvalRequestQuestion" )
    @JsonProperty( "SupplierEvalRequestQuestion" )
    @Nullable
    @ODataField( odataName = "SupplierEvalRequestQuestion" )
    private String supplierEvalRequestQuestion;
    /**
     * Use with available fluent helpers to apply the <b>SupplierEvalRequestQuestion</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<String> SUPPLIER_EVAL_REQUEST_QUESTION =
        new SuplrEvalSccrdQuestionField<String>("SupplierEvalRequestQuestion");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>QuestionName</b>
     * </p>
     *
     * @return Medium-Size Name
     */
    @SerializedName( "QuestionName" )
    @JsonProperty( "QuestionName" )
    @Nullable
    @ODataField( odataName = "QuestionName" )
    private String questionName;
    /**
     * Use with available fluent helpers to apply the <b>QuestionName</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<String> QUESTION_NAME =
        new SuplrEvalSccrdQuestionField<String>("QuestionName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SLCQuestionType</b>
     * </p>
     *
     * @return Question Type Code
     */
    @SerializedName( "SLCQuestionType" )
    @JsonProperty( "SLCQuestionType" )
    @Nullable
    @ODataField( odataName = "SLCQuestionType" )
    private String sLCQuestionType;
    /**
     * Use with available fluent helpers to apply the <b>SLCQuestionType</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<String> SLC_QUESTION_TYPE =
        new SuplrEvalSccrdQuestionField<String>("SLCQuestionType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @return Value of Weighting Factor
     */
    @SerializedName( "WeightingFactor" )
    @JsonProperty( "WeightingFactor" )
    @Nullable
    @ODataField( odataName = "WeightingFactor" )
    private Short weightingFactor;
    /**
     * Use with available fluent helpers to apply the <b>WeightingFactor</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<Short> WEIGHTING_FACTOR =
        new SuplrEvalSccrdQuestionField<Short>("WeightingFactor");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @return Minimum Score Accepted
     */
    @SerializedName( "MinimalScore" )
    @JsonProperty( "MinimalScore" )
    @Nullable
    @ODataField( odataName = "MinimalScore" )
    private Short minimalScore;
    /**
     * Use with available fluent helpers to apply the <b>MinimalScore</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<Short> MINIMAL_SCORE =
        new SuplrEvalSccrdQuestionField<Short>("MinimalScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @return Target Score
     */
    @SerializedName( "TargetScore" )
    @JsonProperty( "TargetScore" )
    @Nullable
    @ODataField( odataName = "TargetScore" )
    private Short targetScore;
    /**
     * Use with available fluent helpers to apply the <b>TargetScore</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdQuestionField<Short> TARGET_SCORE =
        new SuplrEvalSccrdQuestionField<Short>("TargetScore");

    @Nonnull
    @Override
    public Class<SuplrEvalSccrdQuestion> getType()
    {
        return SuplrEvalSccrdQuestion.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalSccrdQuestionUUID</b>
     * </p>
     *
     * @param suplrEvalSccrdQuestionUUID
     *            Evaluation Scorecard Question UUID
     */
    public void setSuplrEvalSccrdQuestionUUID( @Nullable final UUID suplrEvalSccrdQuestionUUID )
    {
        rememberChangedField("SuplrEvalSccrdQuestionUUID", this.suplrEvalSccrdQuestionUUID);
        this.suplrEvalSccrdQuestionUUID = suplrEvalSccrdQuestionUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalSccrdUUID</b>
     * </p>
     *
     * @param suplrEvalSccrdUUID
     *            Evaluation Scorecard UUID
     */
    public void setSuplrEvalSccrdUUID( @Nullable final UUID suplrEvalSccrdUUID )
    {
        rememberChangedField("SuplrEvalSccrdUUID", this.suplrEvalSccrdUUID);
        this.suplrEvalSccrdUUID = suplrEvalSccrdUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalSccrdSectionUUID</b>
     * </p>
     *
     * @param suplrEvalSccrdSectionUUID
     *            Evaluation Scorecard Section UUID
     */
    public void setSuplrEvalSccrdSectionUUID( @Nullable final UUID suplrEvalSccrdSectionUUID )
    {
        rememberChangedField("SuplrEvalSccrdSectionUUID", this.suplrEvalSccrdSectionUUID);
        this.suplrEvalSccrdSectionUUID = suplrEvalSccrdSectionUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalReqQuestionUUID</b>
     * </p>
     *
     * @param suplrEvalReqQuestionUUID
     *            Evaluation Request Question UUID
     */
    public void setSuplrEvalReqQuestionUUID( @Nullable final UUID suplrEvalReqQuestionUUID )
    {
        rememberChangedField("SuplrEvalReqQuestionUUID", this.suplrEvalReqQuestionUUID);
        this.suplrEvalReqQuestionUUID = suplrEvalReqQuestionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalQuestion</b>
     * </p>
     *
     * @param supplierEvalQuestion
     *            Identifier for a Question
     */
    public void setSupplierEvalQuestion( @Nullable final String supplierEvalQuestion )
    {
        rememberChangedField("SupplierEvalQuestion", this.supplierEvalQuestion);
        this.supplierEvalQuestion = supplierEvalQuestion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalRequestQuestion</b>
     * </p>
     *
     * @param supplierEvalRequestQuestion
     *            Identifier for a Question
     */
    public void setSupplierEvalRequestQuestion( @Nullable final String supplierEvalRequestQuestion )
    {
        rememberChangedField("SupplierEvalRequestQuestion", this.supplierEvalRequestQuestion);
        this.supplierEvalRequestQuestion = supplierEvalRequestQuestion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>QuestionName</b>
     * </p>
     *
     * @param questionName
     *            Medium-Size Name
     */
    public void setQuestionName( @Nullable final String questionName )
    {
        rememberChangedField("QuestionName", this.questionName);
        this.questionName = questionName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SLCQuestionType</b>
     * </p>
     *
     * @param sLCQuestionType
     *            Question Type Code
     */
    public void setSLCQuestionType( @Nullable final String sLCQuestionType )
    {
        rememberChangedField("SLCQuestionType", this.sLCQuestionType);
        this.sLCQuestionType = sLCQuestionType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @param weightingFactor
     *            Value of Weighting Factor
     */
    public void setWeightingFactor( @Nullable final Short weightingFactor )
    {
        rememberChangedField("WeightingFactor", this.weightingFactor);
        this.weightingFactor = weightingFactor;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @param minimalScore
     *            Minimum Score Accepted
     */
    public void setMinimalScore( @Nullable final Short minimalScore )
    {
        rememberChangedField("MinimalScore", this.minimalScore);
        this.minimalScore = minimalScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @param targetScore
     *            Target Score
     */
    public void setTargetScore( @Nullable final Short targetScore )
    {
        rememberChangedField("TargetScore", this.targetScore);
        this.targetScore = targetScore;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalSccrdQuestion";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalSccrdQuestionUUID", getSuplrEvalSccrdQuestionUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalSccrdQuestionUUID", getSuplrEvalSccrdQuestionUUID());
        values.put("SuplrEvalSccrdUUID", getSuplrEvalSccrdUUID());
        values.put("SuplrEvalSccrdSectionUUID", getSuplrEvalSccrdSectionUUID());
        values.put("SuplrEvalReqQuestionUUID", getSuplrEvalReqQuestionUUID());
        values.put("SupplierEvalQuestion", getSupplierEvalQuestion());
        values.put("SupplierEvalRequestQuestion", getSupplierEvalRequestQuestion());
        values.put("QuestionName", getQuestionName());
        values.put("SLCQuestionType", getSLCQuestionType());
        values.put("WeightingFactor", getWeightingFactor());
        values.put("MinimalScore", getMinimalScore());
        values.put("TargetScore", getTargetScore());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalSccrdQuestionUUID") ) {
                final Object value = values.remove("SuplrEvalSccrdQuestionUUID");
                if( (value == null) || (!value.equals(getSuplrEvalSccrdQuestionUUID())) ) {
                    setSuplrEvalSccrdQuestionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalSccrdUUID") ) {
                final Object value = values.remove("SuplrEvalSccrdUUID");
                if( (value == null) || (!value.equals(getSuplrEvalSccrdUUID())) ) {
                    setSuplrEvalSccrdUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalSccrdSectionUUID") ) {
                final Object value = values.remove("SuplrEvalSccrdSectionUUID");
                if( (value == null) || (!value.equals(getSuplrEvalSccrdSectionUUID())) ) {
                    setSuplrEvalSccrdSectionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalReqQuestionUUID") ) {
                final Object value = values.remove("SuplrEvalReqQuestionUUID");
                if( (value == null) || (!value.equals(getSuplrEvalReqQuestionUUID())) ) {
                    setSuplrEvalReqQuestionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplierEvalQuestion") ) {
                final Object value = values.remove("SupplierEvalQuestion");
                if( (value == null) || (!value.equals(getSupplierEvalQuestion())) ) {
                    setSupplierEvalQuestion(((String) value));
                }
            }
            if( values.containsKey("SupplierEvalRequestQuestion") ) {
                final Object value = values.remove("SupplierEvalRequestQuestion");
                if( (value == null) || (!value.equals(getSupplierEvalRequestQuestion())) ) {
                    setSupplierEvalRequestQuestion(((String) value));
                }
            }
            if( values.containsKey("QuestionName") ) {
                final Object value = values.remove("QuestionName");
                if( (value == null) || (!value.equals(getQuestionName())) ) {
                    setQuestionName(((String) value));
                }
            }
            if( values.containsKey("SLCQuestionType") ) {
                final Object value = values.remove("SLCQuestionType");
                if( (value == null) || (!value.equals(getSLCQuestionType())) ) {
                    setSLCQuestionType(((String) value));
                }
            }
            if( values.containsKey("WeightingFactor") ) {
                final Object value = values.remove("WeightingFactor");
                if( (value == null) || (!value.equals(getWeightingFactor())) ) {
                    setWeightingFactor(((Short) value));
                }
            }
            if( values.containsKey("MinimalScore") ) {
                final Object value = values.remove("MinimalScore");
                if( (value == null) || (!value.equals(getMinimalScore())) ) {
                    setMinimalScore(((Short) value));
                }
            }
            if( values.containsKey("TargetScore") ) {
                final Object value = values.remove("TargetScore");
                if( (value == null) || (!value.equals(getTargetScore())) ) {
                    setTargetScore(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalSccrdQuestionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalSccrdQuestionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalSccrdQuestionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalSccrdQuestionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScorecardService.DEFAULT_SERVICE_PATH);
    }

}
