/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalSccrdStrucQnaireField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.link.SuplrEvalSccrdStrucQnaireLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.link.SuplrEvalSccrdStrucQnaireOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable.SuplrEvalSccrdStrucQnaireSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Structure Questionnaire
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalSccrdStrucQnaireType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalSccrdStrucQnaire extends VdmEntity<SuplrEvalSccrdStrucQnaire>
{

    /**
     * Selector for all available fields of SuplrEvalSccrdStrucQnaire.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardQnaireUUID</b>
     * </p>
     *
     * @return Evaluation Scorecard Questionnaire UUID
     */
    @Key
    @SerializedName( "SuplrEvalScorecardQnaireUUID" )
    @JsonProperty( "SuplrEvalScorecardQnaireUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalScorecardQnaireUUID" )
    private UUID suplrEvalScorecardQnaireUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalScorecardQnaireUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireField<UUID> SUPLR_EVAL_SCORECARD_QNAIRE_UUID =
        new SuplrEvalSccrdStrucQnaireField<UUID>("SuplrEvalScorecardQnaireUUID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>QuestionnaireName</b>
     * </p>
     *
     * @return Medium-Size Name
     */
    @SerializedName( "QuestionnaireName" )
    @JsonProperty( "QuestionnaireName" )
    @Nullable
    @ODataField( odataName = "QuestionnaireName" )
    private String questionnaireName;
    /**
     * Use with available fluent helpers to apply the <b>QuestionnaireName</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireField<String> QUESTIONNAIRE_NAME =
        new SuplrEvalSccrdStrucQnaireField<String>("QuestionnaireName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalScorecardQnaire</b>
     * </p>
     *
     * @return Supplier Evaluation Scorecard Questionnaire
     */
    @SerializedName( "SupplierEvalScorecardQnaire" )
    @JsonProperty( "SupplierEvalScorecardQnaire" )
    @Nullable
    @ODataField( odataName = "SupplierEvalScorecardQnaire" )
    private String supplierEvalScorecardQnaire;
    /**
     * Use with available fluent helpers to apply the <b>SupplierEvalScorecardQnaire</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireField<String> SUPPLIER_EVAL_SCORECARD_QNAIRE =
        new SuplrEvalSccrdStrucQnaireField<String>("SupplierEvalScorecardQnaire");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardRtQnaireUUID</b>
     * </p>
     *
     * @return Evaluation Scorecard Parent Hierarchy UUID
     */
    @SerializedName( "SuplrEvalScorecardRtQnaireUUID" )
    @JsonProperty( "SuplrEvalScorecardRtQnaireUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalScorecardRtQnaireUUID" )
    private UUID suplrEvalScorecardRtQnaireUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalScorecardRtQnaireUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireField<UUID> SUPLR_EVAL_SCORECARD_RT_QNAIRE_UUID =
        new SuplrEvalSccrdStrucQnaireField<UUID>("SuplrEvalScorecardRtQnaireUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @return Minimum Score Accepted
     */
    @SerializedName( "MinimalScore" )
    @JsonProperty( "MinimalScore" )
    @Nullable
    @ODataField( odataName = "MinimalScore" )
    private Short minimalScore;
    /**
     * Use with available fluent helpers to apply the <b>MinimalScore</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireField<Short> MINIMAL_SCORE =
        new SuplrEvalSccrdStrucQnaireField<Short>("MinimalScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @return Target Score
     */
    @SerializedName( "TargetScore" )
    @JsonProperty( "TargetScore" )
    @Nullable
    @ODataField( odataName = "TargetScore" )
    private Short targetScore;
    /**
     * Use with available fluent helpers to apply the <b>TargetScore</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireField<Short> TARGET_SCORE =
        new SuplrEvalSccrdStrucQnaireField<Short>("TargetScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedScore</b>
     * </p>
     *
     * @return Calculated Score
     */
    @SerializedName( "CalculatedScore" )
    @JsonProperty( "CalculatedScore" )
    @Nullable
    @ODataField( odataName = "CalculatedScore" )
    private Double calculatedScore;
    /**
     * Use with available fluent helpers to apply the <b>CalculatedScore</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireField<Double> CALCULATED_SCORE =
        new SuplrEvalSccrdStrucQnaireField<Double>("CalculatedScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @return Number of Responses
     */
    @SerializedName( "NumberOfResponses" )
    @JsonProperty( "NumberOfResponses" )
    @Nullable
    @ODataField( odataName = "NumberOfResponses" )
    private Integer numberOfResponses;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfResponses</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireField<Integer> NUMBER_OF_RESPONSES =
        new SuplrEvalSccrdStrucQnaireField<Integer>("NumberOfResponses");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @return Value of Weighting Factor
     */
    @SerializedName( "WeightingFactor" )
    @JsonProperty( "WeightingFactor" )
    @Nullable
    @ODataField( odataName = "WeightingFactor" )
    private Short weightingFactor;
    /**
     * Use with available fluent helpers to apply the <b>WeightingFactor</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireField<Short> WEIGHTING_FACTOR =
        new SuplrEvalSccrdStrucQnaireField<Short>("WeightingFactor");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOrdinalNumber</b>
     * </p>
     *
     * @return Ordinal Number Value
     */
    @SerializedName( "SuplrEvalOrdinalNumber" )
    @JsonProperty( "SuplrEvalOrdinalNumber" )
    @Nullable
    @ODataField( odataName = "SuplrEvalOrdinalNumber" )
    private Integer suplrEvalOrdinalNumber;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalOrdinalNumber</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireField<Integer> SUPLR_EVAL_ORDINAL_NUMBER =
        new SuplrEvalSccrdStrucQnaireField<Integer>("SuplrEvalOrdinalNumber");
    /**
     * Navigation property <b>to_SuplrEvalSccrdSection</b> for <b>SuplrEvalSccrdStrucQnaire</b> to multiple
     * <b>SuplrEvalSccrdSection</b>.
     *
     */
    @SerializedName( "to_SuplrEvalSccrdSection" )
    @JsonProperty( "to_SuplrEvalSccrdSection" )
    @ODataField( odataName = "to_SuplrEvalSccrdSection" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalSccrdSection> toSuplrEvalSccrdSection;
    /**
     * Navigation property <b>to_SuplrEvalScorecardRootQnaire</b> for <b>SuplrEvalSccrdStrucQnaire</b> to single
     * <b>SuplrEvalScorecardRootQnaire</b>.
     *
     */
    @SerializedName( "to_SuplrEvalScorecardRootQnaire" )
    @JsonProperty( "to_SuplrEvalScorecardRootQnaire" )
    @ODataField( odataName = "to_SuplrEvalScorecardRootQnaire" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrEvalScorecardRootQnaire toSuplrEvalScorecardRootQnaire;
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalSccrdSection</b> navigation property to query
     * operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireLink<SuplrEvalSccrdSection> TO_SUPLR_EVAL_SCCRD_SECTION =
        new SuplrEvalSccrdStrucQnaireLink<SuplrEvalSccrdSection>("to_SuplrEvalSccrdSection");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalScorecardRootQnaire</b> navigation property to
     * query operations.
     *
     */
    public final static SuplrEvalSccrdStrucQnaireOneToOneLink<SuplrEvalScorecardRootQnaire> TO_SUPLR_EVAL_SCORECARD_ROOT_QNAIRE =
        new SuplrEvalSccrdStrucQnaireOneToOneLink<SuplrEvalScorecardRootQnaire>("to_SuplrEvalScorecardRootQnaire");

    @Nonnull
    @Override
    public Class<SuplrEvalSccrdStrucQnaire> getType()
    {
        return SuplrEvalSccrdStrucQnaire.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardQnaireUUID</b>
     * </p>
     *
     * @param suplrEvalScorecardQnaireUUID
     *            Evaluation Scorecard Questionnaire UUID
     */
    public void setSuplrEvalScorecardQnaireUUID( @Nullable final UUID suplrEvalScorecardQnaireUUID )
    {
        rememberChangedField("SuplrEvalScorecardQnaireUUID", this.suplrEvalScorecardQnaireUUID);
        this.suplrEvalScorecardQnaireUUID = suplrEvalScorecardQnaireUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>QuestionnaireName</b>
     * </p>
     *
     * @param questionnaireName
     *            Medium-Size Name
     */
    public void setQuestionnaireName( @Nullable final String questionnaireName )
    {
        rememberChangedField("QuestionnaireName", this.questionnaireName);
        this.questionnaireName = questionnaireName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalScorecardQnaire</b>
     * </p>
     *
     * @param supplierEvalScorecardQnaire
     *            Supplier Evaluation Scorecard Questionnaire
     */
    public void setSupplierEvalScorecardQnaire( @Nullable final String supplierEvalScorecardQnaire )
    {
        rememberChangedField("SupplierEvalScorecardQnaire", this.supplierEvalScorecardQnaire);
        this.supplierEvalScorecardQnaire = supplierEvalScorecardQnaire;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardRtQnaireUUID</b>
     * </p>
     *
     * @param suplrEvalScorecardRtQnaireUUID
     *            Evaluation Scorecard Parent Hierarchy UUID
     */
    public void setSuplrEvalScorecardRtQnaireUUID( @Nullable final UUID suplrEvalScorecardRtQnaireUUID )
    {
        rememberChangedField("SuplrEvalScorecardRtQnaireUUID", this.suplrEvalScorecardRtQnaireUUID);
        this.suplrEvalScorecardRtQnaireUUID = suplrEvalScorecardRtQnaireUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @param minimalScore
     *            Minimum Score Accepted
     */
    public void setMinimalScore( @Nullable final Short minimalScore )
    {
        rememberChangedField("MinimalScore", this.minimalScore);
        this.minimalScore = minimalScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @param targetScore
     *            Target Score
     */
    public void setTargetScore( @Nullable final Short targetScore )
    {
        rememberChangedField("TargetScore", this.targetScore);
        this.targetScore = targetScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedScore</b>
     * </p>
     *
     * @param calculatedScore
     *            Calculated Score
     */
    public void setCalculatedScore( @Nullable final Double calculatedScore )
    {
        rememberChangedField("CalculatedScore", this.calculatedScore);
        this.calculatedScore = calculatedScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @param numberOfResponses
     *            Number of Responses
     */
    public void setNumberOfResponses( @Nullable final Integer numberOfResponses )
    {
        rememberChangedField("NumberOfResponses", this.numberOfResponses);
        this.numberOfResponses = numberOfResponses;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @param weightingFactor
     *            Value of Weighting Factor
     */
    public void setWeightingFactor( @Nullable final Short weightingFactor )
    {
        rememberChangedField("WeightingFactor", this.weightingFactor);
        this.weightingFactor = weightingFactor;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOrdinalNumber</b>
     * </p>
     *
     * @param suplrEvalOrdinalNumber
     *            Ordinal Number Value
     */
    public void setSuplrEvalOrdinalNumber( @Nullable final Integer suplrEvalOrdinalNumber )
    {
        rememberChangedField("SuplrEvalOrdinalNumber", this.suplrEvalOrdinalNumber);
        this.suplrEvalOrdinalNumber = suplrEvalOrdinalNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalSccrdStrucQnaire";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalScorecardQnaireUUID", getSuplrEvalScorecardQnaireUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalScorecardQnaireUUID", getSuplrEvalScorecardQnaireUUID());
        values.put("QuestionnaireName", getQuestionnaireName());
        values.put("SupplierEvalScorecardQnaire", getSupplierEvalScorecardQnaire());
        values.put("SuplrEvalScorecardRtQnaireUUID", getSuplrEvalScorecardRtQnaireUUID());
        values.put("MinimalScore", getMinimalScore());
        values.put("TargetScore", getTargetScore());
        values.put("CalculatedScore", getCalculatedScore());
        values.put("NumberOfResponses", getNumberOfResponses());
        values.put("WeightingFactor", getWeightingFactor());
        values.put("SuplrEvalOrdinalNumber", getSuplrEvalOrdinalNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalScorecardQnaireUUID") ) {
                final Object value = values.remove("SuplrEvalScorecardQnaireUUID");
                if( (value == null) || (!value.equals(getSuplrEvalScorecardQnaireUUID())) ) {
                    setSuplrEvalScorecardQnaireUUID(((UUID) value));
                }
            }
            if( values.containsKey("QuestionnaireName") ) {
                final Object value = values.remove("QuestionnaireName");
                if( (value == null) || (!value.equals(getQuestionnaireName())) ) {
                    setQuestionnaireName(((String) value));
                }
            }
            if( values.containsKey("SupplierEvalScorecardQnaire") ) {
                final Object value = values.remove("SupplierEvalScorecardQnaire");
                if( (value == null) || (!value.equals(getSupplierEvalScorecardQnaire())) ) {
                    setSupplierEvalScorecardQnaire(((String) value));
                }
            }
            if( values.containsKey("SuplrEvalScorecardRtQnaireUUID") ) {
                final Object value = values.remove("SuplrEvalScorecardRtQnaireUUID");
                if( (value == null) || (!value.equals(getSuplrEvalScorecardRtQnaireUUID())) ) {
                    setSuplrEvalScorecardRtQnaireUUID(((UUID) value));
                }
            }
            if( values.containsKey("MinimalScore") ) {
                final Object value = values.remove("MinimalScore");
                if( (value == null) || (!value.equals(getMinimalScore())) ) {
                    setMinimalScore(((Short) value));
                }
            }
            if( values.containsKey("TargetScore") ) {
                final Object value = values.remove("TargetScore");
                if( (value == null) || (!value.equals(getTargetScore())) ) {
                    setTargetScore(((Short) value));
                }
            }
            if( values.containsKey("CalculatedScore") ) {
                final Object value = values.remove("CalculatedScore");
                if( (value == null) || (!value.equals(getCalculatedScore())) ) {
                    setCalculatedScore(((Double) value));
                }
            }
            if( values.containsKey("NumberOfResponses") ) {
                final Object value = values.remove("NumberOfResponses");
                if( (value == null) || (!value.equals(getNumberOfResponses())) ) {
                    setNumberOfResponses(((Integer) value));
                }
            }
            if( values.containsKey("WeightingFactor") ) {
                final Object value = values.remove("WeightingFactor");
                if( (value == null) || (!value.equals(getWeightingFactor())) ) {
                    setWeightingFactor(((Short) value));
                }
            }
            if( values.containsKey("SuplrEvalOrdinalNumber") ) {
                final Object value = values.remove("SuplrEvalOrdinalNumber");
                if( (value == null) || (!value.equals(getSuplrEvalOrdinalNumber())) ) {
                    setSuplrEvalOrdinalNumber(((Integer) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SuplrEvalSccrdSection") ) {
                final Object value = (values).remove("to_SuplrEvalSccrdSection");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalSccrdSection == null ) {
                        toSuplrEvalSccrdSection = Lists.newArrayList();
                    } else {
                        toSuplrEvalSccrdSection = Lists.newArrayList(toSuplrEvalSccrdSection);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalSccrdSection entity;
                        if( toSuplrEvalSccrdSection.size() > i ) {
                            entity = toSuplrEvalSccrdSection.get(i);
                        } else {
                            entity = new SuplrEvalSccrdSection();
                            toSuplrEvalSccrdSection.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SuplrEvalScorecardRootQnaire") ) {
                final Object value = (values).remove("to_SuplrEvalScorecardRootQnaire");
                if( value instanceof Map ) {
                    if( toSuplrEvalScorecardRootQnaire == null ) {
                        toSuplrEvalScorecardRootQnaire = new SuplrEvalScorecardRootQnaire();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrEvalScorecardRootQnaire.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalSccrdStrucQnaireField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalSccrdStrucQnaireField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalSccrdStrucQnaireField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalSccrdStrucQnaireField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScorecardService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSuplrEvalSccrdSection != null ) {
            (values).put("to_SuplrEvalSccrdSection", toSuplrEvalSccrdSection);
        }
        if( toSuplrEvalScorecardRootQnaire != null ) {
            (values).put("to_SuplrEvalScorecardRootQnaire", toSuplrEvalScorecardRootQnaire);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrEvalSccrdSection</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SuplrEvalSccrdSection</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalSccrdSection</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalSccrdSection> fetchSuplrEvalSccrdSection()
    {
        return fetchFieldAsList("to_SuplrEvalSccrdSection", SuplrEvalSccrdSection.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalSccrdSection</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalSccrdSection</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalSccrdSection</b> of a queried <b>SuplrEvalSccrdStrucQnaire</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalSccrdSection</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalSccrdSection> getSuplrEvalSccrdSectionOrFetch()
    {
        if( toSuplrEvalSccrdSection == null ) {
            toSuplrEvalSccrdSection = fetchSuplrEvalSccrdSection();
        }
        return toSuplrEvalSccrdSection;
    }

    /**
     * Retrieval of associated <b>SuplrEvalSccrdSection</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalSccrdSection</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalSccrdStrucQnaire</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalSccrdSection</b> is already loaded, the result
     *         will contain the <b>SuplrEvalSccrdSection</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalSccrdSection>> getSuplrEvalSccrdSectionIfPresent()
    {
        return Option.of(toSuplrEvalSccrdSection);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalSccrdSection</b> entities for the loaded navigation property
     * <b>to_SuplrEvalSccrdSection</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalSccrdSection</b> of a queried <b>SuplrEvalSccrdStrucQnaire</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalSccrdSection</b> entities.
     */
    public void setSuplrEvalSccrdSection( @Nonnull final List<SuplrEvalSccrdSection> value )
    {
        if( toSuplrEvalSccrdSection == null ) {
            toSuplrEvalSccrdSection = Lists.newArrayList();
        }
        toSuplrEvalSccrdSection.clear();
        toSuplrEvalSccrdSection.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalSccrdSection</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalSccrdSection</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalSccrdSection</b> of a queried <b>SuplrEvalSccrdStrucQnaire</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalSccrdSection</b> entities.
     */
    public void addSuplrEvalSccrdSection( SuplrEvalSccrdSection... entity )
    {
        if( toSuplrEvalSccrdSection == null ) {
            toSuplrEvalSccrdSection = Lists.newArrayList();
        }
        toSuplrEvalSccrdSection.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrEvalScorecardRootQnaire</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SuplrEvalScorecardRootQnaire</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrEvalScorecardRootQnaire</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalScorecardRootQnaire fetchSuplrEvalScorecardRootQnaire()
    {
        return fetchFieldAsSingle("to_SuplrEvalScorecardRootQnaire", SuplrEvalScorecardRootQnaire.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalScorecardRootQnaire</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalScorecardRootQnaire</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalScorecardRootQnaire</b> of a queried <b>SuplrEvalSccrdStrucQnaire</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalScorecardRootQnaire</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalScorecardRootQnaire getSuplrEvalScorecardRootQnaireOrFetch()
    {
        if( toSuplrEvalScorecardRootQnaire == null ) {
            toSuplrEvalScorecardRootQnaire = fetchSuplrEvalScorecardRootQnaire();
        }
        return toSuplrEvalScorecardRootQnaire;
    }

    /**
     * Retrieval of associated <b>SuplrEvalScorecardRootQnaire</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalScorecardRootQnaire</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalSccrdStrucQnaire</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalScorecardRootQnaire</b> is already loaded, the
     *         result will contain the <b>SuplrEvalScorecardRootQnaire</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrEvalScorecardRootQnaire> getSuplrEvalScorecardRootQnaireIfPresent()
    {
        return Option.of(toSuplrEvalScorecardRootQnaire);
    }

    /**
     * Overwrites the associated <b>SuplrEvalScorecardRootQnaire</b> entity for the loaded navigation property
     * <b>to_SuplrEvalScorecardRootQnaire</b>.
     *
     * @param value
     *            New <b>SuplrEvalScorecardRootQnaire</b> entity.
     */
    public void setSuplrEvalScorecardRootQnaire( final SuplrEvalScorecardRootQnaire value )
    {
        toSuplrEvalScorecardRootQnaire = value;
    }

    /**
     * Helper class to allow for fluent creation of SuplrEvalSccrdStrucQnaire instances.
     *
     */
    public final static class SuplrEvalSccrdStrucQnaireBuilder
    {

        private List<SuplrEvalSccrdSection> toSuplrEvalSccrdSection = Lists.newArrayList();
        private SuplrEvalScorecardRootQnaire toSuplrEvalScorecardRootQnaire;

        private SuplrEvalSccrdStrucQnaire.SuplrEvalSccrdStrucQnaireBuilder toSuplrEvalSccrdSection(
            final List<SuplrEvalSccrdSection> value )
        {
            toSuplrEvalSccrdSection.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalSccrdSection</b> for <b>SuplrEvalSccrdStrucQnaire</b> to multiple
         * <b>SuplrEvalSccrdSection</b>.
         *
         * @param value
         *            The SuplrEvalSccrdSections to build this SuplrEvalSccrdStrucQnaire with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalSccrdStrucQnaire.SuplrEvalSccrdStrucQnaireBuilder suplrEvalSccrdSection(
            SuplrEvalSccrdSection... value )
        {
            return toSuplrEvalSccrdSection(Lists.newArrayList(value));
        }

        private SuplrEvalSccrdStrucQnaire.SuplrEvalSccrdStrucQnaireBuilder toSuplrEvalScorecardRootQnaire(
            final SuplrEvalScorecardRootQnaire value )
        {
            toSuplrEvalScorecardRootQnaire = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalScorecardRootQnaire</b> for <b>SuplrEvalSccrdStrucQnaire</b> to single
         * <b>SuplrEvalScorecardRootQnaire</b>.
         *
         * @param value
         *            The SuplrEvalScorecardRootQnaire to build this SuplrEvalSccrdStrucQnaire with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalSccrdStrucQnaire.SuplrEvalSccrdStrucQnaireBuilder suplrEvalScorecardRootQnaire(
            final SuplrEvalScorecardRootQnaire value )
        {
            return toSuplrEvalScorecardRootQnaire(value);
        }

    }

}
