/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalSccrdSupplierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable.SuplrEvalSccrdSupplierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Supplier
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalSccrdSupplierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalSccrdSupplier extends VdmEntity<SuplrEvalSccrdSupplier>
{

    /**
     * Selector for all available fields of SuplrEvalSccrdSupplier.
     *
     */
    public final static SuplrEvalSccrdSupplierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardPtyUUID</b>
     * </p>
     *
     * @return Evaluation Response Party UUID
     */
    @Key
    @SerializedName( "SuplrEvalScorecardPtyUUID" )
    @JsonProperty( "SuplrEvalScorecardPtyUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalScorecardPtyUUID" )
    private UUID suplrEvalScorecardPtyUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalScorecardPtyUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdSupplierField<UUID> SUPLR_EVAL_SCORECARD_PTY_UUID =
        new SuplrEvalSccrdSupplierField<UUID>("SuplrEvalScorecardPtyUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardUUID</b>
     * </p>
     *
     * @return Evaluation Scorecard UUID
     */
    @SerializedName( "SuplrEvalScorecardUUID" )
    @JsonProperty( "SuplrEvalScorecardUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalScorecardUUID" )
    private UUID suplrEvalScorecardUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalScorecardUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdSupplierField<UUID> SUPLR_EVAL_SCORECARD_UUID =
        new SuplrEvalSccrdSupplierField<UUID>("SuplrEvalScorecardUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static SuplrEvalSccrdSupplierField<String> BUSINESS_PARTNER =
        new SuplrEvalSccrdSupplierField<String>("BusinessPartner");

    @Nonnull
    @Override
    public Class<SuplrEvalSccrdSupplier> getType()
    {
        return SuplrEvalSccrdSupplier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardPtyUUID</b>
     * </p>
     *
     * @param suplrEvalScorecardPtyUUID
     *            Evaluation Response Party UUID
     */
    public void setSuplrEvalScorecardPtyUUID( @Nullable final UUID suplrEvalScorecardPtyUUID )
    {
        rememberChangedField("SuplrEvalScorecardPtyUUID", this.suplrEvalScorecardPtyUUID);
        this.suplrEvalScorecardPtyUUID = suplrEvalScorecardPtyUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardUUID</b>
     * </p>
     *
     * @param suplrEvalScorecardUUID
     *            Evaluation Scorecard UUID
     */
    public void setSuplrEvalScorecardUUID( @Nullable final UUID suplrEvalScorecardUUID )
    {
        rememberChangedField("SuplrEvalScorecardUUID", this.suplrEvalScorecardUUID);
        this.suplrEvalScorecardUUID = suplrEvalScorecardUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalSccrdSupplier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalScorecardPtyUUID", getSuplrEvalScorecardPtyUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalScorecardPtyUUID", getSuplrEvalScorecardPtyUUID());
        values.put("SuplrEvalScorecardUUID", getSuplrEvalScorecardUUID());
        values.put("BusinessPartner", getBusinessPartner());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalScorecardPtyUUID") ) {
                final Object value = values.remove("SuplrEvalScorecardPtyUUID");
                if( (value == null) || (!value.equals(getSuplrEvalScorecardPtyUUID())) ) {
                    setSuplrEvalScorecardPtyUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalScorecardUUID") ) {
                final Object value = values.remove("SuplrEvalScorecardUUID");
                if( (value == null) || (!value.equals(getSuplrEvalScorecardUUID())) ) {
                    setSuplrEvalScorecardUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalSccrdSupplierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalSccrdSupplierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalSccrdSupplierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalSccrdSupplierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScorecardService.DEFAULT_SERVICE_PATH);
    }

}
