/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable.SuplrEvalSccrdSupplierSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier
 * SuplrEvalSccrdSupplier} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SuplrEvalSccrdSupplierByKeyFluentHelper
    extends
    FluentHelperByKey<SuplrEvalSccrdSupplierByKeyFluentHelper, SuplrEvalSccrdSupplier, SuplrEvalSccrdSupplierSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier
     * SuplrEvalSccrdSupplier} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SuplrEvalSccrdSupplier}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SuplrEvalSccrdSupplier}
     * @param suplrEvalScorecardPtyUUID
     *            Evaluation Response Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public SuplrEvalSccrdSupplierByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID suplrEvalScorecardPtyUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("SuplrEvalScorecardPtyUUID", suplrEvalScorecardPtyUUID);
    }

    @Override
    @Nonnull
    protected Class<SuplrEvalSccrdSupplier> getEntityClass()
    {
        return SuplrEvalSccrdSupplier.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
