/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalScorecardField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.link.SuplrEvalScorecardOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable.SuplrEvalScorecardSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Evaluation Scorecard
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalScorecardType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalScorecard extends VdmEntity<SuplrEvalScorecard>
{

    /**
     * Selector for all available fields of SuplrEvalScorecard.
     *
     */
    public final static SuplrEvalScorecardSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardUUID</b>
     * </p>
     *
     * @return Evaluation Scorecard UUID
     */
    @Key
    @SerializedName( "SuplrEvalScorecardUUID" )
    @JsonProperty( "SuplrEvalScorecardUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalScorecardUUID" )
    private UUID suplrEvalScorecardUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalScorecardUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardField<UUID> SUPLR_EVAL_SCORECARD_UUID =
        new SuplrEvalScorecardField<UUID>("SuplrEvalScorecardUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalScorecard</b>
     * </p>
     *
     * @return Evaluation Scorecard
     */
    @SerializedName( "SupplierEvalScorecard" )
    @JsonProperty( "SupplierEvalScorecard" )
    @Nullable
    @ODataField( odataName = "SupplierEvalScorecard" )
    private String supplierEvalScorecard;
    /**
     * Use with available fluent helpers to apply the <b>SupplierEvalScorecard</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardField<String> SUPPLIER_EVAL_SCORECARD =
        new SuplrEvalScorecardField<String>("SupplierEvalScorecard");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardName</b>
     * </p>
     *
     * @return Name of a Supplier Evaluation Scorecard
     */
    @SerializedName( "SuplrEvalScorecardName" )
    @JsonProperty( "SuplrEvalScorecardName" )
    @Nullable
    @ODataField( odataName = "SuplrEvalScorecardName" )
    private String suplrEvalScorecardName;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalScorecardName</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardField<String> SUPLR_EVAL_SCORECARD_NAME =
        new SuplrEvalScorecardField<String>("SuplrEvalScorecardName");
    /**
     * Navigation property <b>to_SuplrEvalSccrdPurchaserResp</b> for <b>SuplrEvalScorecard</b> to single
     * <b>SuplrEvalSccrdPurchaserResp</b>.
     *
     */
    @SerializedName( "to_SuplrEvalSccrdPurchaserResp" )
    @JsonProperty( "to_SuplrEvalSccrdPurchaserResp" )
    @ODataField( odataName = "to_SuplrEvalSccrdPurchaserResp" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrEvalSccrdPurchaserResp toSuplrEvalSccrdPurchaserResp;
    /**
     * Navigation property <b>to_SuplrEvalScorecardRootQnaire</b> for <b>SuplrEvalScorecard</b> to single
     * <b>SuplrEvalScorecardRootQnaire</b>.
     *
     */
    @SerializedName( "to_SuplrEvalScorecardRootQnaire" )
    @JsonProperty( "to_SuplrEvalScorecardRootQnaire" )
    @ODataField( odataName = "to_SuplrEvalScorecardRootQnaire" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrEvalScorecardRootQnaire toSuplrEvalScorecardRootQnaire;
    /**
     * Navigation property <b>to_Supplier</b> for <b>SuplrEvalScorecard</b> to single <b>SuplrEvalSccrdSupplier</b>.
     *
     */
    @SerializedName( "to_Supplier" )
    @JsonProperty( "to_Supplier" )
    @ODataField( odataName = "to_Supplier" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrEvalSccrdSupplier toSupplier;
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalSccrdPurchaserResp</b> navigation property to query
     * operations.
     *
     */
    public final static SuplrEvalScorecardOneToOneLink<SuplrEvalSccrdPurchaserResp> TO_SUPLR_EVAL_SCCRD_PURCHASER_RESP =
        new SuplrEvalScorecardOneToOneLink<SuplrEvalSccrdPurchaserResp>("to_SuplrEvalSccrdPurchaserResp");
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalScorecardRootQnaire</b> navigation property to
     * query operations.
     *
     */
    public final static SuplrEvalScorecardOneToOneLink<SuplrEvalScorecardRootQnaire> TO_SUPLR_EVAL_SCORECARD_ROOT_QNAIRE =
        new SuplrEvalScorecardOneToOneLink<SuplrEvalScorecardRootQnaire>("to_SuplrEvalScorecardRootQnaire");
    /**
     * Use with available fluent helpers to apply the <b>to_Supplier</b> navigation property to query operations.
     *
     */
    public final static SuplrEvalScorecardOneToOneLink<SuplrEvalSccrdSupplier> TO_SUPPLIER =
        new SuplrEvalScorecardOneToOneLink<SuplrEvalSccrdSupplier>("to_Supplier");

    @Nonnull
    @Override
    public Class<SuplrEvalScorecard> getType()
    {
        return SuplrEvalScorecard.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardUUID</b>
     * </p>
     *
     * @param suplrEvalScorecardUUID
     *            Evaluation Scorecard UUID
     */
    public void setSuplrEvalScorecardUUID( @Nullable final UUID suplrEvalScorecardUUID )
    {
        rememberChangedField("SuplrEvalScorecardUUID", this.suplrEvalScorecardUUID);
        this.suplrEvalScorecardUUID = suplrEvalScorecardUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierEvalScorecard</b>
     * </p>
     *
     * @param supplierEvalScorecard
     *            Evaluation Scorecard
     */
    public void setSupplierEvalScorecard( @Nullable final String supplierEvalScorecard )
    {
        rememberChangedField("SupplierEvalScorecard", this.supplierEvalScorecard);
        this.supplierEvalScorecard = supplierEvalScorecard;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardName</b>
     * </p>
     *
     * @param suplrEvalScorecardName
     *            Name of a Supplier Evaluation Scorecard
     */
    public void setSuplrEvalScorecardName( @Nullable final String suplrEvalScorecardName )
    {
        rememberChangedField("SuplrEvalScorecardName", this.suplrEvalScorecardName);
        this.suplrEvalScorecardName = suplrEvalScorecardName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalScorecard";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalScorecardUUID", getSuplrEvalScorecardUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalScorecardUUID", getSuplrEvalScorecardUUID());
        values.put("SupplierEvalScorecard", getSupplierEvalScorecard());
        values.put("SuplrEvalScorecardName", getSuplrEvalScorecardName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalScorecardUUID") ) {
                final Object value = values.remove("SuplrEvalScorecardUUID");
                if( (value == null) || (!value.equals(getSuplrEvalScorecardUUID())) ) {
                    setSuplrEvalScorecardUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplierEvalScorecard") ) {
                final Object value = values.remove("SupplierEvalScorecard");
                if( (value == null) || (!value.equals(getSupplierEvalScorecard())) ) {
                    setSupplierEvalScorecard(((String) value));
                }
            }
            if( values.containsKey("SuplrEvalScorecardName") ) {
                final Object value = values.remove("SuplrEvalScorecardName");
                if( (value == null) || (!value.equals(getSuplrEvalScorecardName())) ) {
                    setSuplrEvalScorecardName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SuplrEvalSccrdPurchaserResp") ) {
                final Object value = (values).remove("to_SuplrEvalSccrdPurchaserResp");
                if( value instanceof Map ) {
                    if( toSuplrEvalSccrdPurchaserResp == null ) {
                        toSuplrEvalSccrdPurchaserResp = new SuplrEvalSccrdPurchaserResp();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrEvalSccrdPurchaserResp.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SuplrEvalScorecardRootQnaire") ) {
                final Object value = (values).remove("to_SuplrEvalScorecardRootQnaire");
                if( value instanceof Map ) {
                    if( toSuplrEvalScorecardRootQnaire == null ) {
                        toSuplrEvalScorecardRootQnaire = new SuplrEvalScorecardRootQnaire();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSuplrEvalScorecardRootQnaire.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Supplier") ) {
                final Object value = (values).remove("to_Supplier");
                if( value instanceof Map ) {
                    if( toSupplier == null ) {
                        toSupplier = new SuplrEvalSccrdSupplier();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSupplier.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrEvalScorecardField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalScorecardField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalScorecardField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalScorecardField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScorecardService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSuplrEvalSccrdPurchaserResp != null ) {
            (values).put("to_SuplrEvalSccrdPurchaserResp", toSuplrEvalSccrdPurchaserResp);
        }
        if( toSuplrEvalScorecardRootQnaire != null ) {
            (values).put("to_SuplrEvalScorecardRootQnaire", toSuplrEvalScorecardRootQnaire);
        }
        if( toSupplier != null ) {
            (values).put("to_Supplier", toSupplier);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrEvalSccrdPurchaserResp</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SuplrEvalSccrdPurchaserResp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrEvalSccrdPurchaserResp</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalSccrdPurchaserResp fetchSuplrEvalSccrdPurchaserResp()
    {
        return fetchFieldAsSingle("to_SuplrEvalSccrdPurchaserResp", SuplrEvalSccrdPurchaserResp.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalSccrdPurchaserResp</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalSccrdPurchaserResp</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalSccrdPurchaserResp</b> of a queried <b>SuplrEvalScorecard</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalSccrdPurchaserResp</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalSccrdPurchaserResp getSuplrEvalSccrdPurchaserRespOrFetch()
    {
        if( toSuplrEvalSccrdPurchaserResp == null ) {
            toSuplrEvalSccrdPurchaserResp = fetchSuplrEvalSccrdPurchaserResp();
        }
        return toSuplrEvalSccrdPurchaserResp;
    }

    /**
     * Retrieval of associated <b>SuplrEvalSccrdPurchaserResp</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalSccrdPurchaserResp</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalScorecard</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalSccrdPurchaserResp</b> is already loaded, the
     *         result will contain the <b>SuplrEvalSccrdPurchaserResp</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrEvalSccrdPurchaserResp> getSuplrEvalSccrdPurchaserRespIfPresent()
    {
        return Option.of(toSuplrEvalSccrdPurchaserResp);
    }

    /**
     * Overwrites the associated <b>SuplrEvalSccrdPurchaserResp</b> entity for the loaded navigation property
     * <b>to_SuplrEvalSccrdPurchaserResp</b>.
     *
     * @param value
     *            New <b>SuplrEvalSccrdPurchaserResp</b> entity.
     */
    public void setSuplrEvalSccrdPurchaserResp( final SuplrEvalSccrdPurchaserResp value )
    {
        toSuplrEvalSccrdPurchaserResp = value;
    }

    /**
     * Fetches the <b>SuplrEvalScorecardRootQnaire</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SuplrEvalScorecardRootQnaire</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrEvalScorecardRootQnaire</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalScorecardRootQnaire fetchSuplrEvalScorecardRootQnaire()
    {
        return fetchFieldAsSingle("to_SuplrEvalScorecardRootQnaire", SuplrEvalScorecardRootQnaire.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalScorecardRootQnaire</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalScorecardRootQnaire</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalScorecardRootQnaire</b> of a queried <b>SuplrEvalScorecard</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalScorecardRootQnaire</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalScorecardRootQnaire getSuplrEvalScorecardRootQnaireOrFetch()
    {
        if( toSuplrEvalScorecardRootQnaire == null ) {
            toSuplrEvalScorecardRootQnaire = fetchSuplrEvalScorecardRootQnaire();
        }
        return toSuplrEvalScorecardRootQnaire;
    }

    /**
     * Retrieval of associated <b>SuplrEvalScorecardRootQnaire</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SuplrEvalScorecardRootQnaire</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalScorecard</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalScorecardRootQnaire</b> is already loaded, the
     *         result will contain the <b>SuplrEvalScorecardRootQnaire</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrEvalScorecardRootQnaire> getSuplrEvalScorecardRootQnaireIfPresent()
    {
        return Option.of(toSuplrEvalScorecardRootQnaire);
    }

    /**
     * Overwrites the associated <b>SuplrEvalScorecardRootQnaire</b> entity for the loaded navigation property
     * <b>to_SuplrEvalScorecardRootQnaire</b>.
     *
     * @param value
     *            New <b>SuplrEvalScorecardRootQnaire</b> entity.
     */
    public void setSuplrEvalScorecardRootQnaire( final SuplrEvalScorecardRootQnaire value )
    {
        toSuplrEvalScorecardRootQnaire = value;
    }

    /**
     * Fetches the <b>SuplrEvalSccrdSupplier</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Supplier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrEvalSccrdSupplier</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalSccrdSupplier fetchSupplier()
    {
        return fetchFieldAsSingle("to_Supplier", SuplrEvalSccrdSupplier.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalSccrdSupplier</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Supplier</b>.
     * <p>
     * If the navigation property <b>to_Supplier</b> of a queried <b>SuplrEvalScorecard</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalSccrdSupplier</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalSccrdSupplier getSupplierOrFetch()
    {
        if( toSupplier == null ) {
            toSupplier = fetchSupplier();
        }
        return toSupplier;
    }

    /**
     * Retrieval of associated <b>SuplrEvalSccrdSupplier</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Supplier</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalScorecard</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Supplier</b> is already loaded, the result will contain
     *         the <b>SuplrEvalSccrdSupplier</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrEvalSccrdSupplier> getSupplierIfPresent()
    {
        return Option.of(toSupplier);
    }

    /**
     * Overwrites the associated <b>SuplrEvalSccrdSupplier</b> entity for the loaded navigation property
     * <b>to_Supplier</b>.
     *
     * @param value
     *            New <b>SuplrEvalSccrdSupplier</b> entity.
     */
    public void setSupplier( final SuplrEvalSccrdSupplier value )
    {
        toSupplier = value;
    }

    /**
     * Helper class to allow for fluent creation of SuplrEvalScorecard instances.
     *
     */
    public final static class SuplrEvalScorecardBuilder
    {

        private SuplrEvalSccrdPurchaserResp toSuplrEvalSccrdPurchaserResp;
        private SuplrEvalScorecardRootQnaire toSuplrEvalScorecardRootQnaire;
        private SuplrEvalSccrdSupplier toSupplier;

        private SuplrEvalScorecard.SuplrEvalScorecardBuilder toSuplrEvalSccrdPurchaserResp(
            final SuplrEvalSccrdPurchaserResp value )
        {
            toSuplrEvalSccrdPurchaserResp = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalSccrdPurchaserResp</b> for <b>SuplrEvalScorecard</b> to single
         * <b>SuplrEvalSccrdPurchaserResp</b>.
         *
         * @param value
         *            The SuplrEvalSccrdPurchaserResp to build this SuplrEvalScorecard with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalScorecard.SuplrEvalScorecardBuilder suplrEvalSccrdPurchaserResp(
            final SuplrEvalSccrdPurchaserResp value )
        {
            return toSuplrEvalSccrdPurchaserResp(value);
        }

        private SuplrEvalScorecard.SuplrEvalScorecardBuilder toSuplrEvalScorecardRootQnaire(
            final SuplrEvalScorecardRootQnaire value )
        {
            toSuplrEvalScorecardRootQnaire = value;
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalScorecardRootQnaire</b> for <b>SuplrEvalScorecard</b> to single
         * <b>SuplrEvalScorecardRootQnaire</b>.
         *
         * @param value
         *            The SuplrEvalScorecardRootQnaire to build this SuplrEvalScorecard with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalScorecard.SuplrEvalScorecardBuilder suplrEvalScorecardRootQnaire(
            final SuplrEvalScorecardRootQnaire value )
        {
            return toSuplrEvalScorecardRootQnaire(value);
        }

        private SuplrEvalScorecard.SuplrEvalScorecardBuilder toSupplier( final SuplrEvalSccrdSupplier value )
        {
            toSupplier = value;
            return this;
        }

        /**
         * Navigation property <b>to_Supplier</b> for <b>SuplrEvalScorecard</b> to single <b>SuplrEvalSccrdSupplier</b>.
         *
         * @param value
         *            The SuplrEvalSccrdSupplier to build this SuplrEvalScorecard with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalScorecard.SuplrEvalScorecardBuilder supplier( final SuplrEvalSccrdSupplier value )
        {
            return toSupplier(value);
        }

    }

}
