/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalScorecardRootQnaireField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.link.SuplrEvalScorecardRootQnaireLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.link.SuplrEvalScorecardRootQnaireOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable.SuplrEvalScorecardRootQnaireSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Root Questionnaire
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrEvalScorecardRootQnaireType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrEvalScorecardRootQnaire extends VdmEntity<SuplrEvalScorecardRootQnaire>
{

    /**
     * Selector for all available fields of SuplrEvalScorecardRootQnaire.
     *
     */
    public final static SuplrEvalScorecardRootQnaireSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardQnaireUUID</b>
     * </p>
     *
     * @return Evaluation Scorecard Questionnaire UUID
     */
    @Key
    @SerializedName( "SuplrEvalScorecardQnaireUUID" )
    @JsonProperty( "SuplrEvalScorecardQnaireUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalScorecardQnaireUUID" )
    private UUID suplrEvalScorecardQnaireUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalScorecardQnaireUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardRootQnaireField<UUID> SUPLR_EVAL_SCORECARD_QNAIRE_UUID =
        new SuplrEvalScorecardRootQnaireField<UUID>("SuplrEvalScorecardQnaireUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardUUID</b>
     * </p>
     *
     * @return Evaluation Scorecard UUID
     */
    @SerializedName( "SuplrEvalScorecardUUID" )
    @JsonProperty( "SuplrEvalScorecardUUID" )
    @Nullable
    @ODataField( odataName = "SuplrEvalScorecardUUID" )
    private UUID suplrEvalScorecardUUID;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalScorecardUUID</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardRootQnaireField<UUID> SUPLR_EVAL_SCORECARD_UUID =
        new SuplrEvalScorecardRootQnaireField<UUID>("SuplrEvalScorecardUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @return Minimum Score Accepted
     */
    @SerializedName( "MinimalScore" )
    @JsonProperty( "MinimalScore" )
    @Nullable
    @ODataField( odataName = "MinimalScore" )
    private Short minimalScore;
    /**
     * Use with available fluent helpers to apply the <b>MinimalScore</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardRootQnaireField<Short> MINIMAL_SCORE =
        new SuplrEvalScorecardRootQnaireField<Short>("MinimalScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @return Target Score
     */
    @SerializedName( "TargetScore" )
    @JsonProperty( "TargetScore" )
    @Nullable
    @ODataField( odataName = "TargetScore" )
    private Short targetScore;
    /**
     * Use with available fluent helpers to apply the <b>TargetScore</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardRootQnaireField<Short> TARGET_SCORE =
        new SuplrEvalScorecardRootQnaireField<Short>("TargetScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedScore</b>
     * </p>
     *
     * @return Calculated Score
     */
    @SerializedName( "CalculatedScore" )
    @JsonProperty( "CalculatedScore" )
    @Nullable
    @ODataField( odataName = "CalculatedScore" )
    private Double calculatedScore;
    /**
     * Use with available fluent helpers to apply the <b>CalculatedScore</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardRootQnaireField<Double> CALCULATED_SCORE =
        new SuplrEvalScorecardRootQnaireField<Double>("CalculatedScore");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @return Number of Responses
     */
    @SerializedName( "NumberOfResponses" )
    @JsonProperty( "NumberOfResponses" )
    @Nullable
    @ODataField( odataName = "NumberOfResponses" )
    private Integer numberOfResponses;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfResponses</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardRootQnaireField<Integer> NUMBER_OF_RESPONSES =
        new SuplrEvalScorecardRootQnaireField<Integer>("NumberOfResponses");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @return Value of Weighting Factor
     */
    @SerializedName( "WeightingFactor" )
    @JsonProperty( "WeightingFactor" )
    @Nullable
    @ODataField( odataName = "WeightingFactor" )
    private Short weightingFactor;
    /**
     * Use with available fluent helpers to apply the <b>WeightingFactor</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardRootQnaireField<Short> WEIGHTING_FACTOR =
        new SuplrEvalScorecardRootQnaireField<Short>("WeightingFactor");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOrdinalNumber</b>
     * </p>
     *
     * @return Ordinal Number Value
     */
    @SerializedName( "SuplrEvalOrdinalNumber" )
    @JsonProperty( "SuplrEvalOrdinalNumber" )
    @Nullable
    @ODataField( odataName = "SuplrEvalOrdinalNumber" )
    private Integer suplrEvalOrdinalNumber;
    /**
     * Use with available fluent helpers to apply the <b>SuplrEvalOrdinalNumber</b> field to query operations.
     *
     */
    public final static SuplrEvalScorecardRootQnaireField<Integer> SUPLR_EVAL_ORDINAL_NUMBER =
        new SuplrEvalScorecardRootQnaireField<Integer>("SuplrEvalOrdinalNumber");
    /**
     * Navigation property <b>to_SuplrEvalSccrdStrucQnaire</b> for <b>SuplrEvalScorecardRootQnaire</b> to multiple
     * <b>SuplrEvalSccrdStrucQnaire</b>.
     *
     */
    @SerializedName( "to_SuplrEvalSccrdStrucQnaire" )
    @JsonProperty( "to_SuplrEvalSccrdStrucQnaire" )
    @ODataField( odataName = "to_SuplrEvalSccrdStrucQnaire" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrEvalSccrdStrucQnaire> toSuplrEvalSccrdStrucQnaire;
    /**
     * Navigation property <b>to_SupplierEvalScorecard</b> for <b>SuplrEvalScorecardRootQnaire</b> to single
     * <b>SuplrEvalScorecard</b>.
     *
     */
    @SerializedName( "to_SupplierEvalScorecard" )
    @JsonProperty( "to_SupplierEvalScorecard" )
    @ODataField( odataName = "to_SupplierEvalScorecard" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SuplrEvalScorecard toSupplierEvalScorecard;
    /**
     * Use with available fluent helpers to apply the <b>to_SuplrEvalSccrdStrucQnaire</b> navigation property to query
     * operations.
     *
     */
    public final static SuplrEvalScorecardRootQnaireLink<SuplrEvalSccrdStrucQnaire> TO_SUPLR_EVAL_SCCRD_STRUC_QNAIRE =
        new SuplrEvalScorecardRootQnaireLink<SuplrEvalSccrdStrucQnaire>("to_SuplrEvalSccrdStrucQnaire");
    /**
     * Use with available fluent helpers to apply the <b>to_SupplierEvalScorecard</b> navigation property to query
     * operations.
     *
     */
    public final static SuplrEvalScorecardRootQnaireOneToOneLink<SuplrEvalScorecard> TO_SUPPLIER_EVAL_SCORECARD =
        new SuplrEvalScorecardRootQnaireOneToOneLink<SuplrEvalScorecard>("to_SupplierEvalScorecard");

    @Nonnull
    @Override
    public Class<SuplrEvalScorecardRootQnaire> getType()
    {
        return SuplrEvalScorecardRootQnaire.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardQnaireUUID</b>
     * </p>
     *
     * @param suplrEvalScorecardQnaireUUID
     *            Evaluation Scorecard Questionnaire UUID
     */
    public void setSuplrEvalScorecardQnaireUUID( @Nullable final UUID suplrEvalScorecardQnaireUUID )
    {
        rememberChangedField("SuplrEvalScorecardQnaireUUID", this.suplrEvalScorecardQnaireUUID);
        this.suplrEvalScorecardQnaireUUID = suplrEvalScorecardQnaireUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalScorecardUUID</b>
     * </p>
     *
     * @param suplrEvalScorecardUUID
     *            Evaluation Scorecard UUID
     */
    public void setSuplrEvalScorecardUUID( @Nullable final UUID suplrEvalScorecardUUID )
    {
        rememberChangedField("SuplrEvalScorecardUUID", this.suplrEvalScorecardUUID);
        this.suplrEvalScorecardUUID = suplrEvalScorecardUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MinimalScore</b>
     * </p>
     *
     * @param minimalScore
     *            Minimum Score Accepted
     */
    public void setMinimalScore( @Nullable final Short minimalScore )
    {
        rememberChangedField("MinimalScore", this.minimalScore);
        this.minimalScore = minimalScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TargetScore</b>
     * </p>
     *
     * @param targetScore
     *            Target Score
     */
    public void setTargetScore( @Nullable final Short targetScore )
    {
        rememberChangedField("TargetScore", this.targetScore);
        this.targetScore = targetScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedScore</b>
     * </p>
     *
     * @param calculatedScore
     *            Calculated Score
     */
    public void setCalculatedScore( @Nullable final Double calculatedScore )
    {
        rememberChangedField("CalculatedScore", this.calculatedScore);
        this.calculatedScore = calculatedScore;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfResponses</b>
     * </p>
     *
     * @param numberOfResponses
     *            Number of Responses
     */
    public void setNumberOfResponses( @Nullable final Integer numberOfResponses )
    {
        rememberChangedField("NumberOfResponses", this.numberOfResponses);
        this.numberOfResponses = numberOfResponses;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WeightingFactor</b>
     * </p>
     *
     * @param weightingFactor
     *            Value of Weighting Factor
     */
    public void setWeightingFactor( @Nullable final Short weightingFactor )
    {
        rememberChangedField("WeightingFactor", this.weightingFactor);
        this.weightingFactor = weightingFactor;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrEvalOrdinalNumber</b>
     * </p>
     *
     * @param suplrEvalOrdinalNumber
     *            Ordinal Number Value
     */
    public void setSuplrEvalOrdinalNumber( @Nullable final Integer suplrEvalOrdinalNumber )
    {
        rememberChangedField("SuplrEvalOrdinalNumber", this.suplrEvalOrdinalNumber);
        this.suplrEvalOrdinalNumber = suplrEvalOrdinalNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrEvalScorecardRootQnaire";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SuplrEvalScorecardQnaireUUID", getSuplrEvalScorecardQnaireUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuplrEvalScorecardQnaireUUID", getSuplrEvalScorecardQnaireUUID());
        values.put("SuplrEvalScorecardUUID", getSuplrEvalScorecardUUID());
        values.put("MinimalScore", getMinimalScore());
        values.put("TargetScore", getTargetScore());
        values.put("CalculatedScore", getCalculatedScore());
        values.put("NumberOfResponses", getNumberOfResponses());
        values.put("WeightingFactor", getWeightingFactor());
        values.put("SuplrEvalOrdinalNumber", getSuplrEvalOrdinalNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuplrEvalScorecardQnaireUUID") ) {
                final Object value = values.remove("SuplrEvalScorecardQnaireUUID");
                if( (value == null) || (!value.equals(getSuplrEvalScorecardQnaireUUID())) ) {
                    setSuplrEvalScorecardQnaireUUID(((UUID) value));
                }
            }
            if( values.containsKey("SuplrEvalScorecardUUID") ) {
                final Object value = values.remove("SuplrEvalScorecardUUID");
                if( (value == null) || (!value.equals(getSuplrEvalScorecardUUID())) ) {
                    setSuplrEvalScorecardUUID(((UUID) value));
                }
            }
            if( values.containsKey("MinimalScore") ) {
                final Object value = values.remove("MinimalScore");
                if( (value == null) || (!value.equals(getMinimalScore())) ) {
                    setMinimalScore(((Short) value));
                }
            }
            if( values.containsKey("TargetScore") ) {
                final Object value = values.remove("TargetScore");
                if( (value == null) || (!value.equals(getTargetScore())) ) {
                    setTargetScore(((Short) value));
                }
            }
            if( values.containsKey("CalculatedScore") ) {
                final Object value = values.remove("CalculatedScore");
                if( (value == null) || (!value.equals(getCalculatedScore())) ) {
                    setCalculatedScore(((Double) value));
                }
            }
            if( values.containsKey("NumberOfResponses") ) {
                final Object value = values.remove("NumberOfResponses");
                if( (value == null) || (!value.equals(getNumberOfResponses())) ) {
                    setNumberOfResponses(((Integer) value));
                }
            }
            if( values.containsKey("WeightingFactor") ) {
                final Object value = values.remove("WeightingFactor");
                if( (value == null) || (!value.equals(getWeightingFactor())) ) {
                    setWeightingFactor(((Short) value));
                }
            }
            if( values.containsKey("SuplrEvalOrdinalNumber") ) {
                final Object value = values.remove("SuplrEvalOrdinalNumber");
                if( (value == null) || (!value.equals(getSuplrEvalOrdinalNumber())) ) {
                    setSuplrEvalOrdinalNumber(((Integer) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SuplrEvalSccrdStrucQnaire") ) {
                final Object value = (values).remove("to_SuplrEvalSccrdStrucQnaire");
                if( value instanceof Iterable ) {
                    if( toSuplrEvalSccrdStrucQnaire == null ) {
                        toSuplrEvalSccrdStrucQnaire = Lists.newArrayList();
                    } else {
                        toSuplrEvalSccrdStrucQnaire = Lists.newArrayList(toSuplrEvalSccrdStrucQnaire);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrEvalSccrdStrucQnaire entity;
                        if( toSuplrEvalSccrdStrucQnaire.size() > i ) {
                            entity = toSuplrEvalSccrdStrucQnaire.get(i);
                        } else {
                            entity = new SuplrEvalSccrdStrucQnaire();
                            toSuplrEvalSccrdStrucQnaire.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SupplierEvalScorecard") ) {
                final Object value = (values).remove("to_SupplierEvalScorecard");
                if( value instanceof Map ) {
                    if( toSupplierEvalScorecard == null ) {
                        toSupplierEvalScorecard = new SuplrEvalScorecard();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSupplierEvalScorecard.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SuplrEvalScorecardRootQnaireField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SuplrEvalScorecardRootQnaireField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrEvalScorecardRootQnaireField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrEvalScorecardRootQnaireField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScorecardService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSuplrEvalSccrdStrucQnaire != null ) {
            (values).put("to_SuplrEvalSccrdStrucQnaire", toSuplrEvalSccrdStrucQnaire);
        }
        if( toSupplierEvalScorecard != null ) {
            (values).put("to_SupplierEvalScorecard", toSupplierEvalScorecard);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrEvalSccrdStrucQnaire</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SuplrEvalSccrdStrucQnaire</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrEvalSccrdStrucQnaire</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalSccrdStrucQnaire> fetchSuplrEvalSccrdStrucQnaire()
    {
        return fetchFieldAsList("to_SuplrEvalSccrdStrucQnaire", SuplrEvalSccrdStrucQnaire.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalSccrdStrucQnaire</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalSccrdStrucQnaire</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalSccrdStrucQnaire</b> of a queried <b>SuplrEvalScorecardRootQnaire</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalSccrdStrucQnaire</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrEvalSccrdStrucQnaire> getSuplrEvalSccrdStrucQnaireOrFetch()
    {
        if( toSuplrEvalSccrdStrucQnaire == null ) {
            toSuplrEvalSccrdStrucQnaire = fetchSuplrEvalSccrdStrucQnaire();
        }
        return toSuplrEvalSccrdStrucQnaire;
    }

    /**
     * Retrieval of associated <b>SuplrEvalSccrdStrucQnaire</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SuplrEvalSccrdStrucQnaire</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalScorecardRootQnaire</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SuplrEvalSccrdStrucQnaire</b> is already loaded, the
     *         result will contain the <b>SuplrEvalSccrdStrucQnaire</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrEvalSccrdStrucQnaire>> getSuplrEvalSccrdStrucQnaireIfPresent()
    {
        return Option.of(toSuplrEvalSccrdStrucQnaire);
    }

    /**
     * Overwrites the list of associated <b>SuplrEvalSccrdStrucQnaire</b> entities for the loaded navigation property
     * <b>to_SuplrEvalSccrdStrucQnaire</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalSccrdStrucQnaire</b> of a queried <b>SuplrEvalScorecardRootQnaire</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrEvalSccrdStrucQnaire</b> entities.
     */
    public void setSuplrEvalSccrdStrucQnaire( @Nonnull final List<SuplrEvalSccrdStrucQnaire> value )
    {
        if( toSuplrEvalSccrdStrucQnaire == null ) {
            toSuplrEvalSccrdStrucQnaire = Lists.newArrayList();
        }
        toSuplrEvalSccrdStrucQnaire.clear();
        toSuplrEvalSccrdStrucQnaire.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrEvalSccrdStrucQnaire</b> entities. This corresponds to the OData
     * navigation property <b>to_SuplrEvalSccrdStrucQnaire</b>.
     * <p>
     * If the navigation property <b>to_SuplrEvalSccrdStrucQnaire</b> of a queried <b>SuplrEvalScorecardRootQnaire</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrEvalSccrdStrucQnaire</b> entities.
     */
    public void addSuplrEvalSccrdStrucQnaire( SuplrEvalSccrdStrucQnaire... entity )
    {
        if( toSuplrEvalSccrdStrucQnaire == null ) {
            toSuplrEvalSccrdStrucQnaire = Lists.newArrayList();
        }
        toSuplrEvalSccrdStrucQnaire.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SuplrEvalScorecard</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SupplierEvalScorecard</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SuplrEvalScorecard</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalScorecard fetchSupplierEvalScorecard()
    {
        return fetchFieldAsSingle("to_SupplierEvalScorecard", SuplrEvalScorecard.class);
    }

    /**
     * Retrieval of associated <b>SuplrEvalScorecard</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SupplierEvalScorecard</b>.
     * <p>
     * If the navigation property <b>to_SupplierEvalScorecard</b> of a queried <b>SuplrEvalScorecardRootQnaire</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrEvalScorecard</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SuplrEvalScorecard getSupplierEvalScorecardOrFetch()
    {
        if( toSupplierEvalScorecard == null ) {
            toSupplierEvalScorecard = fetchSupplierEvalScorecard();
        }
        return toSupplierEvalScorecard;
    }

    /**
     * Retrieval of associated <b>SuplrEvalScorecard</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SupplierEvalScorecard</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrEvalScorecardRootQnaire</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SupplierEvalScorecard</b> is already loaded, the result
     *         will contain the <b>SuplrEvalScorecard</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SuplrEvalScorecard> getSupplierEvalScorecardIfPresent()
    {
        return Option.of(toSupplierEvalScorecard);
    }

    /**
     * Overwrites the associated <b>SuplrEvalScorecard</b> entity for the loaded navigation property
     * <b>to_SupplierEvalScorecard</b>.
     *
     * @param value
     *            New <b>SuplrEvalScorecard</b> entity.
     */
    public void setSupplierEvalScorecard( final SuplrEvalScorecard value )
    {
        toSupplierEvalScorecard = value;
    }

    /**
     * Helper class to allow for fluent creation of SuplrEvalScorecardRootQnaire instances.
     *
     */
    public final static class SuplrEvalScorecardRootQnaireBuilder
    {

        private List<SuplrEvalSccrdStrucQnaire> toSuplrEvalSccrdStrucQnaire = Lists.newArrayList();
        private SuplrEvalScorecard toSupplierEvalScorecard;

        private SuplrEvalScorecardRootQnaire.SuplrEvalScorecardRootQnaireBuilder toSuplrEvalSccrdStrucQnaire(
            final List<SuplrEvalSccrdStrucQnaire> value )
        {
            toSuplrEvalSccrdStrucQnaire.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SuplrEvalSccrdStrucQnaire</b> for <b>SuplrEvalScorecardRootQnaire</b> to multiple
         * <b>SuplrEvalSccrdStrucQnaire</b>.
         *
         * @param value
         *            The SuplrEvalSccrdStrucQnaires to build this SuplrEvalScorecardRootQnaire with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalScorecardRootQnaire.SuplrEvalScorecardRootQnaireBuilder suplrEvalSccrdStrucQnaire(
            SuplrEvalSccrdStrucQnaire... value )
        {
            return toSuplrEvalSccrdStrucQnaire(Lists.newArrayList(value));
        }

        private SuplrEvalScorecardRootQnaire.SuplrEvalScorecardRootQnaireBuilder toSupplierEvalScorecard(
            final SuplrEvalScorecard value )
        {
            toSupplierEvalScorecard = value;
            return this;
        }

        /**
         * Navigation property <b>to_SupplierEvalScorecard</b> for <b>SuplrEvalScorecardRootQnaire</b> to single
         * <b>SuplrEvalScorecard</b>.
         *
         * @param value
         *            The SuplrEvalScorecard to build this SuplrEvalScorecardRootQnaire with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrEvalScorecardRootQnaire.SuplrEvalScorecardRootQnaireBuilder supplierEvalScorecard(
            final SuplrEvalScorecard value )
        {
            return toSupplierEvalScorecard(value);
        }

    }

}
