/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link SupplierEvaluationScorecardServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScorecardService
 * SupplierEvaluationScorecardService}.
 *
 */
public class DefaultSupplierEvaluationScorecardServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SupplierEvaluationScorecardServiceBatch, SupplierEvaluationScorecardServiceBatchChangeSet>
    implements
    SupplierEvaluationScorecardServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScorecardService service;

    @SuppressWarnings( "deprecation" )
    DefaultSupplierEvaluationScorecardServiceBatchChangeSet(
        @Nonnull final DefaultSupplierEvaluationScorecardServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierEvaluationScorecardService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSupplierEvaluationScorecardServiceBatchChangeSet getThis()
    {
        return this;
    }

}
