/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp
 * SuplrEvalSccrdPurchaserResp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalSccrdPurchaserRespField
 * SuplrEvalSccrdPurchaserRespField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.link.SuplrEvalSccrdPurchaserRespLink
 * SuplrEvalSccrdPurchaserRespLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp#SUPLR_EVAL_SCORECARD_PTY_UUID
 * SUPLR_EVAL_SCORECARD_PTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp#SUPLR_EVAL_SCORECARD_UUID
 * SUPLR_EVAL_SCORECARD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp#USER_ID
 * USER_ID}</li>
 * </ul>
 *
 */
public interface SuplrEvalSccrdPurchaserRespSelectable extends EntitySelectable<SuplrEvalSccrdPurchaserResp>
{

}
