/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire
 * SuplrEvalSccrdStrucQnaire}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalSccrdStrucQnaireField
 * SuplrEvalSccrdStrucQnaireField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.link.SuplrEvalSccrdStrucQnaireLink
 * SuplrEvalSccrdStrucQnaireLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#SUPLR_EVAL_SCORECARD_QNAIRE_UUID
 * SUPLR_EVAL_SCORECARD_QNAIRE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#QUESTIONNAIRE_NAME
 * QUESTIONNAIRE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#SUPPLIER_EVAL_SCORECARD_QNAIRE
 * SUPPLIER_EVAL_SCORECARD_QNAIRE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#SUPLR_EVAL_SCORECARD_RT_QNAIRE_UUID
 * SUPLR_EVAL_SCORECARD_RT_QNAIRE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#MINIMAL_SCORE
 * MINIMAL_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#TARGET_SCORE
 * TARGET_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#CALCULATED_SCORE
 * CALCULATED_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#NUMBER_OF_RESPONSES
 * NUMBER_OF_RESPONSES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#WEIGHTING_FACTOR
 * WEIGHTING_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#SUPLR_EVAL_ORDINAL_NUMBER
 * SUPLR_EVAL_ORDINAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#TO_SUPLR_EVAL_SCCRD_SECTION
 * TO_SUPLR_EVAL_SCCRD_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire#TO_SUPLR_EVAL_SCORECARD_ROOT_QNAIRE
 * TO_SUPLR_EVAL_SCORECARD_ROOT_QNAIRE}</li>
 * </ul>
 *
 */
public interface SuplrEvalSccrdStrucQnaireSelectable extends EntitySelectable<SuplrEvalSccrdStrucQnaire>
{

}
