/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier
 * SuplrEvalSccrdSupplier}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalSccrdSupplierField
 * SuplrEvalSccrdSupplierField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.link.SuplrEvalSccrdSupplierLink
 * SuplrEvalSccrdSupplierLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier#SUPLR_EVAL_SCORECARD_PTY_UUID
 * SUPLR_EVAL_SCORECARD_PTY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier#SUPLR_EVAL_SCORECARD_UUID
 * SUPLR_EVAL_SCORECARD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * </ul>
 *
 */
public interface SuplrEvalSccrdSupplierSelectable extends EntitySelectable<SuplrEvalSccrdSupplier>
{

}
