/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire
 * SuplrEvalScorecardRootQnaire}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalScorecardRootQnaireField
 * SuplrEvalScorecardRootQnaireField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.link.SuplrEvalScorecardRootQnaireLink
 * SuplrEvalScorecardRootQnaireLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire#SUPLR_EVAL_SCORECARD_QNAIRE_UUID
 * SUPLR_EVAL_SCORECARD_QNAIRE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire#SUPLR_EVAL_SCORECARD_UUID
 * SUPLR_EVAL_SCORECARD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire#MINIMAL_SCORE
 * MINIMAL_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire#TARGET_SCORE
 * TARGET_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire#CALCULATED_SCORE
 * CALCULATED_SCORE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire#NUMBER_OF_RESPONSES
 * NUMBER_OF_RESPONSES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire#WEIGHTING_FACTOR
 * WEIGHTING_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire#SUPLR_EVAL_ORDINAL_NUMBER
 * SUPLR_EVAL_ORDINAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire#TO_SUPLR_EVAL_SCCRD_STRUC_QNAIRE
 * TO_SUPLR_EVAL_SCCRD_STRUC_QNAIRE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire#TO_SUPPLIER_EVAL_SCORECARD
 * TO_SUPPLIER_EVAL_SCORECARD}</li>
 * </ul>
 *
 */
public interface SuplrEvalScorecardRootQnaireSelectable extends EntitySelectable<SuplrEvalScorecardRootQnaire>
{

}
