/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard
 * SuplrEvalScorecard}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.field.SuplrEvalScorecardField
 * SuplrEvalScorecardField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.link.SuplrEvalScorecardLink
 * SuplrEvalScorecardLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard#SUPLR_EVAL_SCORECARD_UUID
 * SUPLR_EVAL_SCORECARD_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard#SUPPLIER_EVAL_SCORECARD
 * SUPPLIER_EVAL_SCORECARD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard#SUPLR_EVAL_SCORECARD_NAME
 * SUPLR_EVAL_SCORECARD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard#TO_SUPLR_EVAL_SCCRD_PURCHASER_RESP
 * TO_SUPLR_EVAL_SCCRD_PURCHASER_RESP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard#TO_SUPLR_EVAL_SCORECARD_ROOT_QNAIRE
 * TO_SUPLR_EVAL_SCORECARD_ROOT_QNAIRE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard#TO_SUPPLIER
 * TO_SUPPLIER}</li>
 * </ul>
 *
 */
public interface SuplrEvalScorecardSelectable extends EntitySelectable<SuplrEvalScorecard>
{

}
