/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>CancelInvoiceExportParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CancelInvoiceExportParameters extends VdmComplex<CancelInvoiceExportParameters>
{

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @param reverseDocument
     *
     * @return Reversed with
     */
    @SerializedName( "ReverseDocument" )
    @JsonProperty( "ReverseDocument" )
    @Nullable
    @ODataField( odataName = "ReverseDocument" )
    private String reverseDocument;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Success</b>
     * </p>
     *
     * @param success
     *
     * @return TRUE
     */
    @SerializedName( "Success" )
    @JsonProperty( "Success" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Success" )
    private Boolean success;

    @Nonnull
    @Override
    public Class<CancelInvoiceExportParameters> getType()
    {
        return CancelInvoiceExportParameters.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ReverseDocument", getReverseDocument());
        values.put("FiscalYear", getFiscalYear());
        values.put("Success", getSuccess());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ReverseDocument") ) {
                final Object value = values.remove("ReverseDocument");
                if( (value == null) || (!value.equals(getReverseDocument())) ) {
                    setReverseDocument(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("Success") ) {
                final Object value = values.remove("Success");
                if( (value == null) || (!value.equals(getSuccess())) ) {
                    setSuccess(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @param reverseDocument
     *            Reversed with
     */
    public void setReverseDocument( @Nullable final String reverseDocument )
    {
        rememberChangedField("ReverseDocument", this.reverseDocument);
        this.reverseDocument = reverseDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Success</b>
     * </p>
     *
     * @param success
     *            TRUE
     */
    public void setSuccess( @Nullable final Boolean success )
    {
        rememberChangedField("Success", this.success);
        this.success = success;
    }

}
