/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvcHeaderWhldgTaxField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SuplrInvcHeaderWhldgTaxSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Withholding Tax Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrInvcHeaderWhldgTaxType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrInvcHeaderWhldgTax extends VdmEntity<SuplrInvcHeaderWhldgTax>
{

    /**
     * Selector for all available fields of SuplrInvcHeaderWhldgTax.
     *
     */
    public final static SuplrInvcHeaderWhldgTaxSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @return Document Number of an Invoice Document
     */
    @Key
    @SerializedName( "SupplierInvoice" )
    @JsonProperty( "SupplierInvoice" )
    @Nullable
    @ODataField( odataName = "SupplierInvoice" )
    private String supplierInvoice;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoice</b> field to query operations.
     *
     */
    public final static SuplrInvcHeaderWhldgTaxField<String> SUPPLIER_INVOICE =
        new SuplrInvcHeaderWhldgTaxField<String>("SupplierInvoice");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static SuplrInvcHeaderWhldgTaxField<String> FISCAL_YEAR =
        new SuplrInvcHeaderWhldgTaxField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxType</b>
     * </p>
     *
     * @return Indicator for Withholding Tax Type
     */
    @Key
    @SerializedName( "WithholdingTaxType" )
    @JsonProperty( "WithholdingTaxType" )
    @Nullable
    @ODataField( odataName = "WithholdingTaxType" )
    private String withholdingTaxType;
    /**
     * Use with available fluent helpers to apply the <b>WithholdingTaxType</b> field to query operations.
     *
     */
    public final static SuplrInvcHeaderWhldgTaxField<String> WITHHOLDING_TAX_TYPE =
        new SuplrInvcHeaderWhldgTaxField<String>("WithholdingTaxType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static SuplrInvcHeaderWhldgTaxField<String> DOCUMENT_CURRENCY =
        new SuplrInvcHeaderWhldgTaxField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     *
     * @return Withholding tax code
     */
    @SerializedName( "WithholdingTaxCode" )
    @JsonProperty( "WithholdingTaxCode" )
    @Nullable
    @ODataField( odataName = "WithholdingTaxCode" )
    private String withholdingTaxCode;
    /**
     * Use with available fluent helpers to apply the <b>WithholdingTaxCode</b> field to query operations.
     *
     */
    public final static SuplrInvcHeaderWhldgTaxField<String> WITHHOLDING_TAX_CODE =
        new SuplrInvcHeaderWhldgTaxField<String>("WithholdingTaxCode");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxBaseAmount</b>
     * </p>
     *
     * @return Withholding Tax Base Amount in Document Currency
     */
    @SerializedName( "WithholdingTaxBaseAmount" )
    @JsonProperty( "WithholdingTaxBaseAmount" )
    @Nullable
    @ODataField( odataName = "WithholdingTaxBaseAmount" )
    private BigDecimal withholdingTaxBaseAmount;
    /**
     * Use with available fluent helpers to apply the <b>WithholdingTaxBaseAmount</b> field to query operations.
     *
     */
    public final static SuplrInvcHeaderWhldgTaxField<BigDecimal> WITHHOLDING_TAX_BASE_AMOUNT =
        new SuplrInvcHeaderWhldgTaxField<BigDecimal>("WithholdingTaxBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ManuallyEnteredWhldgTaxAmount</b>
     * </p>
     *
     * @return Withholding Tax Amount Entered Manually in Document Currency
     */
    @SerializedName( "ManuallyEnteredWhldgTaxAmount" )
    @JsonProperty( "ManuallyEnteredWhldgTaxAmount" )
    @Nullable
    @ODataField( odataName = "ManuallyEnteredWhldgTaxAmount" )
    private BigDecimal manuallyEnteredWhldgTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>ManuallyEnteredWhldgTaxAmount</b> field to query operations.
     *
     */
    public final static SuplrInvcHeaderWhldgTaxField<BigDecimal> MANUALLY_ENTERED_WHLDG_TAX_AMOUNT =
        new SuplrInvcHeaderWhldgTaxField<BigDecimal>("ManuallyEnteredWhldgTaxAmount");

    @Nonnull
    @Override
    public Class<SuplrInvcHeaderWhldgTax> getType()
    {
        return SuplrInvcHeaderWhldgTax.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @param supplierInvoice
     *            Document Number of an Invoice Document
     */
    public void setSupplierInvoice( @Nullable final String supplierInvoice )
    {
        rememberChangedField("SupplierInvoice", this.supplierInvoice);
        this.supplierInvoice = supplierInvoice;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxType</b>
     * </p>
     *
     * @param withholdingTaxType
     *            Indicator for Withholding Tax Type
     */
    public void setWithholdingTaxType( @Nullable final String withholdingTaxType )
    {
        rememberChangedField("WithholdingTaxType", this.withholdingTaxType);
        this.withholdingTaxType = withholdingTaxType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     *
     * @param withholdingTaxCode
     *            Withholding tax code
     */
    public void setWithholdingTaxCode( @Nullable final String withholdingTaxCode )
    {
        rememberChangedField("WithholdingTaxCode", this.withholdingTaxCode);
        this.withholdingTaxCode = withholdingTaxCode;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxBaseAmount</b>
     * </p>
     *
     * @param withholdingTaxBaseAmount
     *            Withholding Tax Base Amount in Document Currency
     */
    public void setWithholdingTaxBaseAmount( @Nullable final BigDecimal withholdingTaxBaseAmount )
    {
        rememberChangedField("WithholdingTaxBaseAmount", this.withholdingTaxBaseAmount);
        this.withholdingTaxBaseAmount = withholdingTaxBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ManuallyEnteredWhldgTaxAmount</b>
     * </p>
     *
     * @param manuallyEnteredWhldgTaxAmount
     *            Withholding Tax Amount Entered Manually in Document Currency
     */
    public void setManuallyEnteredWhldgTaxAmount( @Nullable final BigDecimal manuallyEnteredWhldgTaxAmount )
    {
        rememberChangedField("ManuallyEnteredWhldgTaxAmount", this.manuallyEnteredWhldgTaxAmount);
        this.manuallyEnteredWhldgTaxAmount = manuallyEnteredWhldgTaxAmount;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrInvcHeaderWhldgTax";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SupplierInvoice", getSupplierInvoice());
        result.put("FiscalYear", getFiscalYear());
        result.put("WithholdingTaxType", getWithholdingTaxType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierInvoice", getSupplierInvoice());
        values.put("FiscalYear", getFiscalYear());
        values.put("WithholdingTaxType", getWithholdingTaxType());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("WithholdingTaxCode", getWithholdingTaxCode());
        values.put("WithholdingTaxBaseAmount", getWithholdingTaxBaseAmount());
        values.put("ManuallyEnteredWhldgTaxAmount", getManuallyEnteredWhldgTaxAmount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierInvoice") ) {
                final Object value = values.remove("SupplierInvoice");
                if( (value == null) || (!value.equals(getSupplierInvoice())) ) {
                    setSupplierInvoice(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("WithholdingTaxType") ) {
                final Object value = values.remove("WithholdingTaxType");
                if( (value == null) || (!value.equals(getWithholdingTaxType())) ) {
                    setWithholdingTaxType(((String) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("WithholdingTaxCode") ) {
                final Object value = values.remove("WithholdingTaxCode");
                if( (value == null) || (!value.equals(getWithholdingTaxCode())) ) {
                    setWithholdingTaxCode(((String) value));
                }
            }
            if( values.containsKey("WithholdingTaxBaseAmount") ) {
                final Object value = values.remove("WithholdingTaxBaseAmount");
                if( (value == null) || (!value.equals(getWithholdingTaxBaseAmount())) ) {
                    setWithholdingTaxBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ManuallyEnteredWhldgTaxAmount") ) {
                final Object value = values.remove("ManuallyEnteredWhldgTaxAmount");
                if( (value == null) || (!value.equals(getManuallyEnteredWhldgTaxAmount())) ) {
                    setManuallyEnteredWhldgTaxAmount(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrInvcHeaderWhldgTaxField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrInvcHeaderWhldgTaxField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrInvcHeaderWhldgTaxField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrInvcHeaderWhldgTaxField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService.DEFAULT_SERVICE_PATH);
    }

}
