/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SuplrInvcHeaderWhldgTaxSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTax
 * SuplrInvcHeaderWhldgTax} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SuplrInvcHeaderWhldgTaxByKeyFluentHelper
    extends
    FluentHelperByKey<SuplrInvcHeaderWhldgTaxByKeyFluentHelper, SuplrInvcHeaderWhldgTax, SuplrInvcHeaderWhldgTaxSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTax
     * SuplrInvcHeaderWhldgTax} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SuplrInvcHeaderWhldgTax}
     * @param withholdingTaxType
     *            Indicator for Withholding Tax Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SuplrInvcHeaderWhldgTax}
     * @param supplierInvoice
     *            Document Number of an Invoice Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public SuplrInvcHeaderWhldgTaxByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String supplierInvoice,
        final String fiscalYear,
        final String withholdingTaxType )
    {
        super(servicePath, entityCollection);
        this.key.put("SupplierInvoice", supplierInvoice);
        this.key.put("FiscalYear", fiscalYear);
        this.key.put("WithholdingTaxType", withholdingTaxType);
    }

    @Override
    @Nonnull
    protected Class<SuplrInvcHeaderWhldgTax> getEntityClass()
    {
        return SuplrInvcHeaderWhldgTax.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
