/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvcItemAcctAssgmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SuplrInvcItemAcctAssgmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Account Assignment Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrInvcItemAcctAssgmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrInvcItemAcctAssgmt extends VdmEntity<SuplrInvcItemAcctAssgmt>
{

    /**
     * Selector for all available fields of SuplrInvcItemAcctAssgmt.
     *
     */
    public final static SuplrInvcItemAcctAssgmtSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @return Document Number of an Accounting Document
     */
    @Key
    @SerializedName( "SupplierInvoice" )
    @JsonProperty( "SupplierInvoice" )
    @Nullable
    @ODataField( odataName = "SupplierInvoice" )
    private String supplierInvoice;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoice</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> SUPPLIER_INVOICE =
        new SuplrInvcItemAcctAssgmtField<String>("SupplierInvoice");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> FISCAL_YEAR =
        new SuplrInvcItemAcctAssgmtField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItem</b>
     * </p>
     *
     * @return Document Item in Invoice Document
     */
    @Key
    @SerializedName( "SupplierInvoiceItem" )
    @JsonProperty( "SupplierInvoiceItem" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceItem" )
    private String supplierInvoiceItem;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceItem</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> SUPPLIER_INVOICE_ITEM =
        new SuplrInvcItemAcctAssgmtField<String>("SupplierInvoiceItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrdinalNumber</b>
     * </p>
     *
     * @return Four Character Sequential Number for Coding Block
     */
    @Key
    @SerializedName( "OrdinalNumber" )
    @JsonProperty( "OrdinalNumber" )
    @Nullable
    @ODataField( odataName = "OrdinalNumber" )
    private String ordinalNumber;
    /**
     * Use with available fluent helpers to apply the <b>OrdinalNumber</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> ORDINAL_NUMBER =
        new SuplrInvcItemAcctAssgmtField<String>("OrdinalNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> COST_CENTER =
        new SuplrInvcItemAcctAssgmtField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> CONTROLLING_AREA =
        new SuplrInvcItemAcctAssgmtField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> BUSINESS_AREA =
        new SuplrInvcItemAcctAssgmtField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PROFIT_CENTER =
        new SuplrInvcItemAcctAssgmtField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> FUNCTIONAL_AREA =
        new SuplrInvcItemAcctAssgmtField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> GL_ACCOUNT =
        new SuplrInvcItemAcctAssgmtField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> SALES_ORDER =
        new SuplrInvcItemAcctAssgmtField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales document item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> SALES_ORDER_ITEM =
        new SuplrInvcItemAcctAssgmtField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> COST_OBJECT =
        new SuplrInvcItemAcctAssgmtField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> COST_CTR_ACTIVITY_TYPE =
        new SuplrInvcItemAcctAssgmtField<String>("CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> BUSINESS_PROCESS =
        new SuplrInvcItemAcctAssgmtField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> WBS_ELEMENT =
        new SuplrInvcItemAcctAssgmtField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> DOCUMENT_CURRENCY =
        new SuplrInvcItemAcctAssgmtField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcAcctAssignmentAmount</b>
     * </p>
     *
     * @return Amount in Document Currency
     */
    @SerializedName( "SuplrInvcAcctAssignmentAmount" )
    @JsonProperty( "SuplrInvcAcctAssignmentAmount" )
    @Nullable
    @ODataField( odataName = "SuplrInvcAcctAssignmentAmount" )
    private BigDecimal suplrInvcAcctAssignmentAmount;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcAcctAssignmentAmount</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<BigDecimal> SUPLR_INVC_ACCT_ASSIGNMENT_AMOUNT =
        new SuplrInvcItemAcctAssgmtField<BigDecimal>("SuplrInvcAcctAssignmentAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurchaseOrderQuantityUnit" )
    @JsonProperty( "PurchaseOrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQuantityUnit" )
    private String purchaseOrderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PURCHASE_ORDER_QUANTITY_UNIT =
        new SuplrInvcItemAcctAssgmtField<String>("PurchaseOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQtyUnitSAPCode</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurchaseOrderQtyUnitSAPCode" )
    @JsonProperty( "PurchaseOrderQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQtyUnitSAPCode" )
    private String purchaseOrderQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PURCHASE_ORDER_QTY_UNIT_SAP_CODE =
        new SuplrInvcItemAcctAssgmtField<String>("PurchaseOrderQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "PurchaseOrderQtyUnitISOCode" )
    @JsonProperty( "PurchaseOrderQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQtyUnitISOCode" )
    private String purchaseOrderQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PURCHASE_ORDER_QTY_UNIT_ISO_CODE =
        new SuplrInvcItemAcctAssgmtField<String>("PurchaseOrderQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<BigDecimal> QUANTITY =
        new SuplrInvcItemAcctAssgmtField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> TAX_CODE =
        new SuplrInvcItemAcctAssgmtField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @return Sequential Number of Account Assignment
     */
    @SerializedName( "AccountAssignmentNumber" )
    @JsonProperty( "AccountAssignmentNumber" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentNumber" )
    private String accountAssignmentNumber;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentNumber</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> ACCOUNT_ASSIGNMENT_NUMBER =
        new SuplrInvcItemAcctAssgmtField<String>("AccountAssignmentNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentIsUnplanned</b>
     * </p>
     *
     * @return Unplanned Account Assignment from Invoice Verification
     */
    @SerializedName( "AccountAssignmentIsUnplanned" )
    @JsonProperty( "AccountAssignmentIsUnplanned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AccountAssignmentIsUnplanned" )
    private Boolean accountAssignmentIsUnplanned;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentIsUnplanned</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<Boolean> ACCOUNT_ASSIGNMENT_IS_UNPLANNED =
        new SuplrInvcItemAcctAssgmtField<Boolean>("AccountAssignmentIsUnplanned");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonnelNumber" )
    @JsonProperty( "PersonnelNumber" )
    @Nullable
    @ODataField( odataName = "PersonnelNumber" )
    private String personnelNumber;
    /**
     * Use with available fluent helpers to apply the <b>PersonnelNumber</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PERSONNEL_NUMBER =
        new SuplrInvcItemAcctAssgmtField<String>("PersonnelNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @return Work Item ID
     */
    @SerializedName( "WorkItem" )
    @JsonProperty( "WorkItem" )
    @Nullable
    @ODataField( odataName = "WorkItem" )
    private String workItem;
    /**
     * Use with available fluent helpers to apply the <b>WorkItem</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> WORK_ITEM =
        new SuplrInvcItemAcctAssgmtField<String>("WorkItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Main Asset Number
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> MASTER_FIXED_ASSET =
        new SuplrInvcItemAcctAssgmtField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> FIXED_ASSET =
        new SuplrInvcItemAcctAssgmtField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Indicator
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> DEBIT_CREDIT_CODE =
        new SuplrInvcItemAcctAssgmtField<String>("DebitCreditCode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> TAX_JURISDICTION =
        new SuplrInvcItemAcctAssgmtField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "InternalOrder" )
    @JsonProperty( "InternalOrder" )
    @Nullable
    @ODataField( odataName = "InternalOrder" )
    private String internalOrder;
    /**
     * Use with available fluent helpers to apply the <b>InternalOrder</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> INTERNAL_ORDER =
        new SuplrInvcItemAcctAssgmtField<String>("InternalOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetworkInternalID</b>
     * </p>
     *
     * @return Routing number of operations in the order
     */
    @SerializedName( "ProjectNetworkInternalID" )
    @JsonProperty( "ProjectNetworkInternalID" )
    @Nullable
    @ODataField( odataName = "ProjectNetworkInternalID" )
    private String projectNetworkInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetworkInternalID</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PROJECT_NETWORK_INTERNAL_ID =
        new SuplrInvcItemAcctAssgmtField<String>("ProjectNetworkInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivityInternalID</b>
     * </p>
     *
     * @return Routing number of operations in the order
     */
    @SerializedName( "NetworkActivityInternalID" )
    @JsonProperty( "NetworkActivityInternalID" )
    @Nullable
    @ODataField( odataName = "NetworkActivityInternalID" )
    private String networkActivityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>NetworkActivityInternalID</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> NETWORK_ACTIVITY_INTERNAL_ID =
        new SuplrInvcItemAcctAssgmtField<String>("NetworkActivityInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PROJECT_NETWORK =
        new SuplrInvcItemAcctAssgmtField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivity</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @SerializedName( "NetworkActivity" )
    @JsonProperty( "NetworkActivity" )
    @Nullable
    @ODataField( odataName = "NetworkActivity" )
    private String networkActivity;
    /**
     * Use with available fluent helpers to apply the <b>NetworkActivity</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> NETWORK_ACTIVITY =
        new SuplrInvcItemAcctAssgmtField<String>("NetworkActivity");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @return Commitment Item
     */
    @SerializedName( "CommitmentItem" )
    @JsonProperty( "CommitmentItem" )
    @Nullable
    @ODataField( odataName = "CommitmentItem" )
    private String commitmentItem;
    /**
     * Use with available fluent helpers to apply the <b>CommitmentItem</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> COMMITMENT_ITEM =
        new SuplrInvcItemAcctAssgmtField<String>("CommitmentItem");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @return Funds Center
     */
    @SerializedName( "FundsCenter" )
    @JsonProperty( "FundsCenter" )
    @Nullable
    @ODataField( odataName = "FundsCenter" )
    private String fundsCenter;
    /**
     * Use with available fluent helpers to apply the <b>FundsCenter</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> FUNDS_CENTER =
        new SuplrInvcItemAcctAssgmtField<String>("FundsCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> FUND = new SuplrInvcItemAcctAssgmtField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> GRANT_ID =
        new SuplrInvcItemAcctAssgmtField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @return Trading partner's business area
     */
    @SerializedName( "PartnerBusinessArea" )
    @JsonProperty( "PartnerBusinessArea" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessArea" )
    private String partnerBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessArea</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PARTNER_BUSINESS_AREA =
        new SuplrInvcItemAcctAssgmtField<String>("PartnerBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> COMPANY_CODE =
        new SuplrInvcItemAcctAssgmtField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcAccountAssignmentText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "SuplrInvcAccountAssignmentText" )
    @JsonProperty( "SuplrInvcAccountAssignmentText" )
    @Nullable
    @ODataField( odataName = "SuplrInvcAccountAssignmentText" )
    private String suplrInvcAccountAssignmentText;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcAccountAssignmentText</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> SUPLR_INVC_ACCOUNT_ASSIGNMENT_TEXT =
        new SuplrInvcItemAcctAssgmtField<String>("SuplrInvcAccountAssignmentText");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnit</b>
     * </p>
     *
     * @return Order Price Unit (Purchasing)
     */
    @SerializedName( "PurchaseOrderPriceUnit" )
    @JsonProperty( "PurchaseOrderPriceUnit" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderPriceUnit" )
    private String purchaseOrderPriceUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderPriceUnit</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PURCHASE_ORDER_PRICE_UNIT =
        new SuplrInvcItemAcctAssgmtField<String>("PurchaseOrderPriceUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnitSAPCode</b>
     * </p>
     *
     * @return Order Price Unit (Purchasing)
     */
    @SerializedName( "PurchaseOrderPriceUnitSAPCode" )
    @JsonProperty( "PurchaseOrderPriceUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderPriceUnitSAPCode" )
    private String purchaseOrderPriceUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderPriceUnitSAPCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PURCHASE_ORDER_PRICE_UNIT_SAP_CODE =
        new SuplrInvcItemAcctAssgmtField<String>("PurchaseOrderPriceUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "PurchaseOrderPriceUnitISOCode" )
    @JsonProperty( "PurchaseOrderPriceUnitISOCode" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderPriceUnitISOCode" )
    private String purchaseOrderPriceUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderPriceUnitISOCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PURCHASE_ORDER_PRICE_UNIT_ISO_CODE =
        new SuplrInvcItemAcctAssgmtField<String>("PurchaseOrderPriceUnitISOCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInPurchaseOrderUnit</b>
     * </p>
     *
     * @return Quantity in Purchase Order Price Unit
     */
    @SerializedName( "QuantityInPurchaseOrderUnit" )
    @JsonProperty( "QuantityInPurchaseOrderUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInPurchaseOrderUnit" )
    private BigDecimal quantityInPurchaseOrderUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInPurchaseOrderUnit</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<BigDecimal> QUANTITY_IN_PURCHASE_ORDER_UNIT =
        new SuplrInvcItemAcctAssgmtField<BigDecimal>("QuantityInPurchaseOrderUnit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @return Profitability Segment Number (CO-PA)
     */
    @SerializedName( "ProfitabilitySegment" )
    @JsonProperty( "ProfitabilitySegment" )
    @Nullable
    @ODataField( odataName = "ProfitabilitySegment" )
    private String profitabilitySegment;
    /**
     * Use with available fluent helpers to apply the <b>ProfitabilitySegment</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> PROFITABILITY_SEGMENT =
        new SuplrInvcItemAcctAssgmtField<String>("ProfitabilitySegment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> BUDGET_PERIOD =
        new SuplrInvcItemAcctAssgmtField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @return Tax Reporting Country/Region
     */
    @SerializedName( "TaxCountry" )
    @JsonProperty( "TaxCountry" )
    @Nullable
    @ODataField( odataName = "TaxCountry" )
    private String taxCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxCountry</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<String> TAX_COUNTRY =
        new SuplrInvcItemAcctAssgmtField<String>("TaxCountry");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @return Date for Determining Tax Rates
     */
    @SerializedName( "TaxDeterminationDate" )
    @JsonProperty( "TaxDeterminationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TaxDeterminationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime taxDeterminationDate;
    /**
     * Use with available fluent helpers to apply the <b>TaxDeterminationDate</b> field to query operations.
     *
     */
    public final static SuplrInvcItemAcctAssgmtField<LocalDateTime> TAX_DETERMINATION_DATE =
        new SuplrInvcItemAcctAssgmtField<LocalDateTime>("TaxDeterminationDate");

    @Nonnull
    @Override
    public Class<SuplrInvcItemAcctAssgmt> getType()
    {
        return SuplrInvcItemAcctAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     */
    public void setSupplierInvoice( @Nullable final String supplierInvoice )
    {
        rememberChangedField("SupplierInvoice", this.supplierInvoice);
        this.supplierInvoice = supplierInvoice;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItem</b>
     * </p>
     *
     * @param supplierInvoiceItem
     *            Document Item in Invoice Document
     */
    public void setSupplierInvoiceItem( @Nullable final String supplierInvoiceItem )
    {
        rememberChangedField("SupplierInvoiceItem", this.supplierInvoiceItem);
        this.supplierInvoiceItem = supplierInvoiceItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrdinalNumber</b>
     * </p>
     *
     * @param ordinalNumber
     *            Four Character Sequential Number for Coding Block
     */
    public void setOrdinalNumber( @Nullable final String ordinalNumber )
    {
        rememberChangedField("OrdinalNumber", this.ordinalNumber);
        this.ordinalNumber = ordinalNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales and Distribution Document Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales document item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcAcctAssignmentAmount</b>
     * </p>
     *
     * @param suplrInvcAcctAssignmentAmount
     *            Amount in Document Currency
     */
    public void setSuplrInvcAcctAssignmentAmount( @Nullable final BigDecimal suplrInvcAcctAssignmentAmount )
    {
        rememberChangedField("SuplrInvcAcctAssignmentAmount", this.suplrInvcAcctAssignmentAmount);
        this.suplrInvcAcctAssignmentAmount = suplrInvcAcctAssignmentAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @param purchaseOrderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setPurchaseOrderQuantityUnit( @Nullable final String purchaseOrderQuantityUnit )
    {
        rememberChangedField("PurchaseOrderQuantityUnit", this.purchaseOrderQuantityUnit);
        this.purchaseOrderQuantityUnit = purchaseOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQtyUnitSAPCode</b>
     * </p>
     *
     * @param purchaseOrderQtyUnitSAPCode
     *            Purchase Order Unit of Measure
     */
    public void setPurchaseOrderQtyUnitSAPCode( @Nullable final String purchaseOrderQtyUnitSAPCode )
    {
        rememberChangedField("PurchaseOrderQtyUnitSAPCode", this.purchaseOrderQtyUnitSAPCode);
        this.purchaseOrderQtyUnitSAPCode = purchaseOrderQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQtyUnitISOCode</b>
     * </p>
     *
     * @param purchaseOrderQtyUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setPurchaseOrderQtyUnitISOCode( @Nullable final String purchaseOrderQtyUnitISOCode )
    {
        rememberChangedField("PurchaseOrderQtyUnitISOCode", this.purchaseOrderQtyUnitISOCode);
        this.purchaseOrderQtyUnitISOCode = purchaseOrderQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @param accountAssignmentNumber
     *            Sequential Number of Account Assignment
     */
    public void setAccountAssignmentNumber( @Nullable final String accountAssignmentNumber )
    {
        rememberChangedField("AccountAssignmentNumber", this.accountAssignmentNumber);
        this.accountAssignmentNumber = accountAssignmentNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentIsUnplanned</b>
     * </p>
     *
     * @param accountAssignmentIsUnplanned
     *            Unplanned Account Assignment from Invoice Verification
     */
    public void setAccountAssignmentIsUnplanned( @Nullable final Boolean accountAssignmentIsUnplanned )
    {
        rememberChangedField("AccountAssignmentIsUnplanned", this.accountAssignmentIsUnplanned);
        this.accountAssignmentIsUnplanned = accountAssignmentIsUnplanned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @param personnelNumber
     *            Personnel Number
     */
    public void setPersonnelNumber( @Nullable final String personnelNumber )
    {
        rememberChangedField("PersonnelNumber", this.personnelNumber);
        this.personnelNumber = personnelNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @param workItem
     *            Work Item ID
     */
    public void setWorkItem( @Nullable final String workItem )
    {
        rememberChangedField("WorkItem", this.workItem);
        this.workItem = workItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Main Asset Number
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Indicator
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InternalOrder</b>
     * </p>
     *
     * @param internalOrder
     *            Order Number
     */
    public void setInternalOrder( @Nullable final String internalOrder )
    {
        rememberChangedField("InternalOrder", this.internalOrder);
        this.internalOrder = internalOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetworkInternalID</b>
     * </p>
     *
     * @param projectNetworkInternalID
     *            Routing number of operations in the order
     */
    public void setProjectNetworkInternalID( @Nullable final String projectNetworkInternalID )
    {
        rememberChangedField("ProjectNetworkInternalID", this.projectNetworkInternalID);
        this.projectNetworkInternalID = projectNetworkInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivityInternalID</b>
     * </p>
     *
     * @param networkActivityInternalID
     *            Routing number of operations in the order
     */
    public void setNetworkActivityInternalID( @Nullable final String networkActivityInternalID )
    {
        rememberChangedField("NetworkActivityInternalID", this.networkActivityInternalID);
        this.networkActivityInternalID = networkActivityInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network Number for Account Assignment
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivity</b>
     * </p>
     *
     * @param networkActivity
     *            Operation/Activity Number
     */
    public void setNetworkActivity( @Nullable final String networkActivity )
    {
        rememberChangedField("NetworkActivity", this.networkActivity);
        this.networkActivity = networkActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @param commitmentItem
     *            Commitment Item
     */
    public void setCommitmentItem( @Nullable final String commitmentItem )
    {
        rememberChangedField("CommitmentItem", this.commitmentItem);
        this.commitmentItem = commitmentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @param fundsCenter
     *            Funds Center
     */
    public void setFundsCenter( @Nullable final String fundsCenter )
    {
        rememberChangedField("FundsCenter", this.fundsCenter);
        this.fundsCenter = fundsCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @param partnerBusinessArea
     *            Trading partner's business area
     */
    public void setPartnerBusinessArea( @Nullable final String partnerBusinessArea )
    {
        rememberChangedField("PartnerBusinessArea", this.partnerBusinessArea);
        this.partnerBusinessArea = partnerBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcAccountAssignmentText</b>
     * </p>
     *
     * @param suplrInvcAccountAssignmentText
     *            Item Text
     */
    public void setSuplrInvcAccountAssignmentText( @Nullable final String suplrInvcAccountAssignmentText )
    {
        rememberChangedField("SuplrInvcAccountAssignmentText", this.suplrInvcAccountAssignmentText);
        this.suplrInvcAccountAssignmentText = suplrInvcAccountAssignmentText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnit</b>
     * </p>
     *
     * @param purchaseOrderPriceUnit
     *            Order Price Unit (Purchasing)
     */
    public void setPurchaseOrderPriceUnit( @Nullable final String purchaseOrderPriceUnit )
    {
        rememberChangedField("PurchaseOrderPriceUnit", this.purchaseOrderPriceUnit);
        this.purchaseOrderPriceUnit = purchaseOrderPriceUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnitSAPCode</b>
     * </p>
     *
     * @param purchaseOrderPriceUnitSAPCode
     *            Order Price Unit (Purchasing)
     */
    public void setPurchaseOrderPriceUnitSAPCode( @Nullable final String purchaseOrderPriceUnitSAPCode )
    {
        rememberChangedField("PurchaseOrderPriceUnitSAPCode", this.purchaseOrderPriceUnitSAPCode);
        this.purchaseOrderPriceUnitSAPCode = purchaseOrderPriceUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnitISOCode</b>
     * </p>
     *
     * @param purchaseOrderPriceUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setPurchaseOrderPriceUnitISOCode( @Nullable final String purchaseOrderPriceUnitISOCode )
    {
        rememberChangedField("PurchaseOrderPriceUnitISOCode", this.purchaseOrderPriceUnitISOCode);
        this.purchaseOrderPriceUnitISOCode = purchaseOrderPriceUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInPurchaseOrderUnit</b>
     * </p>
     *
     * @param quantityInPurchaseOrderUnit
     *            Quantity in Purchase Order Price Unit
     */
    public void setQuantityInPurchaseOrderUnit( @Nullable final BigDecimal quantityInPurchaseOrderUnit )
    {
        rememberChangedField("QuantityInPurchaseOrderUnit", this.quantityInPurchaseOrderUnit);
        this.quantityInPurchaseOrderUnit = quantityInPurchaseOrderUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @param profitabilitySegment
     *            Profitability Segment Number (CO-PA)
     */
    public void setProfitabilitySegment( @Nullable final String profitabilitySegment )
    {
        rememberChangedField("ProfitabilitySegment", this.profitabilitySegment);
        this.profitabilitySegment = profitabilitySegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @param taxCountry
     *            Tax Reporting Country/Region
     */
    public void setTaxCountry( @Nullable final String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @param taxDeterminationDate
     *            Date for Determining Tax Rates
     */
    public void setTaxDeterminationDate( @Nullable final LocalDateTime taxDeterminationDate )
    {
        rememberChangedField("TaxDeterminationDate", this.taxDeterminationDate);
        this.taxDeterminationDate = taxDeterminationDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrInvcItemAcctAssgmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SupplierInvoice", getSupplierInvoice());
        result.put("FiscalYear", getFiscalYear());
        result.put("SupplierInvoiceItem", getSupplierInvoiceItem());
        result.put("OrdinalNumber", getOrdinalNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierInvoice", getSupplierInvoice());
        values.put("FiscalYear", getFiscalYear());
        values.put("SupplierInvoiceItem", getSupplierInvoiceItem());
        values.put("OrdinalNumber", getOrdinalNumber());
        values.put("CostCenter", getCostCenter());
        values.put("ControllingArea", getControllingArea());
        values.put("BusinessArea", getBusinessArea());
        values.put("ProfitCenter", getProfitCenter());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("GLAccount", getGLAccount());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("CostObject", getCostObject());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("WBSElement", getWBSElement());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("SuplrInvcAcctAssignmentAmount", getSuplrInvcAcctAssignmentAmount());
        values.put("PurchaseOrderQuantityUnit", getPurchaseOrderQuantityUnit());
        values.put("PurchaseOrderQtyUnitSAPCode", getPurchaseOrderQtyUnitSAPCode());
        values.put("PurchaseOrderQtyUnitISOCode", getPurchaseOrderQtyUnitISOCode());
        values.put("Quantity", getQuantity());
        values.put("TaxCode", getTaxCode());
        values.put("AccountAssignmentNumber", getAccountAssignmentNumber());
        values.put("AccountAssignmentIsUnplanned", getAccountAssignmentIsUnplanned());
        values.put("PersonnelNumber", getPersonnelNumber());
        values.put("WorkItem", getWorkItem());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("FixedAsset", getFixedAsset());
        values.put("DebitCreditCode", getDebitCreditCode());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("InternalOrder", getInternalOrder());
        values.put("ProjectNetworkInternalID", getProjectNetworkInternalID());
        values.put("NetworkActivityInternalID", getNetworkActivityInternalID());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("NetworkActivity", getNetworkActivity());
        values.put("CommitmentItem", getCommitmentItem());
        values.put("FundsCenter", getFundsCenter());
        values.put("Fund", getFund());
        values.put("GrantID", getGrantID());
        values.put("PartnerBusinessArea", getPartnerBusinessArea());
        values.put("CompanyCode", getCompanyCode());
        values.put("SuplrInvcAccountAssignmentText", getSuplrInvcAccountAssignmentText());
        values.put("PurchaseOrderPriceUnit", getPurchaseOrderPriceUnit());
        values.put("PurchaseOrderPriceUnitSAPCode", getPurchaseOrderPriceUnitSAPCode());
        values.put("PurchaseOrderPriceUnitISOCode", getPurchaseOrderPriceUnitISOCode());
        values.put("QuantityInPurchaseOrderUnit", getQuantityInPurchaseOrderUnit());
        values.put("ProfitabilitySegment", getProfitabilitySegment());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("TaxCountry", getTaxCountry());
        values.put("TaxDeterminationDate", getTaxDeterminationDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierInvoice") ) {
                final Object value = values.remove("SupplierInvoice");
                if( (value == null) || (!value.equals(getSupplierInvoice())) ) {
                    setSupplierInvoice(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("SupplierInvoiceItem") ) {
                final Object value = values.remove("SupplierInvoiceItem");
                if( (value == null) || (!value.equals(getSupplierInvoiceItem())) ) {
                    setSupplierInvoiceItem(((String) value));
                }
            }
            if( values.containsKey("OrdinalNumber") ) {
                final Object value = values.remove("OrdinalNumber");
                if( (value == null) || (!value.equals(getOrdinalNumber())) ) {
                    setOrdinalNumber(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("SuplrInvcAcctAssignmentAmount") ) {
                final Object value = values.remove("SuplrInvcAcctAssignmentAmount");
                if( (value == null) || (!value.equals(getSuplrInvcAcctAssignmentAmount())) ) {
                    setSuplrInvcAcctAssignmentAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseOrderQuantityUnit") ) {
                final Object value = values.remove("PurchaseOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurchaseOrderQuantityUnit())) ) {
                    setPurchaseOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderQtyUnitSAPCode") ) {
                final Object value = values.remove("PurchaseOrderQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getPurchaseOrderQtyUnitSAPCode())) ) {
                    setPurchaseOrderQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderQtyUnitISOCode") ) {
                final Object value = values.remove("PurchaseOrderQtyUnitISOCode");
                if( (value == null) || (!value.equals(getPurchaseOrderQtyUnitISOCode())) ) {
                    setPurchaseOrderQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentNumber") ) {
                final Object value = values.remove("AccountAssignmentNumber");
                if( (value == null) || (!value.equals(getAccountAssignmentNumber())) ) {
                    setAccountAssignmentNumber(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentIsUnplanned") ) {
                final Object value = values.remove("AccountAssignmentIsUnplanned");
                if( (value == null) || (!value.equals(getAccountAssignmentIsUnplanned())) ) {
                    setAccountAssignmentIsUnplanned(((Boolean) value));
                }
            }
            if( values.containsKey("PersonnelNumber") ) {
                final Object value = values.remove("PersonnelNumber");
                if( (value == null) || (!value.equals(getPersonnelNumber())) ) {
                    setPersonnelNumber(((String) value));
                }
            }
            if( values.containsKey("WorkItem") ) {
                final Object value = values.remove("WorkItem");
                if( (value == null) || (!value.equals(getWorkItem())) ) {
                    setWorkItem(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("InternalOrder") ) {
                final Object value = values.remove("InternalOrder");
                if( (value == null) || (!value.equals(getInternalOrder())) ) {
                    setInternalOrder(((String) value));
                }
            }
            if( values.containsKey("ProjectNetworkInternalID") ) {
                final Object value = values.remove("ProjectNetworkInternalID");
                if( (value == null) || (!value.equals(getProjectNetworkInternalID())) ) {
                    setProjectNetworkInternalID(((String) value));
                }
            }
            if( values.containsKey("NetworkActivityInternalID") ) {
                final Object value = values.remove("NetworkActivityInternalID");
                if( (value == null) || (!value.equals(getNetworkActivityInternalID())) ) {
                    setNetworkActivityInternalID(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("NetworkActivity") ) {
                final Object value = values.remove("NetworkActivity");
                if( (value == null) || (!value.equals(getNetworkActivity())) ) {
                    setNetworkActivity(((String) value));
                }
            }
            if( values.containsKey("CommitmentItem") ) {
                final Object value = values.remove("CommitmentItem");
                if( (value == null) || (!value.equals(getCommitmentItem())) ) {
                    setCommitmentItem(((String) value));
                }
            }
            if( values.containsKey("FundsCenter") ) {
                final Object value = values.remove("FundsCenter");
                if( (value == null) || (!value.equals(getFundsCenter())) ) {
                    setFundsCenter(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessArea") ) {
                final Object value = values.remove("PartnerBusinessArea");
                if( (value == null) || (!value.equals(getPartnerBusinessArea())) ) {
                    setPartnerBusinessArea(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("SuplrInvcAccountAssignmentText") ) {
                final Object value = values.remove("SuplrInvcAccountAssignmentText");
                if( (value == null) || (!value.equals(getSuplrInvcAccountAssignmentText())) ) {
                    setSuplrInvcAccountAssignmentText(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderPriceUnit") ) {
                final Object value = values.remove("PurchaseOrderPriceUnit");
                if( (value == null) || (!value.equals(getPurchaseOrderPriceUnit())) ) {
                    setPurchaseOrderPriceUnit(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderPriceUnitSAPCode") ) {
                final Object value = values.remove("PurchaseOrderPriceUnitSAPCode");
                if( (value == null) || (!value.equals(getPurchaseOrderPriceUnitSAPCode())) ) {
                    setPurchaseOrderPriceUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderPriceUnitISOCode") ) {
                final Object value = values.remove("PurchaseOrderPriceUnitISOCode");
                if( (value == null) || (!value.equals(getPurchaseOrderPriceUnitISOCode())) ) {
                    setPurchaseOrderPriceUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("QuantityInPurchaseOrderUnit") ) {
                final Object value = values.remove("QuantityInPurchaseOrderUnit");
                if( (value == null) || (!value.equals(getQuantityInPurchaseOrderUnit())) ) {
                    setQuantityInPurchaseOrderUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProfitabilitySegment") ) {
                final Object value = values.remove("ProfitabilitySegment");
                if( (value == null) || (!value.equals(getProfitabilitySegment())) ) {
                    setProfitabilitySegment(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((String) value));
                }
            }
            if( values.containsKey("TaxDeterminationDate") ) {
                final Object value = values.remove("TaxDeterminationDate");
                if( (value == null) || (!value.equals(getTaxDeterminationDate())) ) {
                    setTaxDeterminationDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrInvcItemAcctAssgmtField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrInvcItemAcctAssgmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrInvcItemAcctAssgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrInvcItemAcctAssgmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService.DEFAULT_SERVICE_PATH);
    }

}
