/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SuplrInvcItemAcctAssgmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt
 * SuplrInvcItemAcctAssgmt} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SuplrInvcItemAcctAssgmtByKeyFluentHelper
    extends
    FluentHelperByKey<SuplrInvcItemAcctAssgmtByKeyFluentHelper, SuplrInvcItemAcctAssgmt, SuplrInvcItemAcctAssgmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt
     * SuplrInvcItemAcctAssgmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SuplrInvcItemAcctAssgmt}
     * @param ordinalNumber
     *            Four Character Sequential Number for Coding Block
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param supplierInvoiceItem
     *            Document Item in Invoice Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SuplrInvcItemAcctAssgmt}
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public SuplrInvcItemAcctAssgmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String supplierInvoice,
        final String fiscalYear,
        final String supplierInvoiceItem,
        final String ordinalNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("SupplierInvoice", supplierInvoice);
        this.key.put("FiscalYear", fiscalYear);
        this.key.put("SupplierInvoiceItem", supplierInvoiceItem);
        this.key.put("OrdinalNumber", ordinalNumber);
    }

    @Override
    @Nonnull
    protected Class<SuplrInvcItemAcctAssgmt> getEntityClass()
    {
        return SuplrInvcItemAcctAssgmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
