/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvcItemPurOrdRefField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.link.SuplrInvcItemPurOrdRefLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SuplrInvcItemPurOrdRefSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item with Purchase Order Reference
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrInvcItemPurOrdRefType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrInvcItemPurOrdRef extends VdmEntity<SuplrInvcItemPurOrdRef>
{

    /**
     * Selector for all available fields of SuplrInvcItemPurOrdRef.
     *
     */
    public final static SuplrInvcItemPurOrdRefSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @return Document Number of an Accounting Document
     */
    @Key
    @SerializedName( "SupplierInvoice" )
    @JsonProperty( "SupplierInvoice" )
    @Nullable
    @ODataField( odataName = "SupplierInvoice" )
    private String supplierInvoice;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoice</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> SUPPLIER_INVOICE =
        new SuplrInvcItemPurOrdRefField<String>("SupplierInvoice");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> FISCAL_YEAR =
        new SuplrInvcItemPurOrdRefField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItem</b>
     * </p>
     *
     * @return Document Item in Invoice Document
     */
    @Key
    @SerializedName( "SupplierInvoiceItem" )
    @JsonProperty( "SupplierInvoiceItem" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceItem" )
    private String supplierInvoiceItem;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceItem</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> SUPPLIER_INVOICE_ITEM =
        new SuplrInvcItemPurOrdRefField<String>("SupplierInvoiceItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PURCHASE_ORDER =
        new SuplrInvcItemPurOrdRefField<String>("PurchaseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PURCHASE_ORDER_ITEM =
        new SuplrInvcItemPurOrdRefField<String>("PurchaseOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PLANT = new SuplrInvcItemPurOrdRefField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Document No. of a Reference Document
     */
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> REFERENCE_DOCUMENT =
        new SuplrInvcItemPurOrdRefField<String>("ReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Current Period
     */
    @SerializedName( "ReferenceDocumentFiscalYear" )
    @JsonProperty( "ReferenceDocumentFiscalYear" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentFiscalYear" )
    private String referenceDocumentFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentFiscalYear</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> REFERENCE_DOCUMENT_FISCAL_YEAR =
        new SuplrInvcItemPurOrdRefField<String>("ReferenceDocumentFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @return Item of a Reference Document
     */
    @SerializedName( "ReferenceDocumentItem" )
    @JsonProperty( "ReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentItem" )
    private String referenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> REFERENCE_DOCUMENT_ITEM =
        new SuplrInvcItemPurOrdRefField<String>("ReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSubsequentDebitCredit</b>
     * </p>
     *
     * @return Indicator: Subsequent Debit/Credit
     */
    @SerializedName( "IsSubsequentDebitCredit" )
    @JsonProperty( "IsSubsequentDebitCredit" )
    @Nullable
    @ODataField( odataName = "IsSubsequentDebitCredit" )
    private String isSubsequentDebitCredit;
    /**
     * Use with available fluent helpers to apply the <b>IsSubsequentDebitCredit</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> IS_SUBSEQUENT_DEBIT_CREDIT =
        new SuplrInvcItemPurOrdRefField<String>("IsSubsequentDebitCredit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> TAX_CODE =
        new SuplrInvcItemPurOrdRefField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> TAX_JURISDICTION =
        new SuplrInvcItemPurOrdRefField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> DOCUMENT_CURRENCY =
        new SuplrInvcItemPurOrdRefField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItemAmount</b>
     * </p>
     *
     * @return Amount in Document Currency
     */
    @SerializedName( "SupplierInvoiceItemAmount" )
    @JsonProperty( "SupplierInvoiceItemAmount" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceItemAmount" )
    private BigDecimal supplierInvoiceItemAmount;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceItemAmount</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<BigDecimal> SUPPLIER_INVOICE_ITEM_AMOUNT =
        new SuplrInvcItemPurOrdRefField<BigDecimal>("SupplierInvoiceItemAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurchaseOrderQuantityUnit" )
    @JsonProperty( "PurchaseOrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQuantityUnit" )
    private String purchaseOrderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PURCHASE_ORDER_QUANTITY_UNIT =
        new SuplrInvcItemPurOrdRefField<String>("PurchaseOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQtyUnitSAPCode</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurchaseOrderQtyUnitSAPCode" )
    @JsonProperty( "PurchaseOrderQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQtyUnitSAPCode" )
    private String purchaseOrderQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PURCHASE_ORDER_QTY_UNIT_SAP_CODE =
        new SuplrInvcItemPurOrdRefField<String>("PurchaseOrderQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "PurchaseOrderQtyUnitISOCode" )
    @JsonProperty( "PurchaseOrderQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQtyUnitISOCode" )
    private String purchaseOrderQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PURCHASE_ORDER_QTY_UNIT_ISO_CODE =
        new SuplrInvcItemPurOrdRefField<String>("PurchaseOrderQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInPurchaseOrderUnit</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "QuantityInPurchaseOrderUnit" )
    @JsonProperty( "QuantityInPurchaseOrderUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInPurchaseOrderUnit" )
    private BigDecimal quantityInPurchaseOrderUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInPurchaseOrderUnit</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<BigDecimal> QUANTITY_IN_PURCHASE_ORDER_UNIT =
        new SuplrInvcItemPurOrdRefField<BigDecimal>("QuantityInPurchaseOrderUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnit</b>
     * </p>
     *
     * @return Order Price Unit (Purchasing)
     */
    @SerializedName( "PurchaseOrderPriceUnit" )
    @JsonProperty( "PurchaseOrderPriceUnit" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderPriceUnit" )
    private String purchaseOrderPriceUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderPriceUnit</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PURCHASE_ORDER_PRICE_UNIT =
        new SuplrInvcItemPurOrdRefField<String>("PurchaseOrderPriceUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnitSAPCode</b>
     * </p>
     *
     * @return Order Price Unit (Purchasing)
     */
    @SerializedName( "PurchaseOrderPriceUnitSAPCode" )
    @JsonProperty( "PurchaseOrderPriceUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderPriceUnitSAPCode" )
    private String purchaseOrderPriceUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderPriceUnitSAPCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PURCHASE_ORDER_PRICE_UNIT_SAP_CODE =
        new SuplrInvcItemPurOrdRefField<String>("PurchaseOrderPriceUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "PurchaseOrderPriceUnitISOCode" )
    @JsonProperty( "PurchaseOrderPriceUnitISOCode" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderPriceUnitISOCode" )
    private String purchaseOrderPriceUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderPriceUnitISOCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PURCHASE_ORDER_PRICE_UNIT_ISO_CODE =
        new SuplrInvcItemPurOrdRefField<String>("PurchaseOrderPriceUnitISOCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QtyInPurchaseOrderPriceUnit</b>
     * </p>
     *
     * @return Quantity in Purchase Order Price Unit
     */
    @SerializedName( "QtyInPurchaseOrderPriceUnit" )
    @JsonProperty( "QtyInPurchaseOrderPriceUnit" )
    @Nullable
    @ODataField( odataName = "QtyInPurchaseOrderPriceUnit" )
    private BigDecimal qtyInPurchaseOrderPriceUnit;
    /**
     * Use with available fluent helpers to apply the <b>QtyInPurchaseOrderPriceUnit</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<BigDecimal> QTY_IN_PURCHASE_ORDER_PRICE_UNIT =
        new SuplrInvcItemPurOrdRefField<BigDecimal>("QtyInPurchaseOrderPriceUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcDeliveryCostCndnType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "SuplrInvcDeliveryCostCndnType" )
    @JsonProperty( "SuplrInvcDeliveryCostCndnType" )
    @Nullable
    @ODataField( odataName = "SuplrInvcDeliveryCostCndnType" )
    private String suplrInvcDeliveryCostCndnType;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcDeliveryCostCndnType</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> SUPLR_INVC_DELIVERY_COST_CNDN_TYPE =
        new SuplrInvcItemPurOrdRefField<String>("SuplrInvcDeliveryCostCndnType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcDeliveryCostCndnStep</b>
     * </p>
     *
     * @return Step Number
     */
    @SerializedName( "SuplrInvcDeliveryCostCndnStep" )
    @JsonProperty( "SuplrInvcDeliveryCostCndnStep" )
    @Nullable
    @ODataField( odataName = "SuplrInvcDeliveryCostCndnStep" )
    private String suplrInvcDeliveryCostCndnStep;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcDeliveryCostCndnStep</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> SUPLR_INVC_DELIVERY_COST_CNDN_STEP =
        new SuplrInvcItemPurOrdRefField<String>("SuplrInvcDeliveryCostCndnStep");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcDeliveryCostCndnCount</b>
     * </p>
     *
     * @return Condition Counter
     */
    @SerializedName( "SuplrInvcDeliveryCostCndnCount" )
    @JsonProperty( "SuplrInvcDeliveryCostCndnCount" )
    @Nullable
    @ODataField( odataName = "SuplrInvcDeliveryCostCndnCount" )
    private String suplrInvcDeliveryCostCndnCount;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcDeliveryCostCndnCount</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> SUPLR_INVC_DELIVERY_COST_CNDN_COUNT =
        new SuplrInvcItemPurOrdRefField<String>("SuplrInvcDeliveryCostCndnCount");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "SupplierInvoiceItemText" )
    @JsonProperty( "SupplierInvoiceItemText" )
    @Nullable
    @ODataField( odataName = "SupplierInvoiceItemText" )
    private String supplierInvoiceItemText;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoiceItemText</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> SUPPLIER_INVOICE_ITEM_TEXT =
        new SuplrInvcItemPurOrdRefField<String>("SupplierInvoiceItemText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FreightSupplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "FreightSupplier" )
    @JsonProperty( "FreightSupplier" )
    @Nullable
    @ODataField( odataName = "FreightSupplier" )
    private String freightSupplier;
    /**
     * Use with available fluent helpers to apply the <b>FreightSupplier</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> FREIGHT_SUPPLIER =
        new SuplrInvcItemPurOrdRefField<String>("FreightSupplier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNotCashDiscountLiable</b>
     * </p>
     *
     * @return Indicator: Line Item Not Liable to Cash Discount?
     */
    @SerializedName( "IsNotCashDiscountLiable" )
    @JsonProperty( "IsNotCashDiscountLiable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsNotCashDiscountLiable" )
    private Boolean isNotCashDiscountLiable;
    /**
     * Use with available fluent helpers to apply the <b>IsNotCashDiscountLiable</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<Boolean> IS_NOT_CASH_DISCOUNT_LIABLE =
        new SuplrInvcItemPurOrdRefField<Boolean>("IsNotCashDiscountLiable");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @return Item category in purchasing document
     */
    @SerializedName( "PurchasingDocumentItemCategory" )
    @JsonProperty( "PurchasingDocumentItemCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItemCategory" )
    private String purchasingDocumentItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItemCategory</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PURCHASING_DOCUMENT_ITEM_CATEGORY =
        new SuplrInvcItemPurOrdRefField<String>("PurchasingDocumentItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @return Product Type Group
     */
    @SerializedName( "ProductType" )
    @JsonProperty( "ProductType" )
    @Nullable
    @ODataField( odataName = "ProductType" )
    private String productType;
    /**
     * Use with available fluent helpers to apply the <b>ProductType</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> PRODUCT_TYPE =
        new SuplrInvcItemPurOrdRefField<String>("ProductType");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RetentionAmountInDocCurrency</b>
     * </p>
     *
     * @return Retention Amount in Document Currency
     */
    @SerializedName( "RetentionAmountInDocCurrency" )
    @JsonProperty( "RetentionAmountInDocCurrency" )
    @Nullable
    @ODataField( odataName = "RetentionAmountInDocCurrency" )
    private BigDecimal retentionAmountInDocCurrency;
    /**
     * Use with available fluent helpers to apply the <b>RetentionAmountInDocCurrency</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<BigDecimal> RETENTION_AMOUNT_IN_DOC_CURRENCY =
        new SuplrInvcItemPurOrdRefField<BigDecimal>("RetentionAmountInDocCurrency");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RetentionPercentage</b>
     * </p>
     *
     * @return Retention in Percent
     */
    @SerializedName( "RetentionPercentage" )
    @JsonProperty( "RetentionPercentage" )
    @Nullable
    @ODataField( odataName = "RetentionPercentage" )
    private BigDecimal retentionPercentage;
    /**
     * Use with available fluent helpers to apply the <b>RetentionPercentage</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<BigDecimal> RETENTION_PERCENTAGE =
        new SuplrInvcItemPurOrdRefField<BigDecimal>("RetentionPercentage");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RetentionDueDate</b>
     * </p>
     *
     * @return Due Date for Retention
     */
    @SerializedName( "RetentionDueDate" )
    @JsonProperty( "RetentionDueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RetentionDueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime retentionDueDate;
    /**
     * Use with available fluent helpers to apply the <b>RetentionDueDate</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<LocalDateTime> RETENTION_DUE_DATE =
        new SuplrInvcItemPurOrdRefField<LocalDateTime>("RetentionDueDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcItmIsNotRlvtForRtntn</b>
     * </p>
     *
     * @return Item Not Relevant to Retention
     */
    @SerializedName( "SuplrInvcItmIsNotRlvtForRtntn" )
    @JsonProperty( "SuplrInvcItmIsNotRlvtForRtntn" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SuplrInvcItmIsNotRlvtForRtntn" )
    private Boolean suplrInvcItmIsNotRlvtForRtntn;
    /**
     * Use with available fluent helpers to apply the <b>SuplrInvcItmIsNotRlvtForRtntn</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<Boolean> SUPLR_INVC_ITM_IS_NOT_RLVT_FOR_RTNTN =
        new SuplrInvcItemPurOrdRefField<Boolean>("SuplrInvcItmIsNotRlvtForRtntn");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheet</b>
     * </p>
     *
     * @return Entry Sheet Number
     */
    @SerializedName( "ServiceEntrySheet" )
    @JsonProperty( "ServiceEntrySheet" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheet" )
    private String serviceEntrySheet;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheet</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> SERVICE_ENTRY_SHEET =
        new SuplrInvcItemPurOrdRefField<String>("ServiceEntrySheet");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItem</b>
     * </p>
     *
     * @return Line Number
     */
    @SerializedName( "ServiceEntrySheetItem" )
    @JsonProperty( "ServiceEntrySheetItem" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetItem" )
    private String serviceEntrySheetItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetItem</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> SERVICE_ENTRY_SHEET_ITEM =
        new SuplrInvcItemPurOrdRefField<String>("ServiceEntrySheetItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @return Tax Reporting Country/Region
     */
    @SerializedName( "TaxCountry" )
    @JsonProperty( "TaxCountry" )
    @Nullable
    @ODataField( odataName = "TaxCountry" )
    private String taxCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxCountry</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> TAX_COUNTRY =
        new SuplrInvcItemPurOrdRefField<String>("TaxCountry");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFinallyInvoiced</b>
     * </p>
     *
     * @return Final Invoice Indicator
     */
    @SerializedName( "IsFinallyInvoiced" )
    @JsonProperty( "IsFinallyInvoiced" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsFinallyInvoiced" )
    private Boolean isFinallyInvoiced;
    /**
     * Use with available fluent helpers to apply the <b>IsFinallyInvoiced</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<Boolean> IS_FINALLY_INVOICED =
        new SuplrInvcItemPurOrdRefField<Boolean>("IsFinallyInvoiced");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @return Date for Determining Tax Rates
     */
    @SerializedName( "TaxDeterminationDate" )
    @JsonProperty( "TaxDeterminationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TaxDeterminationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime taxDeterminationDate;
    /**
     * Use with available fluent helpers to apply the <b>TaxDeterminationDate</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<LocalDateTime> TAX_DETERMINATION_DATE =
        new SuplrInvcItemPurOrdRefField<LocalDateTime>("TaxDeterminationDate");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>IN_HSNOrSACCode</b>
     * </p>
     *
     * @return HSN or SAC Code
     */
    @SerializedName( "IN_HSNOrSACCode" )
    @JsonProperty( "IN_HSNOrSACCode" )
    @Nullable
    @ODataField( odataName = "IN_HSNOrSACCode" )
    private String iN_HSNOrSACCode;
    /**
     * Use with available fluent helpers to apply the <b>IN_HSNOrSACCode</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<String> INHSN_OR_SAC_CODE =
        new SuplrInvcItemPurOrdRefField<String>("IN_HSNOrSACCode");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>IN_CustomDutyAssessableValue</b>
     * </p>
     *
     * @return Assessable Value
     */
    @SerializedName( "IN_CustomDutyAssessableValue" )
    @JsonProperty( "IN_CustomDutyAssessableValue" )
    @Nullable
    @ODataField( odataName = "IN_CustomDutyAssessableValue" )
    private BigDecimal iN_CustomDutyAssessableValue;
    /**
     * Use with available fluent helpers to apply the <b>IN_CustomDutyAssessableValue</b> field to query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefField<BigDecimal> IN_CUSTOM_DUTY_ASSESSABLE_VALUE =
        new SuplrInvcItemPurOrdRefField<BigDecimal>("IN_CustomDutyAssessableValue");
    /**
     * Navigation property <b>to_SupplierInvoiceItmAcctAssgmt</b> for <b>SuplrInvcItemPurOrdRef</b> to multiple
     * <b>SuplrInvcItemAcctAssgmt</b>.
     *
     */
    @SerializedName( "to_SupplierInvoiceItmAcctAssgmt" )
    @JsonProperty( "to_SupplierInvoiceItmAcctAssgmt" )
    @ODataField( odataName = "to_SupplierInvoiceItmAcctAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrInvcItemAcctAssgmt> toSupplierInvoiceItmAcctAssgmt;
    /**
     * Use with available fluent helpers to apply the <b>to_SupplierInvoiceItmAcctAssgmt</b> navigation property to
     * query operations.
     *
     */
    public final static SuplrInvcItemPurOrdRefLink<SuplrInvcItemAcctAssgmt> TO_SUPPLIER_INVOICE_ITM_ACCT_ASSGMT =
        new SuplrInvcItemPurOrdRefLink<SuplrInvcItemAcctAssgmt>("to_SupplierInvoiceItmAcctAssgmt");

    @Nonnull
    @Override
    public Class<SuplrInvcItemPurOrdRef> getType()
    {
        return SuplrInvcItemPurOrdRef.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     */
    public void setSupplierInvoice( @Nullable final String supplierInvoice )
    {
        rememberChangedField("SupplierInvoice", this.supplierInvoice);
        this.supplierInvoice = supplierInvoice;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItem</b>
     * </p>
     *
     * @param supplierInvoiceItem
     *            Document Item in Invoice Document
     */
    public void setSupplierInvoiceItem( @Nullable final String supplierInvoiceItem )
    {
        rememberChangedField("SupplierInvoiceItem", this.supplierInvoiceItem);
        this.supplierInvoiceItem = supplierInvoiceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchasing Document Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Document No. of a Reference Document
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentFiscalYear</b>
     * </p>
     *
     * @param referenceDocumentFiscalYear
     *            Fiscal Year of Current Period
     */
    public void setReferenceDocumentFiscalYear( @Nullable final String referenceDocumentFiscalYear )
    {
        rememberChangedField("ReferenceDocumentFiscalYear", this.referenceDocumentFiscalYear);
        this.referenceDocumentFiscalYear = referenceDocumentFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @param referenceDocumentItem
     *            Item of a Reference Document
     */
    public void setReferenceDocumentItem( @Nullable final String referenceDocumentItem )
    {
        rememberChangedField("ReferenceDocumentItem", this.referenceDocumentItem);
        this.referenceDocumentItem = referenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSubsequentDebitCredit</b>
     * </p>
     *
     * @param isSubsequentDebitCredit
     *            Indicator: Subsequent Debit/Credit
     */
    public void setIsSubsequentDebitCredit( @Nullable final String isSubsequentDebitCredit )
    {
        rememberChangedField("IsSubsequentDebitCredit", this.isSubsequentDebitCredit);
        this.isSubsequentDebitCredit = isSubsequentDebitCredit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItemAmount</b>
     * </p>
     *
     * @param supplierInvoiceItemAmount
     *            Amount in Document Currency
     */
    public void setSupplierInvoiceItemAmount( @Nullable final BigDecimal supplierInvoiceItemAmount )
    {
        rememberChangedField("SupplierInvoiceItemAmount", this.supplierInvoiceItemAmount);
        this.supplierInvoiceItemAmount = supplierInvoiceItemAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @param purchaseOrderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setPurchaseOrderQuantityUnit( @Nullable final String purchaseOrderQuantityUnit )
    {
        rememberChangedField("PurchaseOrderQuantityUnit", this.purchaseOrderQuantityUnit);
        this.purchaseOrderQuantityUnit = purchaseOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQtyUnitSAPCode</b>
     * </p>
     *
     * @param purchaseOrderQtyUnitSAPCode
     *            Purchase Order Unit of Measure
     */
    public void setPurchaseOrderQtyUnitSAPCode( @Nullable final String purchaseOrderQtyUnitSAPCode )
    {
        rememberChangedField("PurchaseOrderQtyUnitSAPCode", this.purchaseOrderQtyUnitSAPCode);
        this.purchaseOrderQtyUnitSAPCode = purchaseOrderQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQtyUnitISOCode</b>
     * </p>
     *
     * @param purchaseOrderQtyUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setPurchaseOrderQtyUnitISOCode( @Nullable final String purchaseOrderQtyUnitISOCode )
    {
        rememberChangedField("PurchaseOrderQtyUnitISOCode", this.purchaseOrderQtyUnitISOCode);
        this.purchaseOrderQtyUnitISOCode = purchaseOrderQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInPurchaseOrderUnit</b>
     * </p>
     *
     * @param quantityInPurchaseOrderUnit
     *            Quantity
     */
    public void setQuantityInPurchaseOrderUnit( @Nullable final BigDecimal quantityInPurchaseOrderUnit )
    {
        rememberChangedField("QuantityInPurchaseOrderUnit", this.quantityInPurchaseOrderUnit);
        this.quantityInPurchaseOrderUnit = quantityInPurchaseOrderUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnit</b>
     * </p>
     *
     * @param purchaseOrderPriceUnit
     *            Order Price Unit (Purchasing)
     */
    public void setPurchaseOrderPriceUnit( @Nullable final String purchaseOrderPriceUnit )
    {
        rememberChangedField("PurchaseOrderPriceUnit", this.purchaseOrderPriceUnit);
        this.purchaseOrderPriceUnit = purchaseOrderPriceUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnitSAPCode</b>
     * </p>
     *
     * @param purchaseOrderPriceUnitSAPCode
     *            Order Price Unit (Purchasing)
     */
    public void setPurchaseOrderPriceUnitSAPCode( @Nullable final String purchaseOrderPriceUnitSAPCode )
    {
        rememberChangedField("PurchaseOrderPriceUnitSAPCode", this.purchaseOrderPriceUnitSAPCode);
        this.purchaseOrderPriceUnitSAPCode = purchaseOrderPriceUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnitISOCode</b>
     * </p>
     *
     * @param purchaseOrderPriceUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setPurchaseOrderPriceUnitISOCode( @Nullable final String purchaseOrderPriceUnitISOCode )
    {
        rememberChangedField("PurchaseOrderPriceUnitISOCode", this.purchaseOrderPriceUnitISOCode);
        this.purchaseOrderPriceUnitISOCode = purchaseOrderPriceUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QtyInPurchaseOrderPriceUnit</b>
     * </p>
     *
     * @param qtyInPurchaseOrderPriceUnit
     *            Quantity in Purchase Order Price Unit
     */
    public void setQtyInPurchaseOrderPriceUnit( @Nullable final BigDecimal qtyInPurchaseOrderPriceUnit )
    {
        rememberChangedField("QtyInPurchaseOrderPriceUnit", this.qtyInPurchaseOrderPriceUnit);
        this.qtyInPurchaseOrderPriceUnit = qtyInPurchaseOrderPriceUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcDeliveryCostCndnType</b>
     * </p>
     *
     * @param suplrInvcDeliveryCostCndnType
     *            Condition Type
     */
    public void setSuplrInvcDeliveryCostCndnType( @Nullable final String suplrInvcDeliveryCostCndnType )
    {
        rememberChangedField("SuplrInvcDeliveryCostCndnType", this.suplrInvcDeliveryCostCndnType);
        this.suplrInvcDeliveryCostCndnType = suplrInvcDeliveryCostCndnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcDeliveryCostCndnStep</b>
     * </p>
     *
     * @param suplrInvcDeliveryCostCndnStep
     *            Step Number
     */
    public void setSuplrInvcDeliveryCostCndnStep( @Nullable final String suplrInvcDeliveryCostCndnStep )
    {
        rememberChangedField("SuplrInvcDeliveryCostCndnStep", this.suplrInvcDeliveryCostCndnStep);
        this.suplrInvcDeliveryCostCndnStep = suplrInvcDeliveryCostCndnStep;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcDeliveryCostCndnCount</b>
     * </p>
     *
     * @param suplrInvcDeliveryCostCndnCount
     *            Condition Counter
     */
    public void setSuplrInvcDeliveryCostCndnCount( @Nullable final String suplrInvcDeliveryCostCndnCount )
    {
        rememberChangedField("SuplrInvcDeliveryCostCndnCount", this.suplrInvcDeliveryCostCndnCount);
        this.suplrInvcDeliveryCostCndnCount = suplrInvcDeliveryCostCndnCount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoiceItemText</b>
     * </p>
     *
     * @param supplierInvoiceItemText
     *            Item Text
     */
    public void setSupplierInvoiceItemText( @Nullable final String supplierInvoiceItemText )
    {
        rememberChangedField("SupplierInvoiceItemText", this.supplierInvoiceItemText);
        this.supplierInvoiceItemText = supplierInvoiceItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FreightSupplier</b>
     * </p>
     *
     * @param freightSupplier
     *            Account Number of Supplier
     */
    public void setFreightSupplier( @Nullable final String freightSupplier )
    {
        rememberChangedField("FreightSupplier", this.freightSupplier);
        this.freightSupplier = freightSupplier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNotCashDiscountLiable</b>
     * </p>
     *
     * @param isNotCashDiscountLiable
     *            Indicator: Line Item Not Liable to Cash Discount?
     */
    public void setIsNotCashDiscountLiable( @Nullable final Boolean isNotCashDiscountLiable )
    {
        rememberChangedField("IsNotCashDiscountLiable", this.isNotCashDiscountLiable);
        this.isNotCashDiscountLiable = isNotCashDiscountLiable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @param purchasingDocumentItemCategory
     *            Item category in purchasing document
     */
    public void setPurchasingDocumentItemCategory( @Nullable final String purchasingDocumentItemCategory )
    {
        rememberChangedField("PurchasingDocumentItemCategory", this.purchasingDocumentItemCategory);
        this.purchasingDocumentItemCategory = purchasingDocumentItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @param productType
     *            Product Type Group
     */
    public void setProductType( @Nullable final String productType )
    {
        rememberChangedField("ProductType", this.productType);
        this.productType = productType;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RetentionAmountInDocCurrency</b>
     * </p>
     *
     * @param retentionAmountInDocCurrency
     *            Retention Amount in Document Currency
     */
    public void setRetentionAmountInDocCurrency( @Nullable final BigDecimal retentionAmountInDocCurrency )
    {
        rememberChangedField("RetentionAmountInDocCurrency", this.retentionAmountInDocCurrency);
        this.retentionAmountInDocCurrency = retentionAmountInDocCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RetentionPercentage</b>
     * </p>
     *
     * @param retentionPercentage
     *            Retention in Percent
     */
    public void setRetentionPercentage( @Nullable final BigDecimal retentionPercentage )
    {
        rememberChangedField("RetentionPercentage", this.retentionPercentage);
        this.retentionPercentage = retentionPercentage;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RetentionDueDate</b>
     * </p>
     *
     * @param retentionDueDate
     *            Due Date for Retention
     */
    public void setRetentionDueDate( @Nullable final LocalDateTime retentionDueDate )
    {
        rememberChangedField("RetentionDueDate", this.retentionDueDate);
        this.retentionDueDate = retentionDueDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SuplrInvcItmIsNotRlvtForRtntn</b>
     * </p>
     *
     * @param suplrInvcItmIsNotRlvtForRtntn
     *            Item Not Relevant to Retention
     */
    public void setSuplrInvcItmIsNotRlvtForRtntn( @Nullable final Boolean suplrInvcItmIsNotRlvtForRtntn )
    {
        rememberChangedField("SuplrInvcItmIsNotRlvtForRtntn", this.suplrInvcItmIsNotRlvtForRtntn);
        this.suplrInvcItmIsNotRlvtForRtntn = suplrInvcItmIsNotRlvtForRtntn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheet</b>
     * </p>
     *
     * @param serviceEntrySheet
     *            Entry Sheet Number
     */
    public void setServiceEntrySheet( @Nullable final String serviceEntrySheet )
    {
        rememberChangedField("ServiceEntrySheet", this.serviceEntrySheet);
        this.serviceEntrySheet = serviceEntrySheet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItem</b>
     * </p>
     *
     * @param serviceEntrySheetItem
     *            Line Number
     */
    public void setServiceEntrySheetItem( @Nullable final String serviceEntrySheetItem )
    {
        rememberChangedField("ServiceEntrySheetItem", this.serviceEntrySheetItem);
        this.serviceEntrySheetItem = serviceEntrySheetItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @param taxCountry
     *            Tax Reporting Country/Region
     */
    public void setTaxCountry( @Nullable final String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFinallyInvoiced</b>
     * </p>
     *
     * @param isFinallyInvoiced
     *            Final Invoice Indicator
     */
    public void setIsFinallyInvoiced( @Nullable final Boolean isFinallyInvoiced )
    {
        rememberChangedField("IsFinallyInvoiced", this.isFinallyInvoiced);
        this.isFinallyInvoiced = isFinallyInvoiced;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @param taxDeterminationDate
     *            Date for Determining Tax Rates
     */
    public void setTaxDeterminationDate( @Nullable final LocalDateTime taxDeterminationDate )
    {
        rememberChangedField("TaxDeterminationDate", this.taxDeterminationDate);
        this.taxDeterminationDate = taxDeterminationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>IN_HSNOrSACCode</b>
     * </p>
     *
     * @param iN_HSNOrSACCode
     *            HSN or SAC Code
     */
    public void setIN_HSNOrSACCode( @Nullable final String iN_HSNOrSACCode )
    {
        rememberChangedField("IN_HSNOrSACCode", this.iN_HSNOrSACCode);
        this.iN_HSNOrSACCode = iN_HSNOrSACCode;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>IN_CustomDutyAssessableValue</b>
     * </p>
     *
     * @param iN_CustomDutyAssessableValue
     *            Assessable Value
     */
    public void setIN_CustomDutyAssessableValue( @Nullable final BigDecimal iN_CustomDutyAssessableValue )
    {
        rememberChangedField("IN_CustomDutyAssessableValue", this.iN_CustomDutyAssessableValue);
        this.iN_CustomDutyAssessableValue = iN_CustomDutyAssessableValue;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrInvcItemPurOrdRef";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SupplierInvoice", getSupplierInvoice());
        result.put("FiscalYear", getFiscalYear());
        result.put("SupplierInvoiceItem", getSupplierInvoiceItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierInvoice", getSupplierInvoice());
        values.put("FiscalYear", getFiscalYear());
        values.put("SupplierInvoiceItem", getSupplierInvoiceItem());
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("Plant", getPlant());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ReferenceDocumentFiscalYear", getReferenceDocumentFiscalYear());
        values.put("ReferenceDocumentItem", getReferenceDocumentItem());
        values.put("IsSubsequentDebitCredit", getIsSubsequentDebitCredit());
        values.put("TaxCode", getTaxCode());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("SupplierInvoiceItemAmount", getSupplierInvoiceItemAmount());
        values.put("PurchaseOrderQuantityUnit", getPurchaseOrderQuantityUnit());
        values.put("PurchaseOrderQtyUnitSAPCode", getPurchaseOrderQtyUnitSAPCode());
        values.put("PurchaseOrderQtyUnitISOCode", getPurchaseOrderQtyUnitISOCode());
        values.put("QuantityInPurchaseOrderUnit", getQuantityInPurchaseOrderUnit());
        values.put("PurchaseOrderPriceUnit", getPurchaseOrderPriceUnit());
        values.put("PurchaseOrderPriceUnitSAPCode", getPurchaseOrderPriceUnitSAPCode());
        values.put("PurchaseOrderPriceUnitISOCode", getPurchaseOrderPriceUnitISOCode());
        values.put("QtyInPurchaseOrderPriceUnit", getQtyInPurchaseOrderPriceUnit());
        values.put("SuplrInvcDeliveryCostCndnType", getSuplrInvcDeliveryCostCndnType());
        values.put("SuplrInvcDeliveryCostCndnStep", getSuplrInvcDeliveryCostCndnStep());
        values.put("SuplrInvcDeliveryCostCndnCount", getSuplrInvcDeliveryCostCndnCount());
        values.put("SupplierInvoiceItemText", getSupplierInvoiceItemText());
        values.put("FreightSupplier", getFreightSupplier());
        values.put("IsNotCashDiscountLiable", getIsNotCashDiscountLiable());
        values.put("PurchasingDocumentItemCategory", getPurchasingDocumentItemCategory());
        values.put("ProductType", getProductType());
        values.put("RetentionAmountInDocCurrency", getRetentionAmountInDocCurrency());
        values.put("RetentionPercentage", getRetentionPercentage());
        values.put("RetentionDueDate", getRetentionDueDate());
        values.put("SuplrInvcItmIsNotRlvtForRtntn", getSuplrInvcItmIsNotRlvtForRtntn());
        values.put("ServiceEntrySheet", getServiceEntrySheet());
        values.put("ServiceEntrySheetItem", getServiceEntrySheetItem());
        values.put("TaxCountry", getTaxCountry());
        values.put("IsFinallyInvoiced", getIsFinallyInvoiced());
        values.put("TaxDeterminationDate", getTaxDeterminationDate());
        values.put("IN_HSNOrSACCode", getIN_HSNOrSACCode());
        values.put("IN_CustomDutyAssessableValue", getIN_CustomDutyAssessableValue());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierInvoice") ) {
                final Object value = values.remove("SupplierInvoice");
                if( (value == null) || (!value.equals(getSupplierInvoice())) ) {
                    setSupplierInvoice(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("SupplierInvoiceItem") ) {
                final Object value = values.remove("SupplierInvoiceItem");
                if( (value == null) || (!value.equals(getSupplierInvoiceItem())) ) {
                    setSupplierInvoiceItem(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentFiscalYear") ) {
                final Object value = values.remove("ReferenceDocumentFiscalYear");
                if( (value == null) || (!value.equals(getReferenceDocumentFiscalYear())) ) {
                    setReferenceDocumentFiscalYear(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentItem") ) {
                final Object value = values.remove("ReferenceDocumentItem");
                if( (value == null) || (!value.equals(getReferenceDocumentItem())) ) {
                    setReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("IsSubsequentDebitCredit") ) {
                final Object value = values.remove("IsSubsequentDebitCredit");
                if( (value == null) || (!value.equals(getIsSubsequentDebitCredit())) ) {
                    setIsSubsequentDebitCredit(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("SupplierInvoiceItemAmount") ) {
                final Object value = values.remove("SupplierInvoiceItemAmount");
                if( (value == null) || (!value.equals(getSupplierInvoiceItemAmount())) ) {
                    setSupplierInvoiceItemAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseOrderQuantityUnit") ) {
                final Object value = values.remove("PurchaseOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurchaseOrderQuantityUnit())) ) {
                    setPurchaseOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderQtyUnitSAPCode") ) {
                final Object value = values.remove("PurchaseOrderQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getPurchaseOrderQtyUnitSAPCode())) ) {
                    setPurchaseOrderQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderQtyUnitISOCode") ) {
                final Object value = values.remove("PurchaseOrderQtyUnitISOCode");
                if( (value == null) || (!value.equals(getPurchaseOrderQtyUnitISOCode())) ) {
                    setPurchaseOrderQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("QuantityInPurchaseOrderUnit") ) {
                final Object value = values.remove("QuantityInPurchaseOrderUnit");
                if( (value == null) || (!value.equals(getQuantityInPurchaseOrderUnit())) ) {
                    setQuantityInPurchaseOrderUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseOrderPriceUnit") ) {
                final Object value = values.remove("PurchaseOrderPriceUnit");
                if( (value == null) || (!value.equals(getPurchaseOrderPriceUnit())) ) {
                    setPurchaseOrderPriceUnit(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderPriceUnitSAPCode") ) {
                final Object value = values.remove("PurchaseOrderPriceUnitSAPCode");
                if( (value == null) || (!value.equals(getPurchaseOrderPriceUnitSAPCode())) ) {
                    setPurchaseOrderPriceUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderPriceUnitISOCode") ) {
                final Object value = values.remove("PurchaseOrderPriceUnitISOCode");
                if( (value == null) || (!value.equals(getPurchaseOrderPriceUnitISOCode())) ) {
                    setPurchaseOrderPriceUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("QtyInPurchaseOrderPriceUnit") ) {
                final Object value = values.remove("QtyInPurchaseOrderPriceUnit");
                if( (value == null) || (!value.equals(getQtyInPurchaseOrderPriceUnit())) ) {
                    setQtyInPurchaseOrderPriceUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("SuplrInvcDeliveryCostCndnType") ) {
                final Object value = values.remove("SuplrInvcDeliveryCostCndnType");
                if( (value == null) || (!value.equals(getSuplrInvcDeliveryCostCndnType())) ) {
                    setSuplrInvcDeliveryCostCndnType(((String) value));
                }
            }
            if( values.containsKey("SuplrInvcDeliveryCostCndnStep") ) {
                final Object value = values.remove("SuplrInvcDeliveryCostCndnStep");
                if( (value == null) || (!value.equals(getSuplrInvcDeliveryCostCndnStep())) ) {
                    setSuplrInvcDeliveryCostCndnStep(((String) value));
                }
            }
            if( values.containsKey("SuplrInvcDeliveryCostCndnCount") ) {
                final Object value = values.remove("SuplrInvcDeliveryCostCndnCount");
                if( (value == null) || (!value.equals(getSuplrInvcDeliveryCostCndnCount())) ) {
                    setSuplrInvcDeliveryCostCndnCount(((String) value));
                }
            }
            if( values.containsKey("SupplierInvoiceItemText") ) {
                final Object value = values.remove("SupplierInvoiceItemText");
                if( (value == null) || (!value.equals(getSupplierInvoiceItemText())) ) {
                    setSupplierInvoiceItemText(((String) value));
                }
            }
            if( values.containsKey("FreightSupplier") ) {
                final Object value = values.remove("FreightSupplier");
                if( (value == null) || (!value.equals(getFreightSupplier())) ) {
                    setFreightSupplier(((String) value));
                }
            }
            if( values.containsKey("IsNotCashDiscountLiable") ) {
                final Object value = values.remove("IsNotCashDiscountLiable");
                if( (value == null) || (!value.equals(getIsNotCashDiscountLiable())) ) {
                    setIsNotCashDiscountLiable(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItemCategory") ) {
                final Object value = values.remove("PurchasingDocumentItemCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentItemCategory())) ) {
                    setPurchasingDocumentItemCategory(((String) value));
                }
            }
            if( values.containsKey("ProductType") ) {
                final Object value = values.remove("ProductType");
                if( (value == null) || (!value.equals(getProductType())) ) {
                    setProductType(((String) value));
                }
            }
            if( values.containsKey("RetentionAmountInDocCurrency") ) {
                final Object value = values.remove("RetentionAmountInDocCurrency");
                if( (value == null) || (!value.equals(getRetentionAmountInDocCurrency())) ) {
                    setRetentionAmountInDocCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("RetentionPercentage") ) {
                final Object value = values.remove("RetentionPercentage");
                if( (value == null) || (!value.equals(getRetentionPercentage())) ) {
                    setRetentionPercentage(((BigDecimal) value));
                }
            }
            if( values.containsKey("RetentionDueDate") ) {
                final Object value = values.remove("RetentionDueDate");
                if( (value == null) || (!value.equals(getRetentionDueDate())) ) {
                    setRetentionDueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SuplrInvcItmIsNotRlvtForRtntn") ) {
                final Object value = values.remove("SuplrInvcItmIsNotRlvtForRtntn");
                if( (value == null) || (!value.equals(getSuplrInvcItmIsNotRlvtForRtntn())) ) {
                    setSuplrInvcItmIsNotRlvtForRtntn(((Boolean) value));
                }
            }
            if( values.containsKey("ServiceEntrySheet") ) {
                final Object value = values.remove("ServiceEntrySheet");
                if( (value == null) || (!value.equals(getServiceEntrySheet())) ) {
                    setServiceEntrySheet(((String) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetItem") ) {
                final Object value = values.remove("ServiceEntrySheetItem");
                if( (value == null) || (!value.equals(getServiceEntrySheetItem())) ) {
                    setServiceEntrySheetItem(((String) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((String) value));
                }
            }
            if( values.containsKey("IsFinallyInvoiced") ) {
                final Object value = values.remove("IsFinallyInvoiced");
                if( (value == null) || (!value.equals(getIsFinallyInvoiced())) ) {
                    setIsFinallyInvoiced(((Boolean) value));
                }
            }
            if( values.containsKey("TaxDeterminationDate") ) {
                final Object value = values.remove("TaxDeterminationDate");
                if( (value == null) || (!value.equals(getTaxDeterminationDate())) ) {
                    setTaxDeterminationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("IN_HSNOrSACCode") ) {
                final Object value = values.remove("IN_HSNOrSACCode");
                if( (value == null) || (!value.equals(getIN_HSNOrSACCode())) ) {
                    setIN_HSNOrSACCode(((String) value));
                }
            }
            if( values.containsKey("IN_CustomDutyAssessableValue") ) {
                final Object value = values.remove("IN_CustomDutyAssessableValue");
                if( (value == null) || (!value.equals(getIN_CustomDutyAssessableValue())) ) {
                    setIN_CustomDutyAssessableValue(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SupplierInvoiceItmAcctAssgmt") ) {
                final Object value = (values).remove("to_SupplierInvoiceItmAcctAssgmt");
                if( value instanceof Iterable ) {
                    if( toSupplierInvoiceItmAcctAssgmt == null ) {
                        toSupplierInvoiceItmAcctAssgmt = Lists.newArrayList();
                    } else {
                        toSupplierInvoiceItmAcctAssgmt = Lists.newArrayList(toSupplierInvoiceItmAcctAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrInvcItemAcctAssgmt entity;
                        if( toSupplierInvoiceItmAcctAssgmt.size() > i ) {
                            entity = toSupplierInvoiceItmAcctAssgmt.get(i);
                        } else {
                            entity = new SuplrInvcItemAcctAssgmt();
                            toSupplierInvoiceItmAcctAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrInvcItemPurOrdRefField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrInvcItemPurOrdRefField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrInvcItemPurOrdRefField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrInvcItemPurOrdRefField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSupplierInvoiceItmAcctAssgmt != null ) {
            (values).put("to_SupplierInvoiceItmAcctAssgmt", toSupplierInvoiceItmAcctAssgmt);
        }
        return values;
    }

    /**
     * Fetches the <b>SuplrInvcItemAcctAssgmt</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SupplierInvoiceItmAcctAssgmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SuplrInvcItemAcctAssgmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcItemAcctAssgmt> fetchSupplierInvoiceItmAcctAssgmt()
    {
        return fetchFieldAsList("to_SupplierInvoiceItmAcctAssgmt", SuplrInvcItemAcctAssgmt.class);
    }

    /**
     * Retrieval of associated <b>SuplrInvcItemAcctAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceItmAcctAssgmt</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceItmAcctAssgmt</b> of a queried <b>SuplrInvcItemPurOrdRef</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SuplrInvcItemAcctAssgmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SuplrInvcItemAcctAssgmt> getSupplierInvoiceItmAcctAssgmtOrFetch()
    {
        if( toSupplierInvoiceItmAcctAssgmt == null ) {
            toSupplierInvoiceItmAcctAssgmt = fetchSupplierInvoiceItmAcctAssgmt();
        }
        return toSupplierInvoiceItmAcctAssgmt;
    }

    /**
     * Retrieval of associated <b>SuplrInvcItemAcctAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceItmAcctAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>SuplrInvcItemPurOrdRef</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SupplierInvoiceItmAcctAssgmt</b> is already loaded, the
     *         result will contain the <b>SuplrInvcItemAcctAssgmt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrInvcItemAcctAssgmt>> getSupplierInvoiceItmAcctAssgmtIfPresent()
    {
        return Option.of(toSupplierInvoiceItmAcctAssgmt);
    }

    /**
     * Overwrites the list of associated <b>SuplrInvcItemAcctAssgmt</b> entities for the loaded navigation property
     * <b>to_SupplierInvoiceItmAcctAssgmt</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceItmAcctAssgmt</b> of a queried <b>SuplrInvcItemPurOrdRef</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SuplrInvcItemAcctAssgmt</b> entities.
     */
    public void setSupplierInvoiceItmAcctAssgmt( @Nonnull final List<SuplrInvcItemAcctAssgmt> value )
    {
        if( toSupplierInvoiceItmAcctAssgmt == null ) {
            toSupplierInvoiceItmAcctAssgmt = Lists.newArrayList();
        }
        toSupplierInvoiceItmAcctAssgmt.clear();
        toSupplierInvoiceItmAcctAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrInvcItemAcctAssgmt</b> entities. This corresponds to the OData
     * navigation property <b>to_SupplierInvoiceItmAcctAssgmt</b>.
     * <p>
     * If the navigation property <b>to_SupplierInvoiceItmAcctAssgmt</b> of a queried <b>SuplrInvcItemPurOrdRef</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SuplrInvcItemAcctAssgmt</b> entities.
     */
    public void addSupplierInvoiceItmAcctAssgmt( SuplrInvcItemAcctAssgmt... entity )
    {
        if( toSupplierInvoiceItmAcctAssgmt == null ) {
            toSupplierInvoiceItmAcctAssgmt = Lists.newArrayList();
        }
        toSupplierInvoiceItmAcctAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SuplrInvcItemPurOrdRef instances.
     *
     */
    public final static class SuplrInvcItemPurOrdRefBuilder
    {

        private List<SuplrInvcItemAcctAssgmt> toSupplierInvoiceItmAcctAssgmt = Lists.newArrayList();

        private SuplrInvcItemPurOrdRef.SuplrInvcItemPurOrdRefBuilder toSupplierInvoiceItmAcctAssgmt(
            final List<SuplrInvcItemAcctAssgmt> value )
        {
            toSupplierInvoiceItmAcctAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SupplierInvoiceItmAcctAssgmt</b> for <b>SuplrInvcItemPurOrdRef</b> to multiple
         * <b>SuplrInvcItemAcctAssgmt</b>.
         *
         * @param value
         *            The SuplrInvcItemAcctAssgmts to build this SuplrInvcItemPurOrdRef with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SuplrInvcItemPurOrdRef.SuplrInvcItemPurOrdRefBuilder supplierInvoiceItmAcctAssgmt(
            SuplrInvcItemAcctAssgmt... value )
        {
            return toSupplierInvoiceItmAcctAssgmt(Lists.newArrayList(value));
        }

    }

}
