/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvcSeldPurgDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SuplrInvcSeldPurgDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * SI Entered Purchasing Documents
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrInvcSeldPurgDocumentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrInvcSeldPurgDocument extends VdmEntity<SuplrInvcSeldPurgDocument>
{

    /**
     * Selector for all available fields of SuplrInvcSeldPurgDocument.
     *
     */
    public final static SuplrInvcSeldPurgDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @return Document Number of an Accounting Document
     */
    @Key
    @SerializedName( "SupplierInvoice" )
    @JsonProperty( "SupplierInvoice" )
    @Nullable
    @ODataField( odataName = "SupplierInvoice" )
    private String supplierInvoice;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoice</b> field to query operations.
     *
     */
    public final static SuplrInvcSeldPurgDocumentField<String> SUPPLIER_INVOICE =
        new SuplrInvcSeldPurgDocumentField<String>("SupplierInvoice");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static SuplrInvcSeldPurgDocumentField<String> FISCAL_YEAR =
        new SuplrInvcSeldPurgDocumentField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static SuplrInvcSeldPurgDocumentField<String> PURCHASE_ORDER =
        new SuplrInvcSeldPurgDocumentField<String>("PurchaseOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static SuplrInvcSeldPurgDocumentField<String> PURCHASE_ORDER_ITEM =
        new SuplrInvcSeldPurgDocumentField<String>("PurchaseOrderItem");

    @Nonnull
    @Override
    public Class<SuplrInvcSeldPurgDocument> getType()
    {
        return SuplrInvcSeldPurgDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     */
    public void setSupplierInvoice( @Nullable final String supplierInvoice )
    {
        rememberChangedField("SupplierInvoice", this.supplierInvoice);
        this.supplierInvoice = supplierInvoice;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchasing Document Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrInvcSeldPurgDocument";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SupplierInvoice", getSupplierInvoice());
        result.put("FiscalYear", getFiscalYear());
        result.put("PurchaseOrder", getPurchaseOrder());
        result.put("PurchaseOrderItem", getPurchaseOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierInvoice", getSupplierInvoice());
        values.put("FiscalYear", getFiscalYear());
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierInvoice") ) {
                final Object value = values.remove("SupplierInvoice");
                if( (value == null) || (!value.equals(getSupplierInvoice())) ) {
                    setSupplierInvoice(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SuplrInvcSeldPurgDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SuplrInvcSeldPurgDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrInvcSeldPurgDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrInvcSeldPurgDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService.DEFAULT_SERVICE_PATH);
    }

}
