/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SuplrInvcSeldPurgDocumentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocument
 * SuplrInvcSeldPurgDocument} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SuplrInvcSeldPurgDocumentByKeyFluentHelper
    extends
    FluentHelperByKey<SuplrInvcSeldPurgDocumentByKeyFluentHelper, SuplrInvcSeldPurgDocument, SuplrInvcSeldPurgDocumentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocument
     * SuplrInvcSeldPurgDocument} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SuplrInvcSeldPurgDocument}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SuplrInvcSeldPurgDocument}
     * @param purchaseOrder
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public SuplrInvcSeldPurgDocumentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String supplierInvoice,
        final String fiscalYear,
        final String purchaseOrder,
        final String purchaseOrderItem )
    {
        super(servicePath, entityCollection);
        this.key.put("SupplierInvoice", supplierInvoice);
        this.key.put("FiscalYear", fiscalYear);
        this.key.put("PurchaseOrder", purchaseOrder);
        this.key.put("PurchaseOrderItem", purchaseOrderItem);
    }

    @Override
    @Nonnull
    protected Class<SuplrInvcSeldPurgDocument> getEntityClass()
    {
        return SuplrInvcSeldPurgDocument.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
