/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvcSeldSrvcEntrShtLeanField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SuplrInvcSeldSrvcEntrShtLeanSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * SI Entered Service Entry Sheets (Lean)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrInvcSeldSrvcEntrShtLeanType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrInvcSeldSrvcEntrShtLean extends VdmEntity<SuplrInvcSeldSrvcEntrShtLean>
{

    /**
     * Selector for all available fields of SuplrInvcSeldSrvcEntrShtLean.
     *
     */
    public final static SuplrInvcSeldSrvcEntrShtLeanSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @return Document Number of an Accounting Document
     */
    @Key
    @SerializedName( "SupplierInvoice" )
    @JsonProperty( "SupplierInvoice" )
    @Nullable
    @ODataField( odataName = "SupplierInvoice" )
    private String supplierInvoice;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoice</b> field to query operations.
     *
     */
    public final static SuplrInvcSeldSrvcEntrShtLeanField<String> SUPPLIER_INVOICE =
        new SuplrInvcSeldSrvcEntrShtLeanField<String>("SupplierInvoice");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static SuplrInvcSeldSrvcEntrShtLeanField<String> FISCAL_YEAR =
        new SuplrInvcSeldSrvcEntrShtLeanField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheet</b>
     * </p>
     *
     * @return Service Entry Sheet
     */
    @Key
    @SerializedName( "ServiceEntrySheet" )
    @JsonProperty( "ServiceEntrySheet" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheet" )
    private String serviceEntrySheet;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheet</b> field to query operations.
     *
     */
    public final static SuplrInvcSeldSrvcEntrShtLeanField<String> SERVICE_ENTRY_SHEET =
        new SuplrInvcSeldSrvcEntrShtLeanField<String>("ServiceEntrySheet");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItem</b>
     * </p>
     *
     * @return Item Number of Service Entry Sheet
     */
    @Key
    @SerializedName( "ServiceEntrySheetItem" )
    @JsonProperty( "ServiceEntrySheetItem" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetItem" )
    private String serviceEntrySheetItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetItem</b> field to query operations.
     *
     */
    public final static SuplrInvcSeldSrvcEntrShtLeanField<String> SERVICE_ENTRY_SHEET_ITEM =
        new SuplrInvcSeldSrvcEntrShtLeanField<String>("ServiceEntrySheetItem");

    @Nonnull
    @Override
    public Class<SuplrInvcSeldSrvcEntrShtLean> getType()
    {
        return SuplrInvcSeldSrvcEntrShtLean.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     */
    public void setSupplierInvoice( @Nullable final String supplierInvoice )
    {
        rememberChangedField("SupplierInvoice", this.supplierInvoice);
        this.supplierInvoice = supplierInvoice;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheet</b>
     * </p>
     *
     * @param serviceEntrySheet
     *            Service Entry Sheet
     */
    public void setServiceEntrySheet( @Nullable final String serviceEntrySheet )
    {
        rememberChangedField("ServiceEntrySheet", this.serviceEntrySheet);
        this.serviceEntrySheet = serviceEntrySheet;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItem</b>
     * </p>
     *
     * @param serviceEntrySheetItem
     *            Item Number of Service Entry Sheet
     */
    public void setServiceEntrySheetItem( @Nullable final String serviceEntrySheetItem )
    {
        rememberChangedField("ServiceEntrySheetItem", this.serviceEntrySheetItem);
        this.serviceEntrySheetItem = serviceEntrySheetItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrInvcSeldSrvcEntrShtLean";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SupplierInvoice", getSupplierInvoice());
        result.put("FiscalYear", getFiscalYear());
        result.put("ServiceEntrySheet", getServiceEntrySheet());
        result.put("ServiceEntrySheetItem", getServiceEntrySheetItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierInvoice", getSupplierInvoice());
        values.put("FiscalYear", getFiscalYear());
        values.put("ServiceEntrySheet", getServiceEntrySheet());
        values.put("ServiceEntrySheetItem", getServiceEntrySheetItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierInvoice") ) {
                final Object value = values.remove("SupplierInvoice");
                if( (value == null) || (!value.equals(getSupplierInvoice())) ) {
                    setSupplierInvoice(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("ServiceEntrySheet") ) {
                final Object value = values.remove("ServiceEntrySheet");
                if( (value == null) || (!value.equals(getServiceEntrySheet())) ) {
                    setServiceEntrySheet(((String) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetItem") ) {
                final Object value = values.remove("ServiceEntrySheetItem");
                if( (value == null) || (!value.equals(getServiceEntrySheetItem())) ) {
                    setServiceEntrySheetItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SuplrInvcSeldSrvcEntrShtLeanField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SuplrInvcSeldSrvcEntrShtLeanField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrInvcSeldSrvcEntrShtLeanField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrInvcSeldSrvcEntrShtLeanField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService.DEFAULT_SERVICE_PATH);
    }

}
