/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SuplrInvcSeldSrvcEntrShtLeanSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean
 * SuplrInvcSeldSrvcEntrShtLean} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SuplrInvcSeldSrvcEntrShtLeanByKeyFluentHelper
    extends
    FluentHelperByKey<SuplrInvcSeldSrvcEntrShtLeanByKeyFluentHelper, SuplrInvcSeldSrvcEntrShtLean, SuplrInvcSeldSrvcEntrShtLeanSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean
     * SuplrInvcSeldSrvcEntrShtLean} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SuplrInvcSeldSrvcEntrShtLean}
     * @param serviceEntrySheetItem
     *            Item Number of Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SuplrInvcSeldSrvcEntrShtLean}
     * @param serviceEntrySheet
     *            Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public SuplrInvcSeldSrvcEntrShtLeanByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String supplierInvoice,
        final String fiscalYear,
        final String serviceEntrySheet,
        final String serviceEntrySheetItem )
    {
        super(servicePath, entityCollection);
        this.key.put("SupplierInvoice", supplierInvoice);
        this.key.put("FiscalYear", fiscalYear);
        this.key.put("ServiceEntrySheet", serviceEntrySheet);
        this.key.put("ServiceEntrySheetItem", serviceEntrySheetItem);
    }

    @Override
    @Nonnull
    protected Class<SuplrInvcSeldSrvcEntrShtLean> getEntityClass()
    {
        return SuplrInvcSeldSrvcEntrShtLean.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
