/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.field.SuplrInvoiceAdditionalDataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.selectable.SuplrInvoiceAdditionalDataSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Additional Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SuplrInvoiceAdditionalDataType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SuplrInvoiceAdditionalData extends VdmEntity<SuplrInvoiceAdditionalData>
{

    /**
     * Selector for all available fields of SuplrInvoiceAdditionalData.
     *
     */
    public final static SuplrInvoiceAdditionalDataSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @return Document Number of an Invoice Document
     */
    @Key
    @SerializedName( "SupplierInvoice" )
    @JsonProperty( "SupplierInvoice" )
    @Nullable
    @ODataField( odataName = "SupplierInvoice" )
    private String supplierInvoice;
    /**
     * Use with available fluent helpers to apply the <b>SupplierInvoice</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> SUPPLIER_INVOICE =
        new SuplrInvoiceAdditionalDataField<String>("SupplierInvoice");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> FISCAL_YEAR =
        new SuplrInvoiceAdditionalDataField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingPartyName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "InvoicingPartyName1" )
    @JsonProperty( "InvoicingPartyName1" )
    @Nullable
    @ODataField( odataName = "InvoicingPartyName1" )
    private String invoicingPartyName1;
    /**
     * Use with available fluent helpers to apply the <b>InvoicingPartyName1</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> INVOICING_PARTY_NAME1 =
        new SuplrInvoiceAdditionalDataField<String>("InvoicingPartyName1");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingPartyName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "InvoicingPartyName2" )
    @JsonProperty( "InvoicingPartyName2" )
    @Nullable
    @ODataField( odataName = "InvoicingPartyName2" )
    private String invoicingPartyName2;
    /**
     * Use with available fluent helpers to apply the <b>InvoicingPartyName2</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> INVOICING_PARTY_NAME2 =
        new SuplrInvoiceAdditionalDataField<String>("InvoicingPartyName2");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingPartyName3</b>
     * </p>
     *
     * @return Name 3
     */
    @SerializedName( "InvoicingPartyName3" )
    @JsonProperty( "InvoicingPartyName3" )
    @Nullable
    @ODataField( odataName = "InvoicingPartyName3" )
    private String invoicingPartyName3;
    /**
     * Use with available fluent helpers to apply the <b>InvoicingPartyName3</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> INVOICING_PARTY_NAME3 =
        new SuplrInvoiceAdditionalDataField<String>("InvoicingPartyName3");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingPartyName4</b>
     * </p>
     *
     * @return Name 4
     */
    @SerializedName( "InvoicingPartyName4" )
    @JsonProperty( "InvoicingPartyName4" )
    @Nullable
    @ODataField( odataName = "InvoicingPartyName4" )
    private String invoicingPartyName4;
    /**
     * Use with available fluent helpers to apply the <b>InvoicingPartyName4</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> INVOICING_PARTY_NAME4 =
        new SuplrInvoiceAdditionalDataField<String>("InvoicingPartyName4");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> POSTAL_CODE =
        new SuplrInvoiceAdditionalDataField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> CITY_NAME =
        new SuplrInvoiceAdditionalDataField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> COUNTRY =
        new SuplrInvoiceAdditionalDataField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StreetAddressName</b>
     * </p>
     *
     * @return Street and House Number
     */
    @SerializedName( "StreetAddressName" )
    @JsonProperty( "StreetAddressName" )
    @Nullable
    @ODataField( odataName = "StreetAddressName" )
    private String streetAddressName;
    /**
     * Use with available fluent helpers to apply the <b>StreetAddressName</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> STREET_ADDRESS_NAME =
        new SuplrInvoiceAdditionalDataField<String>("StreetAddressName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @return PO Box
     */
    @SerializedName( "POBox" )
    @JsonProperty( "POBox" )
    @Nullable
    @ODataField( odataName = "POBox" )
    private String pOBox;
    /**
     * Use with available fluent helpers to apply the <b>POBox</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> PO_BOX =
        new SuplrInvoiceAdditionalDataField<String>("POBox");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBoxPostalCode</b>
     * </p>
     *
     * @return P.O. Box Postal Code
     */
    @SerializedName( "POBoxPostalCode" )
    @JsonProperty( "POBoxPostalCode" )
    @Nullable
    @ODataField( odataName = "POBoxPostalCode" )
    private String pOBoxPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>POBoxPostalCode</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> PO_BOX_POSTAL_CODE =
        new SuplrInvoiceAdditionalDataField<String>("POBoxPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PostOfficeBankAccount</b>
     * </p>
     *
     * @return PO Bank Current Acct No. or Building Society Ref. No.
     */
    @SerializedName( "PostOfficeBankAccount" )
    @JsonProperty( "PostOfficeBankAccount" )
    @Nullable
    @ODataField( odataName = "PostOfficeBankAccount" )
    private String postOfficeBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>PostOfficeBankAccount</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> POST_OFFICE_BANK_ACCOUNT =
        new SuplrInvoiceAdditionalDataField<String>("PostOfficeBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BankAccount</b>
     * </p>
     *
     * @return Bank Account Number
     */
    @SerializedName( "BankAccount" )
    @JsonProperty( "BankAccount" )
    @Nullable
    @ODataField( odataName = "BankAccount" )
    private String bankAccount;
    /**
     * Use with available fluent helpers to apply the <b>BankAccount</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> BANK_ACCOUNT =
        new SuplrInvoiceAdditionalDataField<String>("BankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Bank</b>
     * </p>
     *
     * @return Bank Number
     */
    @SerializedName( "Bank" )
    @JsonProperty( "Bank" )
    @Nullable
    @ODataField( odataName = "Bank" )
    private String bank;
    /**
     * Use with available fluent helpers to apply the <b>Bank</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> BANK =
        new SuplrInvoiceAdditionalDataField<String>("Bank");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BankCountry</b>
     * </p>
     *
     * @return Country/Region Key of Bank
     */
    @SerializedName( "BankCountry" )
    @JsonProperty( "BankCountry" )
    @Nullable
    @ODataField( odataName = "BankCountry" )
    private String bankCountry;
    /**
     * Use with available fluent helpers to apply the <b>BankCountry</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> BANK_COUNTRY =
        new SuplrInvoiceAdditionalDataField<String>("BankCountry");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>TaxID1</b>
     * </p>
     *
     * @return Tax Number 1
     */
    @SerializedName( "TaxID1" )
    @JsonProperty( "TaxID1" )
    @Nullable
    @ODataField( odataName = "TaxID1" )
    private String taxID1;
    /**
     * Use with available fluent helpers to apply the <b>TaxID1</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> TAX_I_D1 =
        new SuplrInvoiceAdditionalDataField<String>("TaxID1");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>TaxID2</b>
     * </p>
     *
     * @return Tax Number 2
     */
    @SerializedName( "TaxID2" )
    @JsonProperty( "TaxID2" )
    @Nullable
    @ODataField( odataName = "TaxID2" )
    private String taxID2;
    /**
     * Use with available fluent helpers to apply the <b>TaxID2</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> TAX_I_D2 =
        new SuplrInvoiceAdditionalDataField<String>("TaxID2");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OneTmeAccountIsVATLiable</b>
     * </p>
     *
     * @return Liable for VAT
     */
    @SerializedName( "OneTmeAccountIsVATLiable" )
    @JsonProperty( "OneTmeAccountIsVATLiable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OneTmeAccountIsVATLiable" )
    private Boolean oneTmeAccountIsVATLiable;
    /**
     * Use with available fluent helpers to apply the <b>OneTmeAccountIsVATLiable</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<Boolean> ONE_TME_ACCOUNT_IS_VAT_LIABLE =
        new SuplrInvoiceAdditionalDataField<Boolean>("OneTmeAccountIsVATLiable");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OneTmeAcctIsEqualizationTxSubj</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "OneTmeAcctIsEqualizationTxSubj" )
    @JsonProperty( "OneTmeAcctIsEqualizationTxSubj" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OneTmeAcctIsEqualizationTxSubj" )
    private Boolean oneTmeAcctIsEqualizationTxSubj;
    /**
     * Use with available fluent helpers to apply the <b>OneTmeAcctIsEqualizationTxSubj</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<Boolean> ONE_TME_ACCT_IS_EQUALIZATION_TX_SUBJ =
        new SuplrInvoiceAdditionalDataField<Boolean>("OneTmeAcctIsEqualizationTxSubj");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> REGION =
        new SuplrInvoiceAdditionalDataField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BankControlKey</b>
     * </p>
     *
     * @return Bank Control Key
     */
    @SerializedName( "BankControlKey" )
    @JsonProperty( "BankControlKey" )
    @Nullable
    @ODataField( odataName = "BankControlKey" )
    private String bankControlKey;
    /**
     * Use with available fluent helpers to apply the <b>BankControlKey</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> BANK_CONTROL_KEY =
        new SuplrInvoiceAdditionalDataField<String>("BankControlKey");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DataExchangeInstructionKey</b>
     * </p>
     *
     * @return Instruction Key for Data Medium Exchange
     */
    @SerializedName( "DataExchangeInstructionKey" )
    @JsonProperty( "DataExchangeInstructionKey" )
    @Nullable
    @ODataField( odataName = "DataExchangeInstructionKey" )
    private String dataExchangeInstructionKey;
    /**
     * Use with available fluent helpers to apply the <b>DataExchangeInstructionKey</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> DATA_EXCHANGE_INSTRUCTION_KEY =
        new SuplrInvoiceAdditionalDataField<String>("DataExchangeInstructionKey");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DataMediumExchangeIndicator</b>
     * </p>
     *
     * @return Recipient Code for Data Medium Exchange
     */
    @SerializedName( "DataMediumExchangeIndicator" )
    @JsonProperty( "DataMediumExchangeIndicator" )
    @Nullable
    @ODataField( odataName = "DataMediumExchangeIndicator" )
    private String dataMediumExchangeIndicator;
    /**
     * Use with available fluent helpers to apply the <b>DataMediumExchangeIndicator</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> DATA_MEDIUM_EXCHANGE_INDICATOR =
        new SuplrInvoiceAdditionalDataField<String>("DataMediumExchangeIndicator");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LanguageCode</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "LanguageCode" )
    @JsonProperty( "LanguageCode" )
    @Nullable
    @ODataField( odataName = "LanguageCode" )
    private String languageCode;
    /**
     * Use with available fluent helpers to apply the <b>LanguageCode</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> LANGUAGE_CODE =
        new SuplrInvoiceAdditionalDataField<String>("LanguageCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOneTimeAccount</b>
     * </p>
     *
     * @return Indicator: Is the Account a One-Time Account?
     */
    @SerializedName( "IsOneTimeAccount" )
    @JsonProperty( "IsOneTimeAccount" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsOneTimeAccount" )
    private Boolean isOneTimeAccount;
    /**
     * Use with available fluent helpers to apply the <b>IsOneTimeAccount</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<Boolean> IS_ONE_TIME_ACCOUNT =
        new SuplrInvoiceAdditionalDataField<Boolean>("IsOneTimeAccount");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PaymentRecipient</b>
     * </p>
     *
     * @return Payment Recipient Code
     */
    @SerializedName( "PaymentRecipient" )
    @JsonProperty( "PaymentRecipient" )
    @Nullable
    @ODataField( odataName = "PaymentRecipient" )
    private String paymentRecipient;
    /**
     * Use with available fluent helpers to apply the <b>PaymentRecipient</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> PAYMENT_RECIPIENT =
        new SuplrInvoiceAdditionalDataField<String>("PaymentRecipient");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountTaxType</b>
     * </p>
     *
     * @return Tax Type
     */
    @SerializedName( "AccountTaxType" )
    @JsonProperty( "AccountTaxType" )
    @Nullable
    @ODataField( odataName = "AccountTaxType" )
    private String accountTaxType;
    /**
     * Use with available fluent helpers to apply the <b>AccountTaxType</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> ACCOUNT_TAX_TYPE =
        new SuplrInvoiceAdditionalDataField<String>("AccountTaxType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxNumberType</b>
     * </p>
     *
     * @return Tax Number Type
     */
    @SerializedName( "TaxNumberType" )
    @JsonProperty( "TaxNumberType" )
    @Nullable
    @ODataField( odataName = "TaxNumberType" )
    private String taxNumberType;
    /**
     * Use with available fluent helpers to apply the <b>TaxNumberType</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> TAX_NUMBER_TYPE =
        new SuplrInvoiceAdditionalDataField<String>("TaxNumberType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNaturalPerson</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "IsNaturalPerson" )
    @JsonProperty( "IsNaturalPerson" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsNaturalPerson" )
    private Boolean isNaturalPerson;
    /**
     * Use with available fluent helpers to apply the <b>IsNaturalPerson</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<Boolean> IS_NATURAL_PERSON =
        new SuplrInvoiceAdditionalDataField<Boolean>("IsNaturalPerson");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>TaxID3</b>
     * </p>
     *
     * @return Tax Number 3
     */
    @SerializedName( "TaxID3" )
    @JsonProperty( "TaxID3" )
    @Nullable
    @ODataField( odataName = "TaxID3" )
    private String taxID3;
    /**
     * Use with available fluent helpers to apply the <b>TaxID3</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> TAX_I_D3 =
        new SuplrInvoiceAdditionalDataField<String>("TaxID3");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>TaxID4</b>
     * </p>
     *
     * @return Tax Number 4
     */
    @SerializedName( "TaxID4" )
    @JsonProperty( "TaxID4" )
    @Nullable
    @ODataField( odataName = "TaxID4" )
    private String taxID4;
    /**
     * Use with available fluent helpers to apply the <b>TaxID4</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> TAX_I_D4 =
        new SuplrInvoiceAdditionalDataField<String>("TaxID4");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BankDetailReference</b>
     * </p>
     *
     * @return Reference Details for Bank Details
     */
    @SerializedName( "BankDetailReference" )
    @JsonProperty( "BankDetailReference" )
    @Nullable
    @ODataField( odataName = "BankDetailReference" )
    private String bankDetailReference;
    /**
     * Use with available fluent helpers to apply the <b>BankDetailReference</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> BANK_DETAIL_REFERENCE =
        new SuplrInvoiceAdditionalDataField<String>("BankDetailReference");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RepresentativeName</b>
     * </p>
     *
     * @return Name of Representative
     */
    @SerializedName( "RepresentativeName" )
    @JsonProperty( "RepresentativeName" )
    @Nullable
    @ODataField( odataName = "RepresentativeName" )
    private String representativeName;
    /**
     * Use with available fluent helpers to apply the <b>RepresentativeName</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> REPRESENTATIVE_NAME =
        new SuplrInvoiceAdditionalDataField<String>("RepresentativeName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessType</b>
     * </p>
     *
     * @return Type of Business
     */
    @SerializedName( "BusinessType" )
    @JsonProperty( "BusinessType" )
    @Nullable
    @ODataField( odataName = "BusinessType" )
    private String businessType;
    /**
     * Use with available fluent helpers to apply the <b>BusinessType</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> BUSINESS_TYPE =
        new SuplrInvoiceAdditionalDataField<String>("BusinessType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>IndustryType</b>
     * </p>
     *
     * @return Type of Industry
     */
    @SerializedName( "IndustryType" )
    @JsonProperty( "IndustryType" )
    @Nullable
    @ODataField( odataName = "IndustryType" )
    private String industryType;
    /**
     * Use with available fluent helpers to apply the <b>IndustryType</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> INDUSTRY_TYPE =
        new SuplrInvoiceAdditionalDataField<String>("IndustryType");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddressName</b>
     * </p>
     *
     * @return Title
     */
    @SerializedName( "FormOfAddressName" )
    @JsonProperty( "FormOfAddressName" )
    @Nullable
    @ODataField( odataName = "FormOfAddressName" )
    private String formOfAddressName;
    /**
     * Use with available fluent helpers to apply the <b>FormOfAddressName</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> FORM_OF_ADDRESS_NAME =
        new SuplrInvoiceAdditionalDataField<String>("FormOfAddressName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistration</b>
     * </p>
     *
     * @return VAT Registration Number
     */
    @SerializedName( "VATRegistration" )
    @JsonProperty( "VATRegistration" )
    @Nullable
    @ODataField( odataName = "VATRegistration" )
    private String vATRegistration;
    /**
     * Use with available fluent helpers to apply the <b>VATRegistration</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> VAT_REGISTRATION =
        new SuplrInvoiceAdditionalDataField<String>("VATRegistration");
    /**
     * Constraints: Not nullable, Maximum length: 140
     * <p>
     * Original property name from the Odata EDM: <b>OneTimeAcctCntrySpecificRef1</b>
     * </p>
     *
     * @return Country/Region specific Ref. in the One Time Account Data
     */
    @SerializedName( "OneTimeAcctCntrySpecificRef1" )
    @JsonProperty( "OneTimeAcctCntrySpecificRef1" )
    @Nullable
    @ODataField( odataName = "OneTimeAcctCntrySpecificRef1" )
    private String oneTimeAcctCntrySpecificRef1;
    /**
     * Use with available fluent helpers to apply the <b>OneTimeAcctCntrySpecificRef1</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> ONE_TIME_ACCT_CNTRY_SPECIFIC_REF1 =
        new SuplrInvoiceAdditionalDataField<String>("OneTimeAcctCntrySpecificRef1");
    /**
     * Constraints: Not nullable, Maximum length: 34
     * <p>
     * Original property name from the Odata EDM: <b>IBAN</b>
     * </p>
     *
     * @return IBAN (International Bank Account Number)
     */
    @SerializedName( "IBAN" )
    @JsonProperty( "IBAN" )
    @Nullable
    @ODataField( odataName = "IBAN" )
    private String iBAN;
    /**
     * Use with available fluent helpers to apply the <b>IBAN</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> IBAN =
        new SuplrInvoiceAdditionalDataField<String>("IBAN");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>SWIFTCode</b>
     * </p>
     *
     * @return SWIFT/BIC for International Payments
     */
    @SerializedName( "SWIFTCode" )
    @JsonProperty( "SWIFTCode" )
    @Nullable
    @ODataField( odataName = "SWIFTCode" )
    private String sWIFTCode;
    /**
     * Use with available fluent helpers to apply the <b>SWIFTCode</b> field to query operations.
     *
     */
    public final static SuplrInvoiceAdditionalDataField<String> SWIFT_CODE =
        new SuplrInvoiceAdditionalDataField<String>("SWIFTCode");

    @Nonnull
    @Override
    public Class<SuplrInvoiceAdditionalData> getType()
    {
        return SuplrInvoiceAdditionalData.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierInvoice</b>
     * </p>
     *
     * @param supplierInvoice
     *            Document Number of an Invoice Document
     */
    public void setSupplierInvoice( @Nullable final String supplierInvoice )
    {
        rememberChangedField("SupplierInvoice", this.supplierInvoice);
        this.supplierInvoice = supplierInvoice;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingPartyName1</b>
     * </p>
     *
     * @param invoicingPartyName1
     *            Name 1
     */
    public void setInvoicingPartyName1( @Nullable final String invoicingPartyName1 )
    {
        rememberChangedField("InvoicingPartyName1", this.invoicingPartyName1);
        this.invoicingPartyName1 = invoicingPartyName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingPartyName2</b>
     * </p>
     *
     * @param invoicingPartyName2
     *            Name 2
     */
    public void setInvoicingPartyName2( @Nullable final String invoicingPartyName2 )
    {
        rememberChangedField("InvoicingPartyName2", this.invoicingPartyName2);
        this.invoicingPartyName2 = invoicingPartyName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingPartyName3</b>
     * </p>
     *
     * @param invoicingPartyName3
     *            Name 3
     */
    public void setInvoicingPartyName3( @Nullable final String invoicingPartyName3 )
    {
        rememberChangedField("InvoicingPartyName3", this.invoicingPartyName3);
        this.invoicingPartyName3 = invoicingPartyName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingPartyName4</b>
     * </p>
     *
     * @param invoicingPartyName4
     *            Name 4
     */
    public void setInvoicingPartyName4( @Nullable final String invoicingPartyName4 )
    {
        rememberChangedField("InvoicingPartyName4", this.invoicingPartyName4);
        this.invoicingPartyName4 = invoicingPartyName4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StreetAddressName</b>
     * </p>
     *
     * @param streetAddressName
     *            Street and House Number
     */
    public void setStreetAddressName( @Nullable final String streetAddressName )
    {
        rememberChangedField("StreetAddressName", this.streetAddressName);
        this.streetAddressName = streetAddressName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @param pOBox
     *            PO Box
     */
    public void setPOBox( @Nullable final String pOBox )
    {
        rememberChangedField("POBox", this.pOBox);
        this.pOBox = pOBox;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBoxPostalCode</b>
     * </p>
     *
     * @param pOBoxPostalCode
     *            P.O. Box Postal Code
     */
    public void setPOBoxPostalCode( @Nullable final String pOBoxPostalCode )
    {
        rememberChangedField("POBoxPostalCode", this.pOBoxPostalCode);
        this.pOBoxPostalCode = pOBoxPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PostOfficeBankAccount</b>
     * </p>
     *
     * @param postOfficeBankAccount
     *            PO Bank Current Acct No. or Building Society Ref. No.
     */
    public void setPostOfficeBankAccount( @Nullable final String postOfficeBankAccount )
    {
        rememberChangedField("PostOfficeBankAccount", this.postOfficeBankAccount);
        this.postOfficeBankAccount = postOfficeBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BankAccount</b>
     * </p>
     *
     * @param bankAccount
     *            Bank Account Number
     */
    public void setBankAccount( @Nullable final String bankAccount )
    {
        rememberChangedField("BankAccount", this.bankAccount);
        this.bankAccount = bankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Bank</b>
     * </p>
     *
     * @param bank
     *            Bank Number
     */
    public void setBank( @Nullable final String bank )
    {
        rememberChangedField("Bank", this.bank);
        this.bank = bank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BankCountry</b>
     * </p>
     *
     * @param bankCountry
     *            Country/Region Key of Bank
     */
    public void setBankCountry( @Nullable final String bankCountry )
    {
        rememberChangedField("BankCountry", this.bankCountry);
        this.bankCountry = bankCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>TaxID1</b>
     * </p>
     *
     * @param taxID1
     *            Tax Number 1
     */
    public void setTaxID1( @Nullable final String taxID1 )
    {
        rememberChangedField("TaxID1", this.taxID1);
        this.taxID1 = taxID1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>TaxID2</b>
     * </p>
     *
     * @param taxID2
     *            Tax Number 2
     */
    public void setTaxID2( @Nullable final String taxID2 )
    {
        rememberChangedField("TaxID2", this.taxID2);
        this.taxID2 = taxID2;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OneTmeAccountIsVATLiable</b>
     * </p>
     *
     * @param oneTmeAccountIsVATLiable
     *            Liable for VAT
     */
    public void setOneTmeAccountIsVATLiable( @Nullable final Boolean oneTmeAccountIsVATLiable )
    {
        rememberChangedField("OneTmeAccountIsVATLiable", this.oneTmeAccountIsVATLiable);
        this.oneTmeAccountIsVATLiable = oneTmeAccountIsVATLiable;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OneTmeAcctIsEqualizationTxSubj</b>
     * </p>
     *
     * @param oneTmeAcctIsEqualizationTxSubj
     *            Checkbox
     */
    public void setOneTmeAcctIsEqualizationTxSubj( @Nullable final Boolean oneTmeAcctIsEqualizationTxSubj )
    {
        rememberChangedField("OneTmeAcctIsEqualizationTxSubj", this.oneTmeAcctIsEqualizationTxSubj);
        this.oneTmeAcctIsEqualizationTxSubj = oneTmeAcctIsEqualizationTxSubj;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BankControlKey</b>
     * </p>
     *
     * @param bankControlKey
     *            Bank Control Key
     */
    public void setBankControlKey( @Nullable final String bankControlKey )
    {
        rememberChangedField("BankControlKey", this.bankControlKey);
        this.bankControlKey = bankControlKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DataExchangeInstructionKey</b>
     * </p>
     *
     * @param dataExchangeInstructionKey
     *            Instruction Key for Data Medium Exchange
     */
    public void setDataExchangeInstructionKey( @Nullable final String dataExchangeInstructionKey )
    {
        rememberChangedField("DataExchangeInstructionKey", this.dataExchangeInstructionKey);
        this.dataExchangeInstructionKey = dataExchangeInstructionKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DataMediumExchangeIndicator</b>
     * </p>
     *
     * @param dataMediumExchangeIndicator
     *            Recipient Code for Data Medium Exchange
     */
    public void setDataMediumExchangeIndicator( @Nullable final String dataMediumExchangeIndicator )
    {
        rememberChangedField("DataMediumExchangeIndicator", this.dataMediumExchangeIndicator);
        this.dataMediumExchangeIndicator = dataMediumExchangeIndicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LanguageCode</b>
     * </p>
     *
     * @param languageCode
     *            Language Key
     */
    public void setLanguageCode( @Nullable final String languageCode )
    {
        rememberChangedField("LanguageCode", this.languageCode);
        this.languageCode = languageCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOneTimeAccount</b>
     * </p>
     *
     * @param isOneTimeAccount
     *            Indicator: Is the Account a One-Time Account?
     */
    public void setIsOneTimeAccount( @Nullable final Boolean isOneTimeAccount )
    {
        rememberChangedField("IsOneTimeAccount", this.isOneTimeAccount);
        this.isOneTimeAccount = isOneTimeAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PaymentRecipient</b>
     * </p>
     *
     * @param paymentRecipient
     *            Payment Recipient Code
     */
    public void setPaymentRecipient( @Nullable final String paymentRecipient )
    {
        rememberChangedField("PaymentRecipient", this.paymentRecipient);
        this.paymentRecipient = paymentRecipient;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountTaxType</b>
     * </p>
     *
     * @param accountTaxType
     *            Tax Type
     */
    public void setAccountTaxType( @Nullable final String accountTaxType )
    {
        rememberChangedField("AccountTaxType", this.accountTaxType);
        this.accountTaxType = accountTaxType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxNumberType</b>
     * </p>
     *
     * @param taxNumberType
     *            Tax Number Type
     */
    public void setTaxNumberType( @Nullable final String taxNumberType )
    {
        rememberChangedField("TaxNumberType", this.taxNumberType);
        this.taxNumberType = taxNumberType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNaturalPerson</b>
     * </p>
     *
     * @param isNaturalPerson
     *            Checkbox
     */
    public void setIsNaturalPerson( @Nullable final Boolean isNaturalPerson )
    {
        rememberChangedField("IsNaturalPerson", this.isNaturalPerson);
        this.isNaturalPerson = isNaturalPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>TaxID3</b>
     * </p>
     *
     * @param taxID3
     *            Tax Number 3
     */
    public void setTaxID3( @Nullable final String taxID3 )
    {
        rememberChangedField("TaxID3", this.taxID3);
        this.taxID3 = taxID3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>TaxID4</b>
     * </p>
     *
     * @param taxID4
     *            Tax Number 4
     */
    public void setTaxID4( @Nullable final String taxID4 )
    {
        rememberChangedField("TaxID4", this.taxID4);
        this.taxID4 = taxID4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BankDetailReference</b>
     * </p>
     *
     * @param bankDetailReference
     *            Reference Details for Bank Details
     */
    public void setBankDetailReference( @Nullable final String bankDetailReference )
    {
        rememberChangedField("BankDetailReference", this.bankDetailReference);
        this.bankDetailReference = bankDetailReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RepresentativeName</b>
     * </p>
     *
     * @param representativeName
     *            Name of Representative
     */
    public void setRepresentativeName( @Nullable final String representativeName )
    {
        rememberChangedField("RepresentativeName", this.representativeName);
        this.representativeName = representativeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessType</b>
     * </p>
     *
     * @param businessType
     *            Type of Business
     */
    public void setBusinessType( @Nullable final String businessType )
    {
        rememberChangedField("BusinessType", this.businessType);
        this.businessType = businessType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>IndustryType</b>
     * </p>
     *
     * @param industryType
     *            Type of Industry
     */
    public void setIndustryType( @Nullable final String industryType )
    {
        rememberChangedField("IndustryType", this.industryType);
        this.industryType = industryType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddressName</b>
     * </p>
     *
     * @param formOfAddressName
     *            Title
     */
    public void setFormOfAddressName( @Nullable final String formOfAddressName )
    {
        rememberChangedField("FormOfAddressName", this.formOfAddressName);
        this.formOfAddressName = formOfAddressName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistration</b>
     * </p>
     *
     * @param vATRegistration
     *            VAT Registration Number
     */
    public void setVATRegistration( @Nullable final String vATRegistration )
    {
        rememberChangedField("VATRegistration", this.vATRegistration);
        this.vATRegistration = vATRegistration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 140
     * <p>
     * Original property name from the Odata EDM: <b>OneTimeAcctCntrySpecificRef1</b>
     * </p>
     *
     * @param oneTimeAcctCntrySpecificRef1
     *            Country/Region specific Ref. in the One Time Account Data
     */
    public void setOneTimeAcctCntrySpecificRef1( @Nullable final String oneTimeAcctCntrySpecificRef1 )
    {
        rememberChangedField("OneTimeAcctCntrySpecificRef1", this.oneTimeAcctCntrySpecificRef1);
        this.oneTimeAcctCntrySpecificRef1 = oneTimeAcctCntrySpecificRef1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 34
     * <p>
     * Original property name from the Odata EDM: <b>IBAN</b>
     * </p>
     *
     * @param iBAN
     *            IBAN (International Bank Account Number)
     */
    public void setIBAN( @Nullable final String iBAN )
    {
        rememberChangedField("IBAN", this.iBAN);
        this.iBAN = iBAN;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>SWIFTCode</b>
     * </p>
     *
     * @param sWIFTCode
     *            SWIFT/BIC for International Payments
     */
    public void setSWIFTCode( @Nullable final String sWIFTCode )
    {
        rememberChangedField("SWIFTCode", this.sWIFTCode);
        this.sWIFTCode = sWIFTCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SuplrInvoiceAdditionalData";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SupplierInvoice", getSupplierInvoice());
        result.put("FiscalYear", getFiscalYear());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SupplierInvoice", getSupplierInvoice());
        values.put("FiscalYear", getFiscalYear());
        values.put("InvoicingPartyName1", getInvoicingPartyName1());
        values.put("InvoicingPartyName2", getInvoicingPartyName2());
        values.put("InvoicingPartyName3", getInvoicingPartyName3());
        values.put("InvoicingPartyName4", getInvoicingPartyName4());
        values.put("PostalCode", getPostalCode());
        values.put("CityName", getCityName());
        values.put("Country", getCountry());
        values.put("StreetAddressName", getStreetAddressName());
        values.put("POBox", getPOBox());
        values.put("POBoxPostalCode", getPOBoxPostalCode());
        values.put("PostOfficeBankAccount", getPostOfficeBankAccount());
        values.put("BankAccount", getBankAccount());
        values.put("Bank", getBank());
        values.put("BankCountry", getBankCountry());
        values.put("TaxID1", getTaxID1());
        values.put("TaxID2", getTaxID2());
        values.put("OneTmeAccountIsVATLiable", getOneTmeAccountIsVATLiable());
        values.put("OneTmeAcctIsEqualizationTxSubj", getOneTmeAcctIsEqualizationTxSubj());
        values.put("Region", getRegion());
        values.put("BankControlKey", getBankControlKey());
        values.put("DataExchangeInstructionKey", getDataExchangeInstructionKey());
        values.put("DataMediumExchangeIndicator", getDataMediumExchangeIndicator());
        values.put("LanguageCode", getLanguageCode());
        values.put("IsOneTimeAccount", getIsOneTimeAccount());
        values.put("PaymentRecipient", getPaymentRecipient());
        values.put("AccountTaxType", getAccountTaxType());
        values.put("TaxNumberType", getTaxNumberType());
        values.put("IsNaturalPerson", getIsNaturalPerson());
        values.put("TaxID3", getTaxID3());
        values.put("TaxID4", getTaxID4());
        values.put("BankDetailReference", getBankDetailReference());
        values.put("RepresentativeName", getRepresentativeName());
        values.put("BusinessType", getBusinessType());
        values.put("IndustryType", getIndustryType());
        values.put("FormOfAddressName", getFormOfAddressName());
        values.put("VATRegistration", getVATRegistration());
        values.put("OneTimeAcctCntrySpecificRef1", getOneTimeAcctCntrySpecificRef1());
        values.put("IBAN", getIBAN());
        values.put("SWIFTCode", getSWIFTCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplierInvoice") ) {
                final Object value = values.remove("SupplierInvoice");
                if( (value == null) || (!value.equals(getSupplierInvoice())) ) {
                    setSupplierInvoice(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("InvoicingPartyName1") ) {
                final Object value = values.remove("InvoicingPartyName1");
                if( (value == null) || (!value.equals(getInvoicingPartyName1())) ) {
                    setInvoicingPartyName1(((String) value));
                }
            }
            if( values.containsKey("InvoicingPartyName2") ) {
                final Object value = values.remove("InvoicingPartyName2");
                if( (value == null) || (!value.equals(getInvoicingPartyName2())) ) {
                    setInvoicingPartyName2(((String) value));
                }
            }
            if( values.containsKey("InvoicingPartyName3") ) {
                final Object value = values.remove("InvoicingPartyName3");
                if( (value == null) || (!value.equals(getInvoicingPartyName3())) ) {
                    setInvoicingPartyName3(((String) value));
                }
            }
            if( values.containsKey("InvoicingPartyName4") ) {
                final Object value = values.remove("InvoicingPartyName4");
                if( (value == null) || (!value.equals(getInvoicingPartyName4())) ) {
                    setInvoicingPartyName4(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("StreetAddressName") ) {
                final Object value = values.remove("StreetAddressName");
                if( (value == null) || (!value.equals(getStreetAddressName())) ) {
                    setStreetAddressName(((String) value));
                }
            }
            if( values.containsKey("POBox") ) {
                final Object value = values.remove("POBox");
                if( (value == null) || (!value.equals(getPOBox())) ) {
                    setPOBox(((String) value));
                }
            }
            if( values.containsKey("POBoxPostalCode") ) {
                final Object value = values.remove("POBoxPostalCode");
                if( (value == null) || (!value.equals(getPOBoxPostalCode())) ) {
                    setPOBoxPostalCode(((String) value));
                }
            }
            if( values.containsKey("PostOfficeBankAccount") ) {
                final Object value = values.remove("PostOfficeBankAccount");
                if( (value == null) || (!value.equals(getPostOfficeBankAccount())) ) {
                    setPostOfficeBankAccount(((String) value));
                }
            }
            if( values.containsKey("BankAccount") ) {
                final Object value = values.remove("BankAccount");
                if( (value == null) || (!value.equals(getBankAccount())) ) {
                    setBankAccount(((String) value));
                }
            }
            if( values.containsKey("Bank") ) {
                final Object value = values.remove("Bank");
                if( (value == null) || (!value.equals(getBank())) ) {
                    setBank(((String) value));
                }
            }
            if( values.containsKey("BankCountry") ) {
                final Object value = values.remove("BankCountry");
                if( (value == null) || (!value.equals(getBankCountry())) ) {
                    setBankCountry(((String) value));
                }
            }
            if( values.containsKey("TaxID1") ) {
                final Object value = values.remove("TaxID1");
                if( (value == null) || (!value.equals(getTaxID1())) ) {
                    setTaxID1(((String) value));
                }
            }
            if( values.containsKey("TaxID2") ) {
                final Object value = values.remove("TaxID2");
                if( (value == null) || (!value.equals(getTaxID2())) ) {
                    setTaxID2(((String) value));
                }
            }
            if( values.containsKey("OneTmeAccountIsVATLiable") ) {
                final Object value = values.remove("OneTmeAccountIsVATLiable");
                if( (value == null) || (!value.equals(getOneTmeAccountIsVATLiable())) ) {
                    setOneTmeAccountIsVATLiable(((Boolean) value));
                }
            }
            if( values.containsKey("OneTmeAcctIsEqualizationTxSubj") ) {
                final Object value = values.remove("OneTmeAcctIsEqualizationTxSubj");
                if( (value == null) || (!value.equals(getOneTmeAcctIsEqualizationTxSubj())) ) {
                    setOneTmeAcctIsEqualizationTxSubj(((Boolean) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("BankControlKey") ) {
                final Object value = values.remove("BankControlKey");
                if( (value == null) || (!value.equals(getBankControlKey())) ) {
                    setBankControlKey(((String) value));
                }
            }
            if( values.containsKey("DataExchangeInstructionKey") ) {
                final Object value = values.remove("DataExchangeInstructionKey");
                if( (value == null) || (!value.equals(getDataExchangeInstructionKey())) ) {
                    setDataExchangeInstructionKey(((String) value));
                }
            }
            if( values.containsKey("DataMediumExchangeIndicator") ) {
                final Object value = values.remove("DataMediumExchangeIndicator");
                if( (value == null) || (!value.equals(getDataMediumExchangeIndicator())) ) {
                    setDataMediumExchangeIndicator(((String) value));
                }
            }
            if( values.containsKey("LanguageCode") ) {
                final Object value = values.remove("LanguageCode");
                if( (value == null) || (!value.equals(getLanguageCode())) ) {
                    setLanguageCode(((String) value));
                }
            }
            if( values.containsKey("IsOneTimeAccount") ) {
                final Object value = values.remove("IsOneTimeAccount");
                if( (value == null) || (!value.equals(getIsOneTimeAccount())) ) {
                    setIsOneTimeAccount(((Boolean) value));
                }
            }
            if( values.containsKey("PaymentRecipient") ) {
                final Object value = values.remove("PaymentRecipient");
                if( (value == null) || (!value.equals(getPaymentRecipient())) ) {
                    setPaymentRecipient(((String) value));
                }
            }
            if( values.containsKey("AccountTaxType") ) {
                final Object value = values.remove("AccountTaxType");
                if( (value == null) || (!value.equals(getAccountTaxType())) ) {
                    setAccountTaxType(((String) value));
                }
            }
            if( values.containsKey("TaxNumberType") ) {
                final Object value = values.remove("TaxNumberType");
                if( (value == null) || (!value.equals(getTaxNumberType())) ) {
                    setTaxNumberType(((String) value));
                }
            }
            if( values.containsKey("IsNaturalPerson") ) {
                final Object value = values.remove("IsNaturalPerson");
                if( (value == null) || (!value.equals(getIsNaturalPerson())) ) {
                    setIsNaturalPerson(((Boolean) value));
                }
            }
            if( values.containsKey("TaxID3") ) {
                final Object value = values.remove("TaxID3");
                if( (value == null) || (!value.equals(getTaxID3())) ) {
                    setTaxID3(((String) value));
                }
            }
            if( values.containsKey("TaxID4") ) {
                final Object value = values.remove("TaxID4");
                if( (value == null) || (!value.equals(getTaxID4())) ) {
                    setTaxID4(((String) value));
                }
            }
            if( values.containsKey("BankDetailReference") ) {
                final Object value = values.remove("BankDetailReference");
                if( (value == null) || (!value.equals(getBankDetailReference())) ) {
                    setBankDetailReference(((String) value));
                }
            }
            if( values.containsKey("RepresentativeName") ) {
                final Object value = values.remove("RepresentativeName");
                if( (value == null) || (!value.equals(getRepresentativeName())) ) {
                    setRepresentativeName(((String) value));
                }
            }
            if( values.containsKey("BusinessType") ) {
                final Object value = values.remove("BusinessType");
                if( (value == null) || (!value.equals(getBusinessType())) ) {
                    setBusinessType(((String) value));
                }
            }
            if( values.containsKey("IndustryType") ) {
                final Object value = values.remove("IndustryType");
                if( (value == null) || (!value.equals(getIndustryType())) ) {
                    setIndustryType(((String) value));
                }
            }
            if( values.containsKey("FormOfAddressName") ) {
                final Object value = values.remove("FormOfAddressName");
                if( (value == null) || (!value.equals(getFormOfAddressName())) ) {
                    setFormOfAddressName(((String) value));
                }
            }
            if( values.containsKey("VATRegistration") ) {
                final Object value = values.remove("VATRegistration");
                if( (value == null) || (!value.equals(getVATRegistration())) ) {
                    setVATRegistration(((String) value));
                }
            }
            if( values.containsKey("OneTimeAcctCntrySpecificRef1") ) {
                final Object value = values.remove("OneTimeAcctCntrySpecificRef1");
                if( (value == null) || (!value.equals(getOneTimeAcctCntrySpecificRef1())) ) {
                    setOneTimeAcctCntrySpecificRef1(((String) value));
                }
            }
            if( values.containsKey("IBAN") ) {
                final Object value = values.remove("IBAN");
                if( (value == null) || (!value.equals(getIBAN())) ) {
                    setIBAN(((String) value));
                }
            }
            if( values.containsKey("SWIFTCode") ) {
                final Object value = values.remove("SWIFTCode");
                if( (value == null) || (!value.equals(getSWIFTCode())) ) {
                    setSWIFTCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SuplrInvoiceAdditionalDataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SuplrInvoiceAdditionalDataField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SuplrInvoiceAdditionalDataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SuplrInvoiceAdditionalDataField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SupplierInvoiceIntegrationService.DEFAULT_SERVICE_PATH);
    }

}
